<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateAnnouncementReq StructType
 * @subpackage Structs
 */
class UpdateAnnouncementReq extends NameAndGUIDRequest
{
    /**
     * The newName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $newName;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $description;
    /**
     * The announcementFile
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $announcementFile;
    /**
     * Constructor method for UpdateAnnouncementReq
     * @uses UpdateAnnouncementReq::setNewName()
     * @uses UpdateAnnouncementReq::setDescription()
     * @uses UpdateAnnouncementReq::setAnnouncementFile()
     * @param string $newName
     * @param string $description
     * @param string $announcementFile
     */
    public function __construct($newName = null, $description = null, $announcementFile = null)
    {
        $this
            ->setNewName($newName)
            ->setDescription($description)
            ->setAnnouncementFile($announcementFile);
    }
    /**
     * Get newName value
     * @return string|null
     */
    public function getNewName()
    {
        return $this->newName;
    }
    /**
     * Set newName value
     * @param string $newName
     * @return UpdateAnnouncementReq
     */
    public function setNewName($newName = null)
    {
        // validation for constraint: string
        if (!is_null($newName) && !is_string($newName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($newName)), __LINE__);
        }
        $this->newName = $newName;
        return $this;
    }
    /**
     * Get description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescription()
    {
        return isset($this->description) ? $this->description : null;
    }
    /**
     * Set description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $description
     * @return UpdateAnnouncementReq
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->description);
        } else {
            $this->description = $description;
        }
        return $this;
    }
    /**
     * Get announcementFile value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAnnouncementFile()
    {
        return isset($this->announcementFile) ? $this->announcementFile : null;
    }
    /**
     * Set announcementFile value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $announcementFile
     * @return UpdateAnnouncementReq
     */
    public function setAnnouncementFile($announcementFile = null)
    {
        // validation for constraint: string
        if (!is_null($announcementFile) && !is_string($announcementFile)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($announcementFile)), __LINE__);
        }
        if (is_null($announcementFile) || (is_array($announcementFile) && empty($announcementFile))) {
            unset($this->announcementFile);
        } else {
            $this->announcementFile = $announcementFile;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return UpdateAnnouncementReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
