<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for subunits StructType
 * @subpackage Structs
 */
class Subunits extends AbstractStructBase
{
    /**
     * The subunit
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: false
     * @var Subunit[]
     */
    public $subunit;
    /**
     * Constructor method for subunits
     * @uses Subunits::setSubunit()
     * @param Subunit[] $subunit
     */
    public function __construct(array $subunit = array())
    {
        $this
            ->setSubunit($subunit);
    }
    /**
     * Get subunit value
     * @return Subunit[]|null
     */
    public function getSubunit()
    {
        return $this->subunit;
    }
    /**
     * Set subunit value
     * @throws \InvalidArgumentException
     * @param Subunit[] $subunit
     * @return Subunits
     */
    public function setSubunit(array $subunit = array())
    {
        foreach ($subunit as $subunitsSubunitItem) {
            // validation for constraint: itemType
            if (!$subunitsSubunitItem instanceof Subunit) {
                throw new \InvalidArgumentException(sprintf('The subunit property can only contain items of Subunit, "%s" given', is_object($subunitsSubunitItem) ? get_class($subunitsSubunitItem) : gettype($subunitsSubunitItem)), __LINE__);
            }
        }
        $this->subunit = $subunit;
        return $this;
    }
    /**
     * Add item to subunit value
     * @throws \InvalidArgumentException
     * @param Subunit $item
     * @return Subunits
     */
    public function addToSubunit(Subunit $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof Subunit) {
            throw new \InvalidArgumentException(sprintf('The subunit property can only contain items of Subunit, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->subunit[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return Subunits
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
