<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for softwareLicenseVersion StructType
 * @subpackage Structs
 */
class SoftwareLicenseVersion extends AbstractStructBase
{
    /**
     * The swVersion
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 50
     * @var string
     */
    public $swVersion;
    /**
     * The status
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $status;
    /**
     * Constructor method for softwareLicenseVersion
     * @uses SoftwareLicenseVersion::setSwVersion()
     * @uses SoftwareLicenseVersion::setStatus()
     * @param string $swVersion
     * @param string $status
     */
    public function __construct($swVersion = null, $status = null)
    {
        $this
            ->setSwVersion($swVersion)
            ->setStatus($status);
    }
    /**
     * Get swVersion value
     * @return string|null
     */
    public function getSwVersion()
    {
        return $this->swVersion;
    }
    /**
     * Set swVersion value
     * @param string $swVersion
     * @return SoftwareLicenseVersion
     */
    public function setSwVersion($swVersion = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($swVersion) && strlen($swVersion) > 50) || (is_array($swVersion) && count($swVersion) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($swVersion) ? strlen($swVersion) : count($swVersion)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($swVersion) && !is_string($swVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($swVersion)), __LINE__);
        }
        $this->swVersion = $swVersion;
        return $this;
    }
    /**
     * Get status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param string $status
     * @return SoftwareLicenseVersion
     */
    public function setStatus($status = null)
    {
        // validation for constraint: pattern
        if (is_scalar($status) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($status, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($status)), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return SoftwareLicenseVersion
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
