<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RemoveCalledPartyTracingReq StructType
 * @subpackage Structs
 */
class RemoveCalledPartyTracingReq extends AbstractStructBase
{
    /**
     * The directorynumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $directorynumber;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * The sequence
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var int
     */
    public $sequence;
    /**
     * Constructor method for RemoveCalledPartyTracingReq
     * @uses RemoveCalledPartyTracingReq::setDirectorynumber()
     * @uses RemoveCalledPartyTracingReq::setUuid()
     * @uses RemoveCalledPartyTracingReq::setSequence()
     * @param string $directorynumber
     * @param string $uuid
     * @param int $sequence
     */
    public function __construct($directorynumber = null, $uuid = null, $sequence = null)
    {
        $this
            ->setDirectorynumber($directorynumber)
            ->setUuid($uuid)
            ->setSequence($sequence);
    }
    /**
     * Get directorynumber value
     * @return string
     */
    public function getDirectorynumber()
    {
        return $this->directorynumber;
    }
    /**
     * Set directorynumber value
     * @param string $directorynumber
     * @return RemoveCalledPartyTracingReq
     */
    public function setDirectorynumber($directorynumber = null)
    {
        // validation for constraint: string
        if (!is_null($directorynumber) && !is_string($directorynumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($directorynumber)), __LINE__);
        }
        $this->directorynumber = $directorynumber;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return RemoveCalledPartyTracingReq
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\{........-....-....-....-............\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Get sequence value
     * @return int|null
     */
    public function getSequence()
    {
        return $this->sequence;
    }
    /**
     * Set sequence value
     * @param int $sequence
     * @return RemoveCalledPartyTracingReq
     */
    public function setSequence($sequence = null)
    {
        // validation for constraint: int
        if (!is_null($sequence) && !is_numeric($sequence)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sequence)), __LINE__);
        }
        $this->sequence = $sequence;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return RemoveCalledPartyTracingReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
