<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RTransPattern StructType
 * @subpackage Structs
 */
class RTransPattern extends AbstractStructBase
{
    /**
     * The pattern
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $pattern;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The usage
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $usage;
    /**
     * The routePartitionName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $routePartitionName;
    /**
     * The blockEnable
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $blockEnable;
    /**
     * The calledPartyTransformationMask
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $calledPartyTransformationMask;
    /**
     * The callingPartyTransformationMask
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callingPartyTransformationMask;
    /**
     * The useCallingPartyPhoneMask
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $useCallingPartyPhoneMask;
    /**
     * The callingPartyPrefixDigits
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 50
     * @var string
     */
    public $callingPartyPrefixDigits;
    /**
     * The dialPlanName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $dialPlanName;
    /**
     * The digitDiscardInstructionName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $digitDiscardInstructionName;
    /**
     * The patternUrgency
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $patternUrgency;
    /**
     * The prefixDigitsOut
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $prefixDigitsOut;
    /**
     * The routeFilterName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $routeFilterName;
    /**
     * The callingLinePresentationBit
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callingLinePresentationBit;
    /**
     * The callingNamePresentationBit
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callingNamePresentationBit;
    /**
     * The connectedLinePresentationBit
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $connectedLinePresentationBit;
    /**
     * The connectedNamePresentationBit
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $connectedNamePresentationBit;
    /**
     * The patternPrecedence
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $patternPrecedence;
    /**
     * The provideOutsideDialtone
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $provideOutsideDialtone;
    /**
     * The callingPartyNumberingPlan
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callingPartyNumberingPlan;
    /**
     * The callingPartyNumberType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callingPartyNumberType;
    /**
     * The calledPartyNumberingPlan
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $calledPartyNumberingPlan;
    /**
     * The calledPartyNumberType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $calledPartyNumberType;
    /**
     * The callingSearchSpaceName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $callingSearchSpaceName;
    /**
     * The resourcePriorityNamespaceName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $resourcePriorityNamespaceName;
    /**
     * The routeNextHopByCgpn
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $routeNextHopByCgpn;
    /**
     * The routeClass
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $routeClass;
    /**
     * The callInterceptProfileName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $callInterceptProfileName;
    /**
     * The releaseClause
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $releaseClause;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RTransPattern
     * @uses RTransPattern::setPattern()
     * @uses RTransPattern::setDescription()
     * @uses RTransPattern::setUsage()
     * @uses RTransPattern::setRoutePartitionName()
     * @uses RTransPattern::setBlockEnable()
     * @uses RTransPattern::setCalledPartyTransformationMask()
     * @uses RTransPattern::setCallingPartyTransformationMask()
     * @uses RTransPattern::setUseCallingPartyPhoneMask()
     * @uses RTransPattern::setCallingPartyPrefixDigits()
     * @uses RTransPattern::setDialPlanName()
     * @uses RTransPattern::setDigitDiscardInstructionName()
     * @uses RTransPattern::setPatternUrgency()
     * @uses RTransPattern::setPrefixDigitsOut()
     * @uses RTransPattern::setRouteFilterName()
     * @uses RTransPattern::setCallingLinePresentationBit()
     * @uses RTransPattern::setCallingNamePresentationBit()
     * @uses RTransPattern::setConnectedLinePresentationBit()
     * @uses RTransPattern::setConnectedNamePresentationBit()
     * @uses RTransPattern::setPatternPrecedence()
     * @uses RTransPattern::setProvideOutsideDialtone()
     * @uses RTransPattern::setCallingPartyNumberingPlan()
     * @uses RTransPattern::setCallingPartyNumberType()
     * @uses RTransPattern::setCalledPartyNumberingPlan()
     * @uses RTransPattern::setCalledPartyNumberType()
     * @uses RTransPattern::setCallingSearchSpaceName()
     * @uses RTransPattern::setResourcePriorityNamespaceName()
     * @uses RTransPattern::setRouteNextHopByCgpn()
     * @uses RTransPattern::setRouteClass()
     * @uses RTransPattern::setCallInterceptProfileName()
     * @uses RTransPattern::setReleaseClause()
     * @uses RTransPattern::setUuid()
     * @param string $pattern
     * @param string $description
     * @param string $usage
     * @param XFkType $routePartitionName
     * @param string $blockEnable
     * @param string $calledPartyTransformationMask
     * @param string $callingPartyTransformationMask
     * @param string $useCallingPartyPhoneMask
     * @param string $callingPartyPrefixDigits
     * @param XFkType $dialPlanName
     * @param XFkType $digitDiscardInstructionName
     * @param string $patternUrgency
     * @param string $prefixDigitsOut
     * @param XFkType $routeFilterName
     * @param string $callingLinePresentationBit
     * @param string $callingNamePresentationBit
     * @param string $connectedLinePresentationBit
     * @param string $connectedNamePresentationBit
     * @param string $patternPrecedence
     * @param string $provideOutsideDialtone
     * @param string $callingPartyNumberingPlan
     * @param string $callingPartyNumberType
     * @param string $calledPartyNumberingPlan
     * @param string $calledPartyNumberType
     * @param XFkType $callingSearchSpaceName
     * @param XFkType $resourcePriorityNamespaceName
     * @param string $routeNextHopByCgpn
     * @param string $routeClass
     * @param XFkType $callInterceptProfileName
     * @param string $releaseClause
     * @param string $uuid
     */
    public function __construct($pattern = null, $description = null, $usage = null, XFkType $routePartitionName = null, $blockEnable = null, $calledPartyTransformationMask = null, $callingPartyTransformationMask = null, $useCallingPartyPhoneMask = null, $callingPartyPrefixDigits = null, XFkType $dialPlanName = null, XFkType $digitDiscardInstructionName = null, $patternUrgency = null, $prefixDigitsOut = null, XFkType $routeFilterName = null, $callingLinePresentationBit = null, $callingNamePresentationBit = null, $connectedLinePresentationBit = null, $connectedNamePresentationBit = null, $patternPrecedence = null, $provideOutsideDialtone = null, $callingPartyNumberingPlan = null, $callingPartyNumberType = null, $calledPartyNumberingPlan = null, $calledPartyNumberType = null, XFkType $callingSearchSpaceName = null, XFkType $resourcePriorityNamespaceName = null, $routeNextHopByCgpn = null, $routeClass = null, XFkType $callInterceptProfileName = null, $releaseClause = null, $uuid = null)
    {
        $this
            ->setPattern($pattern)
            ->setDescription($description)
            ->setUsage($usage)
            ->setRoutePartitionName($routePartitionName)
            ->setBlockEnable($blockEnable)
            ->setCalledPartyTransformationMask($calledPartyTransformationMask)
            ->setCallingPartyTransformationMask($callingPartyTransformationMask)
            ->setUseCallingPartyPhoneMask($useCallingPartyPhoneMask)
            ->setCallingPartyPrefixDigits($callingPartyPrefixDigits)
            ->setDialPlanName($dialPlanName)
            ->setDigitDiscardInstructionName($digitDiscardInstructionName)
            ->setPatternUrgency($patternUrgency)
            ->setPrefixDigitsOut($prefixDigitsOut)
            ->setRouteFilterName($routeFilterName)
            ->setCallingLinePresentationBit($callingLinePresentationBit)
            ->setCallingNamePresentationBit($callingNamePresentationBit)
            ->setConnectedLinePresentationBit($connectedLinePresentationBit)
            ->setConnectedNamePresentationBit($connectedNamePresentationBit)
            ->setPatternPrecedence($patternPrecedence)
            ->setProvideOutsideDialtone($provideOutsideDialtone)
            ->setCallingPartyNumberingPlan($callingPartyNumberingPlan)
            ->setCallingPartyNumberType($callingPartyNumberType)
            ->setCalledPartyNumberingPlan($calledPartyNumberingPlan)
            ->setCalledPartyNumberType($calledPartyNumberType)
            ->setCallingSearchSpaceName($callingSearchSpaceName)
            ->setResourcePriorityNamespaceName($resourcePriorityNamespaceName)
            ->setRouteNextHopByCgpn($routeNextHopByCgpn)
            ->setRouteClass($routeClass)
            ->setCallInterceptProfileName($callInterceptProfileName)
            ->setReleaseClause($releaseClause)
            ->setUuid($uuid);
    }
    /**
     * Get pattern value
     * @return string|null
     */
    public function getPattern()
    {
        return $this->pattern;
    }
    /**
     * Set pattern value
     * @param string $pattern
     * @return RTransPattern
     */
    public function setPattern($pattern = null)
    {
        // validation for constraint: string
        if (!is_null($pattern) && !is_string($pattern)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pattern)), __LINE__);
        }
        $this->pattern = $pattern;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return RTransPattern
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get usage value
     * @return string|null
     */
    public function getUsage()
    {
        return $this->usage;
    }
    /**
     * Set usage value
     * @uses XPatternUsage::valueIsValid()
     * @uses XPatternUsage::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $usage
     * @return RTransPattern
     */
    public function setUsage($usage = null)
    {
        // validation for constraint: enumeration
        if (!XPatternUsage::valueIsValid($usage)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $usage, implode(', ', XPatternUsage::getValidValues())), __LINE__);
        }
        $this->usage = $usage;
        return $this;
    }
    /**
     * Get routePartitionName value
     * @return XFkType|null
     */
    public function getRoutePartitionName()
    {
        return $this->routePartitionName;
    }
    /**
     * Set routePartitionName value
     * @param XFkType $routePartitionName
     * @return RTransPattern
     */
    public function setRoutePartitionName(XFkType $routePartitionName = null)
    {
        $this->routePartitionName = $routePartitionName;
        return $this;
    }
    /**
     * Get blockEnable value
     * @return string|null
     */
    public function getBlockEnable()
    {
        return $this->blockEnable;
    }
    /**
     * Set blockEnable value
     * @param string $blockEnable
     * @return RTransPattern
     */
    public function setBlockEnable($blockEnable = null)
    {
        // validation for constraint: pattern
        if (is_scalar($blockEnable) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $blockEnable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($blockEnable, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($blockEnable) && !is_string($blockEnable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($blockEnable)), __LINE__);
        }
        $this->blockEnable = $blockEnable;
        return $this;
    }
    /**
     * Get calledPartyTransformationMask value
     * @return string|null
     */
    public function getCalledPartyTransformationMask()
    {
        return $this->calledPartyTransformationMask;
    }
    /**
     * Set calledPartyTransformationMask value
     * @param string $calledPartyTransformationMask
     * @return RTransPattern
     */
    public function setCalledPartyTransformationMask($calledPartyTransformationMask = null)
    {
        // validation for constraint: string
        if (!is_null($calledPartyTransformationMask) && !is_string($calledPartyTransformationMask)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($calledPartyTransformationMask)), __LINE__);
        }
        $this->calledPartyTransformationMask = $calledPartyTransformationMask;
        return $this;
    }
    /**
     * Get callingPartyTransformationMask value
     * @return string|null
     */
    public function getCallingPartyTransformationMask()
    {
        return $this->callingPartyTransformationMask;
    }
    /**
     * Set callingPartyTransformationMask value
     * @param string $callingPartyTransformationMask
     * @return RTransPattern
     */
    public function setCallingPartyTransformationMask($callingPartyTransformationMask = null)
    {
        // validation for constraint: string
        if (!is_null($callingPartyTransformationMask) && !is_string($callingPartyTransformationMask)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($callingPartyTransformationMask)), __LINE__);
        }
        $this->callingPartyTransformationMask = $callingPartyTransformationMask;
        return $this;
    }
    /**
     * Get useCallingPartyPhoneMask value
     * @return string|null
     */
    public function getUseCallingPartyPhoneMask()
    {
        return $this->useCallingPartyPhoneMask;
    }
    /**
     * Set useCallingPartyPhoneMask value
     * @uses XStatus::valueIsValid()
     * @uses XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $useCallingPartyPhoneMask
     * @return RTransPattern
     */
    public function setUseCallingPartyPhoneMask($useCallingPartyPhoneMask = null)
    {
        // validation for constraint: enumeration
        if (!XStatus::valueIsValid($useCallingPartyPhoneMask)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $useCallingPartyPhoneMask, implode(', ', XStatus::getValidValues())), __LINE__);
        }
        $this->useCallingPartyPhoneMask = $useCallingPartyPhoneMask;
        return $this;
    }
    /**
     * Get callingPartyPrefixDigits value
     * @return string|null
     */
    public function getCallingPartyPrefixDigits()
    {
        return $this->callingPartyPrefixDigits;
    }
    /**
     * Set callingPartyPrefixDigits value
     * @param string $callingPartyPrefixDigits
     * @return RTransPattern
     */
    public function setCallingPartyPrefixDigits($callingPartyPrefixDigits = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($callingPartyPrefixDigits) && strlen($callingPartyPrefixDigits) > 50) || (is_array($callingPartyPrefixDigits) && count($callingPartyPrefixDigits) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($callingPartyPrefixDigits) ? strlen($callingPartyPrefixDigits) : count($callingPartyPrefixDigits)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($callingPartyPrefixDigits) && !is_string($callingPartyPrefixDigits)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($callingPartyPrefixDigits)), __LINE__);
        }
        $this->callingPartyPrefixDigits = $callingPartyPrefixDigits;
        return $this;
    }
    /**
     * Get dialPlanName value
     * @return XFkType|null
     */
    public function getDialPlanName()
    {
        return $this->dialPlanName;
    }
    /**
     * Set dialPlanName value
     * @param XFkType $dialPlanName
     * @return RTransPattern
     */
    public function setDialPlanName(XFkType $dialPlanName = null)
    {
        $this->dialPlanName = $dialPlanName;
        return $this;
    }
    /**
     * Get digitDiscardInstructionName value
     * @return XFkType|null
     */
    public function getDigitDiscardInstructionName()
    {
        return $this->digitDiscardInstructionName;
    }
    /**
     * Set digitDiscardInstructionName value
     * @param XFkType $digitDiscardInstructionName
     * @return RTransPattern
     */
    public function setDigitDiscardInstructionName(XFkType $digitDiscardInstructionName = null)
    {
        $this->digitDiscardInstructionName = $digitDiscardInstructionName;
        return $this;
    }
    /**
     * Get patternUrgency value
     * @return string|null
     */
    public function getPatternUrgency()
    {
        return $this->patternUrgency;
    }
    /**
     * Set patternUrgency value
     * @param string $patternUrgency
     * @return RTransPattern
     */
    public function setPatternUrgency($patternUrgency = null)
    {
        // validation for constraint: pattern
        if (is_scalar($patternUrgency) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $patternUrgency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($patternUrgency, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($patternUrgency) && !is_string($patternUrgency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($patternUrgency)), __LINE__);
        }
        $this->patternUrgency = $patternUrgency;
        return $this;
    }
    /**
     * Get prefixDigitsOut value
     * @return string|null
     */
    public function getPrefixDigitsOut()
    {
        return $this->prefixDigitsOut;
    }
    /**
     * Set prefixDigitsOut value
     * @param string $prefixDigitsOut
     * @return RTransPattern
     */
    public function setPrefixDigitsOut($prefixDigitsOut = null)
    {
        // validation for constraint: string
        if (!is_null($prefixDigitsOut) && !is_string($prefixDigitsOut)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($prefixDigitsOut)), __LINE__);
        }
        $this->prefixDigitsOut = $prefixDigitsOut;
        return $this;
    }
    /**
     * Get routeFilterName value
     * @return XFkType|null
     */
    public function getRouteFilterName()
    {
        return $this->routeFilterName;
    }
    /**
     * Set routeFilterName value
     * @param XFkType $routeFilterName
     * @return RTransPattern
     */
    public function setRouteFilterName(XFkType $routeFilterName = null)
    {
        $this->routeFilterName = $routeFilterName;
        return $this;
    }
    /**
     * Get callingLinePresentationBit value
     * @return string|null
     */
    public function getCallingLinePresentationBit()
    {
        return $this->callingLinePresentationBit;
    }
    /**
     * Set callingLinePresentationBit value
     * @uses XPresentationBit::valueIsValid()
     * @uses XPresentationBit::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callingLinePresentationBit
     * @return RTransPattern
     */
    public function setCallingLinePresentationBit($callingLinePresentationBit = null)
    {
        // validation for constraint: enumeration
        if (!XPresentationBit::valueIsValid($callingLinePresentationBit)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $callingLinePresentationBit, implode(', ', XPresentationBit::getValidValues())), __LINE__);
        }
        $this->callingLinePresentationBit = $callingLinePresentationBit;
        return $this;
    }
    /**
     * Get callingNamePresentationBit value
     * @return string|null
     */
    public function getCallingNamePresentationBit()
    {
        return $this->callingNamePresentationBit;
    }
    /**
     * Set callingNamePresentationBit value
     * @uses XPresentationBit::valueIsValid()
     * @uses XPresentationBit::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callingNamePresentationBit
     * @return RTransPattern
     */
    public function setCallingNamePresentationBit($callingNamePresentationBit = null)
    {
        // validation for constraint: enumeration
        if (!XPresentationBit::valueIsValid($callingNamePresentationBit)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $callingNamePresentationBit, implode(', ', XPresentationBit::getValidValues())), __LINE__);
        }
        $this->callingNamePresentationBit = $callingNamePresentationBit;
        return $this;
    }
    /**
     * Get connectedLinePresentationBit value
     * @return string|null
     */
    public function getConnectedLinePresentationBit()
    {
        return $this->connectedLinePresentationBit;
    }
    /**
     * Set connectedLinePresentationBit value
     * @uses XPresentationBit::valueIsValid()
     * @uses XPresentationBit::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $connectedLinePresentationBit
     * @return RTransPattern
     */
    public function setConnectedLinePresentationBit($connectedLinePresentationBit = null)
    {
        // validation for constraint: enumeration
        if (!XPresentationBit::valueIsValid($connectedLinePresentationBit)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $connectedLinePresentationBit, implode(', ', XPresentationBit::getValidValues())), __LINE__);
        }
        $this->connectedLinePresentationBit = $connectedLinePresentationBit;
        return $this;
    }
    /**
     * Get connectedNamePresentationBit value
     * @return string|null
     */
    public function getConnectedNamePresentationBit()
    {
        return $this->connectedNamePresentationBit;
    }
    /**
     * Set connectedNamePresentationBit value
     * @uses XPresentationBit::valueIsValid()
     * @uses XPresentationBit::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $connectedNamePresentationBit
     * @return RTransPattern
     */
    public function setConnectedNamePresentationBit($connectedNamePresentationBit = null)
    {
        // validation for constraint: enumeration
        if (!XPresentationBit::valueIsValid($connectedNamePresentationBit)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $connectedNamePresentationBit, implode(', ', XPresentationBit::getValidValues())), __LINE__);
        }
        $this->connectedNamePresentationBit = $connectedNamePresentationBit;
        return $this;
    }
    /**
     * Get patternPrecedence value
     * @return string|null
     */
    public function getPatternPrecedence()
    {
        return $this->patternPrecedence;
    }
    /**
     * Set patternPrecedence value
     * @uses XPatternPrecedence::valueIsValid()
     * @uses XPatternPrecedence::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $patternPrecedence
     * @return RTransPattern
     */
    public function setPatternPrecedence($patternPrecedence = null)
    {
        // validation for constraint: enumeration
        if (!XPatternPrecedence::valueIsValid($patternPrecedence)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $patternPrecedence, implode(', ', XPatternPrecedence::getValidValues())), __LINE__);
        }
        $this->patternPrecedence = $patternPrecedence;
        return $this;
    }
    /**
     * Get provideOutsideDialtone value
     * @return string|null
     */
    public function getProvideOutsideDialtone()
    {
        return $this->provideOutsideDialtone;
    }
    /**
     * Set provideOutsideDialtone value
     * @param string $provideOutsideDialtone
     * @return RTransPattern
     */
    public function setProvideOutsideDialtone($provideOutsideDialtone = null)
    {
        // validation for constraint: pattern
        if (is_scalar($provideOutsideDialtone) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $provideOutsideDialtone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($provideOutsideDialtone, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($provideOutsideDialtone) && !is_string($provideOutsideDialtone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($provideOutsideDialtone)), __LINE__);
        }
        $this->provideOutsideDialtone = $provideOutsideDialtone;
        return $this;
    }
    /**
     * Get callingPartyNumberingPlan value
     * @return string|null
     */
    public function getCallingPartyNumberingPlan()
    {
        return $this->callingPartyNumberingPlan;
    }
    /**
     * Set callingPartyNumberingPlan value
     * @uses XNumberingPlan::valueIsValid()
     * @uses XNumberingPlan::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callingPartyNumberingPlan
     * @return RTransPattern
     */
    public function setCallingPartyNumberingPlan($callingPartyNumberingPlan = null)
    {
        // validation for constraint: enumeration
        if (!XNumberingPlan::valueIsValid($callingPartyNumberingPlan)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $callingPartyNumberingPlan, implode(', ', XNumberingPlan::getValidValues())), __LINE__);
        }
        $this->callingPartyNumberingPlan = $callingPartyNumberingPlan;
        return $this;
    }
    /**
     * Get callingPartyNumberType value
     * @return string|null
     */
    public function getCallingPartyNumberType()
    {
        return $this->callingPartyNumberType;
    }
    /**
     * Set callingPartyNumberType value
     * @uses XPriOfNumber::valueIsValid()
     * @uses XPriOfNumber::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callingPartyNumberType
     * @return RTransPattern
     */
    public function setCallingPartyNumberType($callingPartyNumberType = null)
    {
        // validation for constraint: enumeration
        if (!XPriOfNumber::valueIsValid($callingPartyNumberType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $callingPartyNumberType, implode(', ', XPriOfNumber::getValidValues())), __LINE__);
        }
        $this->callingPartyNumberType = $callingPartyNumberType;
        return $this;
    }
    /**
     * Get calledPartyNumberingPlan value
     * @return string|null
     */
    public function getCalledPartyNumberingPlan()
    {
        return $this->calledPartyNumberingPlan;
    }
    /**
     * Set calledPartyNumberingPlan value
     * @uses XNumberingPlan::valueIsValid()
     * @uses XNumberingPlan::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $calledPartyNumberingPlan
     * @return RTransPattern
     */
    public function setCalledPartyNumberingPlan($calledPartyNumberingPlan = null)
    {
        // validation for constraint: enumeration
        if (!XNumberingPlan::valueIsValid($calledPartyNumberingPlan)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $calledPartyNumberingPlan, implode(', ', XNumberingPlan::getValidValues())), __LINE__);
        }
        $this->calledPartyNumberingPlan = $calledPartyNumberingPlan;
        return $this;
    }
    /**
     * Get calledPartyNumberType value
     * @return string|null
     */
    public function getCalledPartyNumberType()
    {
        return $this->calledPartyNumberType;
    }
    /**
     * Set calledPartyNumberType value
     * @uses XPriOfNumber::valueIsValid()
     * @uses XPriOfNumber::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $calledPartyNumberType
     * @return RTransPattern
     */
    public function setCalledPartyNumberType($calledPartyNumberType = null)
    {
        // validation for constraint: enumeration
        if (!XPriOfNumber::valueIsValid($calledPartyNumberType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $calledPartyNumberType, implode(', ', XPriOfNumber::getValidValues())), __LINE__);
        }
        $this->calledPartyNumberType = $calledPartyNumberType;
        return $this;
    }
    /**
     * Get callingSearchSpaceName value
     * @return XFkType|null
     */
    public function getCallingSearchSpaceName()
    {
        return $this->callingSearchSpaceName;
    }
    /**
     * Set callingSearchSpaceName value
     * @param XFkType $callingSearchSpaceName
     * @return RTransPattern
     */
    public function setCallingSearchSpaceName(XFkType $callingSearchSpaceName = null)
    {
        $this->callingSearchSpaceName = $callingSearchSpaceName;
        return $this;
    }
    /**
     * Get resourcePriorityNamespaceName value
     * @return XFkType|null
     */
    public function getResourcePriorityNamespaceName()
    {
        return $this->resourcePriorityNamespaceName;
    }
    /**
     * Set resourcePriorityNamespaceName value
     * @param XFkType $resourcePriorityNamespaceName
     * @return RTransPattern
     */
    public function setResourcePriorityNamespaceName(XFkType $resourcePriorityNamespaceName = null)
    {
        $this->resourcePriorityNamespaceName = $resourcePriorityNamespaceName;
        return $this;
    }
    /**
     * Get routeNextHopByCgpn value
     * @return string|null
     */
    public function getRouteNextHopByCgpn()
    {
        return $this->routeNextHopByCgpn;
    }
    /**
     * Set routeNextHopByCgpn value
     * @param string $routeNextHopByCgpn
     * @return RTransPattern
     */
    public function setRouteNextHopByCgpn($routeNextHopByCgpn = null)
    {
        // validation for constraint: pattern
        if (is_scalar($routeNextHopByCgpn) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $routeNextHopByCgpn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($routeNextHopByCgpn, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($routeNextHopByCgpn) && !is_string($routeNextHopByCgpn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($routeNextHopByCgpn)), __LINE__);
        }
        $this->routeNextHopByCgpn = $routeNextHopByCgpn;
        return $this;
    }
    /**
     * Get routeClass value
     * @return string|null
     */
    public function getRouteClass()
    {
        return $this->routeClass;
    }
    /**
     * Set routeClass value
     * @uses XPatternRouteClass::valueIsValid()
     * @uses XPatternRouteClass::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $routeClass
     * @return RTransPattern
     */
    public function setRouteClass($routeClass = null)
    {
        // validation for constraint: enumeration
        if (!XPatternRouteClass::valueIsValid($routeClass)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $routeClass, implode(', ', XPatternRouteClass::getValidValues())), __LINE__);
        }
        $this->routeClass = $routeClass;
        return $this;
    }
    /**
     * Get callInterceptProfileName value
     * @return XFkType|null
     */
    public function getCallInterceptProfileName()
    {
        return $this->callInterceptProfileName;
    }
    /**
     * Set callInterceptProfileName value
     * @param XFkType $callInterceptProfileName
     * @return RTransPattern
     */
    public function setCallInterceptProfileName(XFkType $callInterceptProfileName = null)
    {
        $this->callInterceptProfileName = $callInterceptProfileName;
        return $this;
    }
    /**
     * Get releaseClause value
     * @return string|null
     */
    public function getReleaseClause()
    {
        return $this->releaseClause;
    }
    /**
     * Set releaseClause value
     * @uses XReleaseCauseValue::valueIsValid()
     * @uses XReleaseCauseValue::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $releaseClause
     * @return RTransPattern
     */
    public function setReleaseClause($releaseClause = null)
    {
        // validation for constraint: enumeration
        if (!XReleaseCauseValue::valueIsValid($releaseClause)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $releaseClause, implode(', ', XReleaseCauseValue::getValidValues())), __LINE__);
        }
        $this->releaseClause = $releaseClause;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return RTransPattern
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\{........-....-....-....-............\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return RTransPattern
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
