<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RSipTrunk StructType
 * @subpackage Structs
 */
class RSipTrunk extends AbstractStructBase
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 128
     * @var string
     */
    public $name;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 128
     * @var string
     */
    public $description;
    /**
     * The product
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $product;
    /**
     * The model
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $model;
    /**
     * The class
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $class;
    /**
     * The protocol
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $protocol;
    /**
     * The protocolSide
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $protocolSide;
    /**
     * The callingSearchSpaceName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $callingSearchSpaceName;
    /**
     * The devicePoolName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $devicePoolName;
    /**
     * The commonDeviceConfigName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $commonDeviceConfigName;
    /**
     * The networkLocation
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $networkLocation;
    /**
     * The locationName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $locationName;
    /**
     * The mediaResourceListName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $mediaResourceListName;
    /**
     * The networkHoldMohAudioSourceId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $networkHoldMohAudioSourceId;
    /**
     * The userHoldMohAudioSourceId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $userHoldMohAudioSourceId;
    /**
     * The automatedAlternateRoutingCssName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $automatedAlternateRoutingCssName;
    /**
     * The aarNeighborhoodName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $aarNeighborhoodName;
    /**
     * The packetCaptureMode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $packetCaptureMode;
    /**
     * The packetCaptureDuration
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $packetCaptureDuration;
    /**
     * The loadInformation
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XLoadInformation
     */
    public $loadInformation;
    /**
     * The versionStamp
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 128
     * @var string
     */
    public $versionStamp;
    /**
     * The traceFlag
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $traceFlag;
    /**
     * The mlppDomainId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 128
     * @var string
     */
    public $mlppDomainId;
    /**
     * The mlppIndicationStatus
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $mlppIndicationStatus;
    /**
     * The preemption
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $preemption;
    /**
     * The useTrustedRelayPoint
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $useTrustedRelayPoint;
    /**
     * The retryVideoCallAsAudio
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $retryVideoCallAsAudio;
    /**
     * The securityProfileName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $securityProfileName;
    /**
     * The sipProfileName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $sipProfileName;
    /**
     * The cgpnTransformationCssName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $cgpnTransformationCssName;
    /**
     * The useDevicePoolCgpnTransformCss
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useDevicePoolCgpnTransformCss;
    /**
     * The geoLocationName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $geoLocationName;
    /**
     * The geoLocationFilterName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $geoLocationFilterName;
    /**
     * The sendGeoLocation
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $sendGeoLocation;
    /**
     * The cdpnTransformationCssName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $cdpnTransformationCssName;
    /**
     * The useDevicePoolCdpnTransformCss
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useDevicePoolCdpnTransformCss;
    /**
     * The unattendedPort
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $unattendedPort;
    /**
     * The transmitUtf8
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $transmitUtf8;
    /**
     * The subscribeCallingSearchSpaceName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $subscribeCallingSearchSpaceName;
    /**
     * The rerouteCallingSearchSpaceName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $rerouteCallingSearchSpaceName;
    /**
     * The referCallingSearchSpaceName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $referCallingSearchSpaceName;
    /**
     * The mtpRequired
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $mtpRequired;
    /**
     * The presenceGroupName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $presenceGroupName;
    /**
     * The unknownPrefix
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 16
     * @var string
     */
    public $unknownPrefix;
    /**
     * The destinationAddress
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 50
     * @var string
     */
    public $destinationAddress;
    /**
     * The destAddrIsSrv
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $destAddrIsSrv;
    /**
     * The destinationport
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $destinationport;
    /**
     * The tkSipCodec
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $tkSipCodec;
    /**
     * The sigDigits
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var SigDigits
     */
    public $sigDigits;
    /**
     * The connectedNamePresentation
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $connectedNamePresentation;
    /**
     * The connectedPartyIdPresentation
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $connectedPartyIdPresentation;
    /**
     * The callingPartySelection
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callingPartySelection;
    /**
     * The callingname
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callingname;
    /**
     * The callingLineIdPresentation
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callingLineIdPresentation;
    /**
     * The prefixDn
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 50
     * @var string
     */
    public $prefixDn;
    /**
     * The callerName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 50
     * @var string
     */
    public $callerName;
    /**
     * The callerIdDn
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 50
     * @var string
     */
    public $callerIdDn;
    /**
     * The acceptInboundRdnis
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $acceptInboundRdnis;
    /**
     * The acceptOutboundRdnis
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $acceptOutboundRdnis;
    /**
     * The srtpAllowed
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $srtpAllowed;
    /**
     * The srtpFallbackAllowed
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $srtpFallbackAllowed;
    /**
     * The isPaiEnabled
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $isPaiEnabled;
    /**
     * The sipPrivacy
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sipPrivacy;
    /**
     * The isRpidEnabled
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $isRpidEnabled;
    /**
     * The sipAssertedType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sipAssertedType;
    /**
     * The destinationAddressIpv6
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $destinationAddressIpv6;
    /**
     * The dtmfSignalingMethod
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $dtmfSignalingMethod;
    /**
     * The routeClassSignalling
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $routeClassSignalling;
    /**
     * The sipTrunkType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sipTrunkType;
    /**
     * The pstnAccess
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $pstnAccess;
    /**
     * The imeE164TransformationName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $imeE164TransformationName;
    /**
     * The useImePublicIpPort
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useImePublicIpPort;
    /**
     * The useDevicePoolCntdPnTransformationCss
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useDevicePoolCntdPnTransformationCss;
    /**
     * The cntdPnTransformationCssName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $cntdPnTransformationCssName;
    /**
     * The useDevicePoolCgpnTransformCssUnkn
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useDevicePoolCgpnTransformCssUnkn;
    /**
     * The sipNormalizationScriptName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $sipNormalizationScriptName;
    /**
     * The runOnEveryNode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $runOnEveryNode;
    /**
     * The destinations
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var Destinations
     */
    public $destinations;
    /**
     * The unknownStripDigits
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $unknownStripDigits;
    /**
     * The cgpnTransformationUnknownCssName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $cgpnTransformationUnknownCssName;
    /**
     * The tunneledProtocol
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $tunneledProtocol;
    /**
     * The asn1RoseOidEncoding
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $asn1RoseOidEncoding;
    /**
     * The qsigVariant
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $qsigVariant;
    /**
     * The pathReplacementSupport
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $pathReplacementSupport;
    /**
     * The enableQsigUtf8
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enableQsigUtf8;
    /**
     * The scriptParameters
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $scriptParameters;
    /**
     * The scriptTraceEnabled
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $scriptTraceEnabled;
    /**
     * The trunkTrafficSecure
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $trunkTrafficSecure;
    /**
     * The callingAndCalledPartyInfoFormat
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callingAndCalledPartyInfoFormat;
    /**
     * The useCallerIdCallerNameinUriOutgoingRequest
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useCallerIdCallerNameinUriOutgoingRequest;
    /**
     * The requestUriDomainName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $requestUriDomainName;
    /**
     * The ctiid
     * @var int
     */
    public $ctiid;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - use: optional
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RSipTrunk
     * @uses RSipTrunk::setName()
     * @uses RSipTrunk::setDescription()
     * @uses RSipTrunk::setProduct()
     * @uses RSipTrunk::setModel()
     * @uses RSipTrunk::setClass()
     * @uses RSipTrunk::setProtocol()
     * @uses RSipTrunk::setProtocolSide()
     * @uses RSipTrunk::setCallingSearchSpaceName()
     * @uses RSipTrunk::setDevicePoolName()
     * @uses RSipTrunk::setCommonDeviceConfigName()
     * @uses RSipTrunk::setNetworkLocation()
     * @uses RSipTrunk::setLocationName()
     * @uses RSipTrunk::setMediaResourceListName()
     * @uses RSipTrunk::setNetworkHoldMohAudioSourceId()
     * @uses RSipTrunk::setUserHoldMohAudioSourceId()
     * @uses RSipTrunk::setAutomatedAlternateRoutingCssName()
     * @uses RSipTrunk::setAarNeighborhoodName()
     * @uses RSipTrunk::setPacketCaptureMode()
     * @uses RSipTrunk::setPacketCaptureDuration()
     * @uses RSipTrunk::setLoadInformation()
     * @uses RSipTrunk::setVersionStamp()
     * @uses RSipTrunk::setTraceFlag()
     * @uses RSipTrunk::setMlppDomainId()
     * @uses RSipTrunk::setMlppIndicationStatus()
     * @uses RSipTrunk::setPreemption()
     * @uses RSipTrunk::setUseTrustedRelayPoint()
     * @uses RSipTrunk::setRetryVideoCallAsAudio()
     * @uses RSipTrunk::setSecurityProfileName()
     * @uses RSipTrunk::setSipProfileName()
     * @uses RSipTrunk::setCgpnTransformationCssName()
     * @uses RSipTrunk::setUseDevicePoolCgpnTransformCss()
     * @uses RSipTrunk::setGeoLocationName()
     * @uses RSipTrunk::setGeoLocationFilterName()
     * @uses RSipTrunk::setSendGeoLocation()
     * @uses RSipTrunk::setCdpnTransformationCssName()
     * @uses RSipTrunk::setUseDevicePoolCdpnTransformCss()
     * @uses RSipTrunk::setUnattendedPort()
     * @uses RSipTrunk::setTransmitUtf8()
     * @uses RSipTrunk::setSubscribeCallingSearchSpaceName()
     * @uses RSipTrunk::setRerouteCallingSearchSpaceName()
     * @uses RSipTrunk::setReferCallingSearchSpaceName()
     * @uses RSipTrunk::setMtpRequired()
     * @uses RSipTrunk::setPresenceGroupName()
     * @uses RSipTrunk::setUnknownPrefix()
     * @uses RSipTrunk::setDestinationAddress()
     * @uses RSipTrunk::setDestAddrIsSrv()
     * @uses RSipTrunk::setDestinationport()
     * @uses RSipTrunk::setTkSipCodec()
     * @uses RSipTrunk::setSigDigits()
     * @uses RSipTrunk::setConnectedNamePresentation()
     * @uses RSipTrunk::setConnectedPartyIdPresentation()
     * @uses RSipTrunk::setCallingPartySelection()
     * @uses RSipTrunk::setCallingname()
     * @uses RSipTrunk::setCallingLineIdPresentation()
     * @uses RSipTrunk::setPrefixDn()
     * @uses RSipTrunk::setCallerName()
     * @uses RSipTrunk::setCallerIdDn()
     * @uses RSipTrunk::setAcceptInboundRdnis()
     * @uses RSipTrunk::setAcceptOutboundRdnis()
     * @uses RSipTrunk::setSrtpAllowed()
     * @uses RSipTrunk::setSrtpFallbackAllowed()
     * @uses RSipTrunk::setIsPaiEnabled()
     * @uses RSipTrunk::setSipPrivacy()
     * @uses RSipTrunk::setIsRpidEnabled()
     * @uses RSipTrunk::setSipAssertedType()
     * @uses RSipTrunk::setDestinationAddressIpv6()
     * @uses RSipTrunk::setDtmfSignalingMethod()
     * @uses RSipTrunk::setRouteClassSignalling()
     * @uses RSipTrunk::setSipTrunkType()
     * @uses RSipTrunk::setPstnAccess()
     * @uses RSipTrunk::setImeE164TransformationName()
     * @uses RSipTrunk::setUseImePublicIpPort()
     * @uses RSipTrunk::setUseDevicePoolCntdPnTransformationCss()
     * @uses RSipTrunk::setCntdPnTransformationCssName()
     * @uses RSipTrunk::setUseDevicePoolCgpnTransformCssUnkn()
     * @uses RSipTrunk::setSipNormalizationScriptName()
     * @uses RSipTrunk::setRunOnEveryNode()
     * @uses RSipTrunk::setDestinations()
     * @uses RSipTrunk::setUnknownStripDigits()
     * @uses RSipTrunk::setCgpnTransformationUnknownCssName()
     * @uses RSipTrunk::setTunneledProtocol()
     * @uses RSipTrunk::setAsn1RoseOidEncoding()
     * @uses RSipTrunk::setQsigVariant()
     * @uses RSipTrunk::setPathReplacementSupport()
     * @uses RSipTrunk::setEnableQsigUtf8()
     * @uses RSipTrunk::setScriptParameters()
     * @uses RSipTrunk::setScriptTraceEnabled()
     * @uses RSipTrunk::setTrunkTrafficSecure()
     * @uses RSipTrunk::setCallingAndCalledPartyInfoFormat()
     * @uses RSipTrunk::setUseCallerIdCallerNameinUriOutgoingRequest()
     * @uses RSipTrunk::setRequestUriDomainName()
     * @uses RSipTrunk::setCtiid()
     * @uses RSipTrunk::setUuid()
     * @param string $name
     * @param string $description
     * @param string $product
     * @param string $model
     * @param string $class
     * @param string $protocol
     * @param string $protocolSide
     * @param XFkType $callingSearchSpaceName
     * @param XFkType $devicePoolName
     * @param XFkType $commonDeviceConfigName
     * @param string $networkLocation
     * @param XFkType $locationName
     * @param XFkType $mediaResourceListName
     * @param string $networkHoldMohAudioSourceId
     * @param string $userHoldMohAudioSourceId
     * @param XFkType $automatedAlternateRoutingCssName
     * @param XFkType $aarNeighborhoodName
     * @param string $packetCaptureMode
     * @param string $packetCaptureDuration
     * @param XLoadInformation $loadInformation
     * @param string $versionStamp
     * @param string $traceFlag
     * @param string $mlppDomainId
     * @param string $mlppIndicationStatus
     * @param string $preemption
     * @param string $useTrustedRelayPoint
     * @param string $retryVideoCallAsAudio
     * @param XFkType $securityProfileName
     * @param XFkType $sipProfileName
     * @param XFkType $cgpnTransformationCssName
     * @param string $useDevicePoolCgpnTransformCss
     * @param XFkType $geoLocationName
     * @param XFkType $geoLocationFilterName
     * @param string $sendGeoLocation
     * @param XFkType $cdpnTransformationCssName
     * @param string $useDevicePoolCdpnTransformCss
     * @param string $unattendedPort
     * @param string $transmitUtf8
     * @param XFkType $subscribeCallingSearchSpaceName
     * @param XFkType $rerouteCallingSearchSpaceName
     * @param XFkType $referCallingSearchSpaceName
     * @param string $mtpRequired
     * @param XFkType $presenceGroupName
     * @param string $unknownPrefix
     * @param string $destinationAddress
     * @param string $destAddrIsSrv
     * @param string $destinationport
     * @param string $tkSipCodec
     * @param SigDigits $sigDigits
     * @param string $connectedNamePresentation
     * @param string $connectedPartyIdPresentation
     * @param string $callingPartySelection
     * @param string $callingname
     * @param string $callingLineIdPresentation
     * @param string $prefixDn
     * @param string $callerName
     * @param string $callerIdDn
     * @param string $acceptInboundRdnis
     * @param string $acceptOutboundRdnis
     * @param string $srtpAllowed
     * @param string $srtpFallbackAllowed
     * @param string $isPaiEnabled
     * @param string $sipPrivacy
     * @param string $isRpidEnabled
     * @param string $sipAssertedType
     * @param string $destinationAddressIpv6
     * @param string $dtmfSignalingMethod
     * @param string $routeClassSignalling
     * @param string $sipTrunkType
     * @param string $pstnAccess
     * @param XFkType $imeE164TransformationName
     * @param string $useImePublicIpPort
     * @param string $useDevicePoolCntdPnTransformationCss
     * @param XFkType $cntdPnTransformationCssName
     * @param string $useDevicePoolCgpnTransformCssUnkn
     * @param XFkType $sipNormalizationScriptName
     * @param string $runOnEveryNode
     * @param Destinations $destinations
     * @param int $unknownStripDigits
     * @param XFkType $cgpnTransformationUnknownCssName
     * @param string $tunneledProtocol
     * @param string $asn1RoseOidEncoding
     * @param string $qsigVariant
     * @param string $pathReplacementSupport
     * @param string $enableQsigUtf8
     * @param string $scriptParameters
     * @param string $scriptTraceEnabled
     * @param string $trunkTrafficSecure
     * @param string $callingAndCalledPartyInfoFormat
     * @param string $useCallerIdCallerNameinUriOutgoingRequest
     * @param string $requestUriDomainName
     * @param int $ctiid
     * @param string $uuid
     */
    public function __construct($name = null, $description = null, $product = null, $model = null, $class = null, $protocol = null, $protocolSide = null, XFkType $callingSearchSpaceName = null, XFkType $devicePoolName = null, XFkType $commonDeviceConfigName = null, $networkLocation = null, XFkType $locationName = null, XFkType $mediaResourceListName = null, $networkHoldMohAudioSourceId = null, $userHoldMohAudioSourceId = null, XFkType $automatedAlternateRoutingCssName = null, XFkType $aarNeighborhoodName = null, $packetCaptureMode = null, $packetCaptureDuration = null, XLoadInformation $loadInformation = null, $versionStamp = null, $traceFlag = null, $mlppDomainId = null, $mlppIndicationStatus = null, $preemption = null, $useTrustedRelayPoint = null, $retryVideoCallAsAudio = null, XFkType $securityProfileName = null, XFkType $sipProfileName = null, XFkType $cgpnTransformationCssName = null, $useDevicePoolCgpnTransformCss = null, XFkType $geoLocationName = null, XFkType $geoLocationFilterName = null, $sendGeoLocation = null, XFkType $cdpnTransformationCssName = null, $useDevicePoolCdpnTransformCss = null, $unattendedPort = null, $transmitUtf8 = null, XFkType $subscribeCallingSearchSpaceName = null, XFkType $rerouteCallingSearchSpaceName = null, XFkType $referCallingSearchSpaceName = null, $mtpRequired = null, XFkType $presenceGroupName = null, $unknownPrefix = null, $destinationAddress = null, $destAddrIsSrv = null, $destinationport = null, $tkSipCodec = null, SigDigits $sigDigits = null, $connectedNamePresentation = null, $connectedPartyIdPresentation = null, $callingPartySelection = null, $callingname = null, $callingLineIdPresentation = null, $prefixDn = null, $callerName = null, $callerIdDn = null, $acceptInboundRdnis = null, $acceptOutboundRdnis = null, $srtpAllowed = null, $srtpFallbackAllowed = null, $isPaiEnabled = null, $sipPrivacy = null, $isRpidEnabled = null, $sipAssertedType = null, $destinationAddressIpv6 = null, $dtmfSignalingMethod = null, $routeClassSignalling = null, $sipTrunkType = null, $pstnAccess = null, XFkType $imeE164TransformationName = null, $useImePublicIpPort = null, $useDevicePoolCntdPnTransformationCss = null, XFkType $cntdPnTransformationCssName = null, $useDevicePoolCgpnTransformCssUnkn = null, XFkType $sipNormalizationScriptName = null, $runOnEveryNode = null, Destinations $destinations = null, $unknownStripDigits = null, XFkType $cgpnTransformationUnknownCssName = null, $tunneledProtocol = null, $asn1RoseOidEncoding = null, $qsigVariant = null, $pathReplacementSupport = null, $enableQsigUtf8 = null, $scriptParameters = null, $scriptTraceEnabled = null, $trunkTrafficSecure = null, $callingAndCalledPartyInfoFormat = null, $useCallerIdCallerNameinUriOutgoingRequest = null, $requestUriDomainName = null, $ctiid = null, $uuid = null)
    {
        $this
            ->setName($name)
            ->setDescription($description)
            ->setProduct($product)
            ->setModel($model)
            ->setClass($class)
            ->setProtocol($protocol)
            ->setProtocolSide($protocolSide)
            ->setCallingSearchSpaceName($callingSearchSpaceName)
            ->setDevicePoolName($devicePoolName)
            ->setCommonDeviceConfigName($commonDeviceConfigName)
            ->setNetworkLocation($networkLocation)
            ->setLocationName($locationName)
            ->setMediaResourceListName($mediaResourceListName)
            ->setNetworkHoldMohAudioSourceId($networkHoldMohAudioSourceId)
            ->setUserHoldMohAudioSourceId($userHoldMohAudioSourceId)
            ->setAutomatedAlternateRoutingCssName($automatedAlternateRoutingCssName)
            ->setAarNeighborhoodName($aarNeighborhoodName)
            ->setPacketCaptureMode($packetCaptureMode)
            ->setPacketCaptureDuration($packetCaptureDuration)
            ->setLoadInformation($loadInformation)
            ->setVersionStamp($versionStamp)
            ->setTraceFlag($traceFlag)
            ->setMlppDomainId($mlppDomainId)
            ->setMlppIndicationStatus($mlppIndicationStatus)
            ->setPreemption($preemption)
            ->setUseTrustedRelayPoint($useTrustedRelayPoint)
            ->setRetryVideoCallAsAudio($retryVideoCallAsAudio)
            ->setSecurityProfileName($securityProfileName)
            ->setSipProfileName($sipProfileName)
            ->setCgpnTransformationCssName($cgpnTransformationCssName)
            ->setUseDevicePoolCgpnTransformCss($useDevicePoolCgpnTransformCss)
            ->setGeoLocationName($geoLocationName)
            ->setGeoLocationFilterName($geoLocationFilterName)
            ->setSendGeoLocation($sendGeoLocation)
            ->setCdpnTransformationCssName($cdpnTransformationCssName)
            ->setUseDevicePoolCdpnTransformCss($useDevicePoolCdpnTransformCss)
            ->setUnattendedPort($unattendedPort)
            ->setTransmitUtf8($transmitUtf8)
            ->setSubscribeCallingSearchSpaceName($subscribeCallingSearchSpaceName)
            ->setRerouteCallingSearchSpaceName($rerouteCallingSearchSpaceName)
            ->setReferCallingSearchSpaceName($referCallingSearchSpaceName)
            ->setMtpRequired($mtpRequired)
            ->setPresenceGroupName($presenceGroupName)
            ->setUnknownPrefix($unknownPrefix)
            ->setDestinationAddress($destinationAddress)
            ->setDestAddrIsSrv($destAddrIsSrv)
            ->setDestinationport($destinationport)
            ->setTkSipCodec($tkSipCodec)
            ->setSigDigits($sigDigits)
            ->setConnectedNamePresentation($connectedNamePresentation)
            ->setConnectedPartyIdPresentation($connectedPartyIdPresentation)
            ->setCallingPartySelection($callingPartySelection)
            ->setCallingname($callingname)
            ->setCallingLineIdPresentation($callingLineIdPresentation)
            ->setPrefixDn($prefixDn)
            ->setCallerName($callerName)
            ->setCallerIdDn($callerIdDn)
            ->setAcceptInboundRdnis($acceptInboundRdnis)
            ->setAcceptOutboundRdnis($acceptOutboundRdnis)
            ->setSrtpAllowed($srtpAllowed)
            ->setSrtpFallbackAllowed($srtpFallbackAllowed)
            ->setIsPaiEnabled($isPaiEnabled)
            ->setSipPrivacy($sipPrivacy)
            ->setIsRpidEnabled($isRpidEnabled)
            ->setSipAssertedType($sipAssertedType)
            ->setDestinationAddressIpv6($destinationAddressIpv6)
            ->setDtmfSignalingMethod($dtmfSignalingMethod)
            ->setRouteClassSignalling($routeClassSignalling)
            ->setSipTrunkType($sipTrunkType)
            ->setPstnAccess($pstnAccess)
            ->setImeE164TransformationName($imeE164TransformationName)
            ->setUseImePublicIpPort($useImePublicIpPort)
            ->setUseDevicePoolCntdPnTransformationCss($useDevicePoolCntdPnTransformationCss)
            ->setCntdPnTransformationCssName($cntdPnTransformationCssName)
            ->setUseDevicePoolCgpnTransformCssUnkn($useDevicePoolCgpnTransformCssUnkn)
            ->setSipNormalizationScriptName($sipNormalizationScriptName)
            ->setRunOnEveryNode($runOnEveryNode)
            ->setDestinations($destinations)
            ->setUnknownStripDigits($unknownStripDigits)
            ->setCgpnTransformationUnknownCssName($cgpnTransformationUnknownCssName)
            ->setTunneledProtocol($tunneledProtocol)
            ->setAsn1RoseOidEncoding($asn1RoseOidEncoding)
            ->setQsigVariant($qsigVariant)
            ->setPathReplacementSupport($pathReplacementSupport)
            ->setEnableQsigUtf8($enableQsigUtf8)
            ->setScriptParameters($scriptParameters)
            ->setScriptTraceEnabled($scriptTraceEnabled)
            ->setTrunkTrafficSecure($trunkTrafficSecure)
            ->setCallingAndCalledPartyInfoFormat($callingAndCalledPartyInfoFormat)
            ->setUseCallerIdCallerNameinUriOutgoingRequest($useCallerIdCallerNameinUriOutgoingRequest)
            ->setRequestUriDomainName($requestUriDomainName)
            ->setCtiid($ctiid)
            ->setUuid($uuid);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return RSipTrunk
     */
    public function setName($name = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($name) && strlen($name) > 128) || (is_array($name) && count($name) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($name) ? strlen($name) : count($name)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return RSipTrunk
     */
    public function setDescription($description = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($description) && strlen($description) > 128) || (is_array($description) && count($description) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($description) ? strlen($description) : count($description)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get product value
     * @return string|null
     */
    public function getProduct()
    {
        return $this->product;
    }
    /**
     * Set product value
     * @uses XProduct::valueIsValid()
     * @uses XProduct::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $product
     * @return RSipTrunk
     */
    public function setProduct($product = null)
    {
        // validation for constraint: enumeration
        if (!XProduct::valueIsValid($product)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $product, implode(', ', XProduct::getValidValues())), __LINE__);
        }
        $this->product = $product;
        return $this;
    }
    /**
     * Get model value
     * @return string|null
     */
    public function getModel()
    {
        return $this->model;
    }
    /**
     * Set model value
     * @uses XModel::valueIsValid()
     * @uses XModel::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $model
     * @return RSipTrunk
     */
    public function setModel($model = null)
    {
        // validation for constraint: enumeration
        if (!XModel::valueIsValid($model)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $model, implode(', ', XModel::getValidValues())), __LINE__);
        }
        $this->model = $model;
        return $this;
    }
    /**
     * Get class value
     * @return string|null
     */
    public function getClass()
    {
        return $this->class;
    }
    /**
     * Set class value
     * @uses XClass::valueIsValid()
     * @uses XClass::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $class
     * @return RSipTrunk
     */
    public function setClass($class = null)
    {
        // validation for constraint: enumeration
        if (!XClass::valueIsValid($class)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $class, implode(', ', XClass::getValidValues())), __LINE__);
        }
        $this->class = $class;
        return $this;
    }
    /**
     * Get protocol value
     * @return string|null
     */
    public function getProtocol()
    {
        return $this->protocol;
    }
    /**
     * Set protocol value
     * @uses XDeviceProtocol::valueIsValid()
     * @uses XDeviceProtocol::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $protocol
     * @return RSipTrunk
     */
    public function setProtocol($protocol = null)
    {
        // validation for constraint: enumeration
        if (!XDeviceProtocol::valueIsValid($protocol)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $protocol, implode(', ', XDeviceProtocol::getValidValues())), __LINE__);
        }
        $this->protocol = $protocol;
        return $this;
    }
    /**
     * Get protocolSide value
     * @return string|null
     */
    public function getProtocolSide()
    {
        return $this->protocolSide;
    }
    /**
     * Set protocolSide value
     * @uses XProtocolSide::valueIsValid()
     * @uses XProtocolSide::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $protocolSide
     * @return RSipTrunk
     */
    public function setProtocolSide($protocolSide = null)
    {
        // validation for constraint: enumeration
        if (!XProtocolSide::valueIsValid($protocolSide)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $protocolSide, implode(', ', XProtocolSide::getValidValues())), __LINE__);
        }
        $this->protocolSide = $protocolSide;
        return $this;
    }
    /**
     * Get callingSearchSpaceName value
     * @return XFkType|null
     */
    public function getCallingSearchSpaceName()
    {
        return $this->callingSearchSpaceName;
    }
    /**
     * Set callingSearchSpaceName value
     * @param XFkType $callingSearchSpaceName
     * @return RSipTrunk
     */
    public function setCallingSearchSpaceName(XFkType $callingSearchSpaceName = null)
    {
        $this->callingSearchSpaceName = $callingSearchSpaceName;
        return $this;
    }
    /**
     * Get devicePoolName value
     * @return XFkType|null
     */
    public function getDevicePoolName()
    {
        return $this->devicePoolName;
    }
    /**
     * Set devicePoolName value
     * @param XFkType $devicePoolName
     * @return RSipTrunk
     */
    public function setDevicePoolName(XFkType $devicePoolName = null)
    {
        $this->devicePoolName = $devicePoolName;
        return $this;
    }
    /**
     * Get commonDeviceConfigName value
     * @return XFkType|null
     */
    public function getCommonDeviceConfigName()
    {
        return $this->commonDeviceConfigName;
    }
    /**
     * Set commonDeviceConfigName value
     * @param XFkType $commonDeviceConfigName
     * @return RSipTrunk
     */
    public function setCommonDeviceConfigName(XFkType $commonDeviceConfigName = null)
    {
        $this->commonDeviceConfigName = $commonDeviceConfigName;
        return $this;
    }
    /**
     * Get networkLocation value
     * @return string|null
     */
    public function getNetworkLocation()
    {
        return $this->networkLocation;
    }
    /**
     * Set networkLocation value
     * @uses XNetworkLocation::valueIsValid()
     * @uses XNetworkLocation::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $networkLocation
     * @return RSipTrunk
     */
    public function setNetworkLocation($networkLocation = null)
    {
        // validation for constraint: enumeration
        if (!XNetworkLocation::valueIsValid($networkLocation)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $networkLocation, implode(', ', XNetworkLocation::getValidValues())), __LINE__);
        }
        $this->networkLocation = $networkLocation;
        return $this;
    }
    /**
     * Get locationName value
     * @return XFkType|null
     */
    public function getLocationName()
    {
        return $this->locationName;
    }
    /**
     * Set locationName value
     * @param XFkType $locationName
     * @return RSipTrunk
     */
    public function setLocationName(XFkType $locationName = null)
    {
        $this->locationName = $locationName;
        return $this;
    }
    /**
     * Get mediaResourceListName value
     * @return XFkType|null
     */
    public function getMediaResourceListName()
    {
        return $this->mediaResourceListName;
    }
    /**
     * Set mediaResourceListName value
     * @param XFkType $mediaResourceListName
     * @return RSipTrunk
     */
    public function setMediaResourceListName(XFkType $mediaResourceListName = null)
    {
        $this->mediaResourceListName = $mediaResourceListName;
        return $this;
    }
    /**
     * Get networkHoldMohAudioSourceId value
     * @return string|null
     */
    public function getNetworkHoldMohAudioSourceId()
    {
        return $this->networkHoldMohAudioSourceId;
    }
    /**
     * Set networkHoldMohAudioSourceId value
     * @uses XMOHAudioSourceId::valueIsValid()
     * @uses XMOHAudioSourceId::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $networkHoldMohAudioSourceId
     * @return RSipTrunk
     */
    public function setNetworkHoldMohAudioSourceId($networkHoldMohAudioSourceId = null)
    {
        // validation for constraint: enumeration
        if (!XMOHAudioSourceId::valueIsValid($networkHoldMohAudioSourceId)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $networkHoldMohAudioSourceId, implode(', ', XMOHAudioSourceId::getValidValues())), __LINE__);
        }
        $this->networkHoldMohAudioSourceId = $networkHoldMohAudioSourceId;
        return $this;
    }
    /**
     * Get userHoldMohAudioSourceId value
     * @return string|null
     */
    public function getUserHoldMohAudioSourceId()
    {
        return $this->userHoldMohAudioSourceId;
    }
    /**
     * Set userHoldMohAudioSourceId value
     * @uses XMOHAudioSourceId::valueIsValid()
     * @uses XMOHAudioSourceId::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $userHoldMohAudioSourceId
     * @return RSipTrunk
     */
    public function setUserHoldMohAudioSourceId($userHoldMohAudioSourceId = null)
    {
        // validation for constraint: enumeration
        if (!XMOHAudioSourceId::valueIsValid($userHoldMohAudioSourceId)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $userHoldMohAudioSourceId, implode(', ', XMOHAudioSourceId::getValidValues())), __LINE__);
        }
        $this->userHoldMohAudioSourceId = $userHoldMohAudioSourceId;
        return $this;
    }
    /**
     * Get automatedAlternateRoutingCssName value
     * @return XFkType|null
     */
    public function getAutomatedAlternateRoutingCssName()
    {
        return $this->automatedAlternateRoutingCssName;
    }
    /**
     * Set automatedAlternateRoutingCssName value
     * @param XFkType $automatedAlternateRoutingCssName
     * @return RSipTrunk
     */
    public function setAutomatedAlternateRoutingCssName(XFkType $automatedAlternateRoutingCssName = null)
    {
        $this->automatedAlternateRoutingCssName = $automatedAlternateRoutingCssName;
        return $this;
    }
    /**
     * Get aarNeighborhoodName value
     * @return XFkType|null
     */
    public function getAarNeighborhoodName()
    {
        return $this->aarNeighborhoodName;
    }
    /**
     * Set aarNeighborhoodName value
     * @param XFkType $aarNeighborhoodName
     * @return RSipTrunk
     */
    public function setAarNeighborhoodName(XFkType $aarNeighborhoodName = null)
    {
        $this->aarNeighborhoodName = $aarNeighborhoodName;
        return $this;
    }
    /**
     * Get packetCaptureMode value
     * @return string|null
     */
    public function getPacketCaptureMode()
    {
        return $this->packetCaptureMode;
    }
    /**
     * Set packetCaptureMode value
     * @uses XPacketCaptureMode::valueIsValid()
     * @uses XPacketCaptureMode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $packetCaptureMode
     * @return RSipTrunk
     */
    public function setPacketCaptureMode($packetCaptureMode = null)
    {
        // validation for constraint: enumeration
        if (!XPacketCaptureMode::valueIsValid($packetCaptureMode)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $packetCaptureMode, implode(', ', XPacketCaptureMode::getValidValues())), __LINE__);
        }
        $this->packetCaptureMode = $packetCaptureMode;
        return $this;
    }
    /**
     * Get packetCaptureDuration value
     * @return string|null
     */
    public function getPacketCaptureDuration()
    {
        return $this->packetCaptureDuration;
    }
    /**
     * Set packetCaptureDuration value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $packetCaptureDuration
     * @return RSipTrunk
     */
    public function setPacketCaptureDuration($packetCaptureDuration = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($packetCaptureDuration)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $packetCaptureDuration, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->packetCaptureDuration = $packetCaptureDuration;
        return $this;
    }
    /**
     * Get loadInformation value
     * @return XLoadInformation|null
     */
    public function getLoadInformation()
    {
        return $this->loadInformation;
    }
    /**
     * Set loadInformation value
     * @param XLoadInformation $loadInformation
     * @return RSipTrunk
     */
    public function setLoadInformation(XLoadInformation $loadInformation = null)
    {
        $this->loadInformation = $loadInformation;
        return $this;
    }
    /**
     * Get versionStamp value
     * @return string|null
     */
    public function getVersionStamp()
    {
        return $this->versionStamp;
    }
    /**
     * Set versionStamp value
     * @param string $versionStamp
     * @return RSipTrunk
     */
    public function setVersionStamp($versionStamp = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($versionStamp) && strlen($versionStamp) > 128) || (is_array($versionStamp) && count($versionStamp) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($versionStamp) ? strlen($versionStamp) : count($versionStamp)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($versionStamp) && !is_string($versionStamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($versionStamp)), __LINE__);
        }
        $this->versionStamp = $versionStamp;
        return $this;
    }
    /**
     * Get traceFlag value
     * @return string|null
     */
    public function getTraceFlag()
    {
        return $this->traceFlag;
    }
    /**
     * Set traceFlag value
     * @param string $traceFlag
     * @return RSipTrunk
     */
    public function setTraceFlag($traceFlag = null)
    {
        // validation for constraint: pattern
        if (is_scalar($traceFlag) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $traceFlag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($traceFlag, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($traceFlag) && !is_string($traceFlag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($traceFlag)), __LINE__);
        }
        $this->traceFlag = $traceFlag;
        return $this;
    }
    /**
     * Get mlppDomainId value
     * @return string|null
     */
    public function getMlppDomainId()
    {
        return $this->mlppDomainId;
    }
    /**
     * Set mlppDomainId value
     * @param string $mlppDomainId
     * @return RSipTrunk
     */
    public function setMlppDomainId($mlppDomainId = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($mlppDomainId) && strlen($mlppDomainId) > 128) || (is_array($mlppDomainId) && count($mlppDomainId) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($mlppDomainId) ? strlen($mlppDomainId) : count($mlppDomainId)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($mlppDomainId) && !is_string($mlppDomainId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mlppDomainId)), __LINE__);
        }
        $this->mlppDomainId = $mlppDomainId;
        return $this;
    }
    /**
     * Get mlppIndicationStatus value
     * @return string|null
     */
    public function getMlppIndicationStatus()
    {
        return $this->mlppIndicationStatus;
    }
    /**
     * Set mlppIndicationStatus value
     * @uses XStatus::valueIsValid()
     * @uses XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $mlppIndicationStatus
     * @return RSipTrunk
     */
    public function setMlppIndicationStatus($mlppIndicationStatus = null)
    {
        // validation for constraint: enumeration
        if (!XStatus::valueIsValid($mlppIndicationStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $mlppIndicationStatus, implode(', ', XStatus::getValidValues())), __LINE__);
        }
        $this->mlppIndicationStatus = $mlppIndicationStatus;
        return $this;
    }
    /**
     * Get preemption value
     * @return string|null
     */
    public function getPreemption()
    {
        return $this->preemption;
    }
    /**
     * Set preemption value
     * @uses XPreemption::valueIsValid()
     * @uses XPreemption::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $preemption
     * @return RSipTrunk
     */
    public function setPreemption($preemption = null)
    {
        // validation for constraint: enumeration
        if (!XPreemption::valueIsValid($preemption)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $preemption, implode(', ', XPreemption::getValidValues())), __LINE__);
        }
        $this->preemption = $preemption;
        return $this;
    }
    /**
     * Get useTrustedRelayPoint value
     * @return string|null
     */
    public function getUseTrustedRelayPoint()
    {
        return $this->useTrustedRelayPoint;
    }
    /**
     * Set useTrustedRelayPoint value
     * @uses XStatus::valueIsValid()
     * @uses XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $useTrustedRelayPoint
     * @return RSipTrunk
     */
    public function setUseTrustedRelayPoint($useTrustedRelayPoint = null)
    {
        // validation for constraint: enumeration
        if (!XStatus::valueIsValid($useTrustedRelayPoint)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $useTrustedRelayPoint, implode(', ', XStatus::getValidValues())), __LINE__);
        }
        $this->useTrustedRelayPoint = $useTrustedRelayPoint;
        return $this;
    }
    /**
     * Get retryVideoCallAsAudio value
     * @return string|null
     */
    public function getRetryVideoCallAsAudio()
    {
        return $this->retryVideoCallAsAudio;
    }
    /**
     * Set retryVideoCallAsAudio value
     * @param string $retryVideoCallAsAudio
     * @return RSipTrunk
     */
    public function setRetryVideoCallAsAudio($retryVideoCallAsAudio = null)
    {
        // validation for constraint: pattern
        if (is_scalar($retryVideoCallAsAudio) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $retryVideoCallAsAudio)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($retryVideoCallAsAudio, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($retryVideoCallAsAudio) && !is_string($retryVideoCallAsAudio)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($retryVideoCallAsAudio)), __LINE__);
        }
        $this->retryVideoCallAsAudio = $retryVideoCallAsAudio;
        return $this;
    }
    /**
     * Get securityProfileName value
     * @return XFkType|null
     */
    public function getSecurityProfileName()
    {
        return $this->securityProfileName;
    }
    /**
     * Set securityProfileName value
     * @param XFkType $securityProfileName
     * @return RSipTrunk
     */
    public function setSecurityProfileName(XFkType $securityProfileName = null)
    {
        $this->securityProfileName = $securityProfileName;
        return $this;
    }
    /**
     * Get sipProfileName value
     * @return XFkType|null
     */
    public function getSipProfileName()
    {
        return $this->sipProfileName;
    }
    /**
     * Set sipProfileName value
     * @param XFkType $sipProfileName
     * @return RSipTrunk
     */
    public function setSipProfileName(XFkType $sipProfileName = null)
    {
        $this->sipProfileName = $sipProfileName;
        return $this;
    }
    /**
     * Get cgpnTransformationCssName value
     * @return XFkType|null
     */
    public function getCgpnTransformationCssName()
    {
        return $this->cgpnTransformationCssName;
    }
    /**
     * Set cgpnTransformationCssName value
     * @param XFkType $cgpnTransformationCssName
     * @return RSipTrunk
     */
    public function setCgpnTransformationCssName(XFkType $cgpnTransformationCssName = null)
    {
        $this->cgpnTransformationCssName = $cgpnTransformationCssName;
        return $this;
    }
    /**
     * Get useDevicePoolCgpnTransformCss value
     * @return string|null
     */
    public function getUseDevicePoolCgpnTransformCss()
    {
        return $this->useDevicePoolCgpnTransformCss;
    }
    /**
     * Set useDevicePoolCgpnTransformCss value
     * @param string $useDevicePoolCgpnTransformCss
     * @return RSipTrunk
     */
    public function setUseDevicePoolCgpnTransformCss($useDevicePoolCgpnTransformCss = null)
    {
        // validation for constraint: pattern
        if (is_scalar($useDevicePoolCgpnTransformCss) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $useDevicePoolCgpnTransformCss)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($useDevicePoolCgpnTransformCss, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($useDevicePoolCgpnTransformCss) && !is_string($useDevicePoolCgpnTransformCss)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($useDevicePoolCgpnTransformCss)), __LINE__);
        }
        $this->useDevicePoolCgpnTransformCss = $useDevicePoolCgpnTransformCss;
        return $this;
    }
    /**
     * Get geoLocationName value
     * @return XFkType|null
     */
    public function getGeoLocationName()
    {
        return $this->geoLocationName;
    }
    /**
     * Set geoLocationName value
     * @param XFkType $geoLocationName
     * @return RSipTrunk
     */
    public function setGeoLocationName(XFkType $geoLocationName = null)
    {
        $this->geoLocationName = $geoLocationName;
        return $this;
    }
    /**
     * Get geoLocationFilterName value
     * @return XFkType|null
     */
    public function getGeoLocationFilterName()
    {
        return $this->geoLocationFilterName;
    }
    /**
     * Set geoLocationFilterName value
     * @param XFkType $geoLocationFilterName
     * @return RSipTrunk
     */
    public function setGeoLocationFilterName(XFkType $geoLocationFilterName = null)
    {
        $this->geoLocationFilterName = $geoLocationFilterName;
        return $this;
    }
    /**
     * Get sendGeoLocation value
     * @return string|null
     */
    public function getSendGeoLocation()
    {
        return $this->sendGeoLocation;
    }
    /**
     * Set sendGeoLocation value
     * @param string $sendGeoLocation
     * @return RSipTrunk
     */
    public function setSendGeoLocation($sendGeoLocation = null)
    {
        // validation for constraint: pattern
        if (is_scalar($sendGeoLocation) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $sendGeoLocation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($sendGeoLocation, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($sendGeoLocation) && !is_string($sendGeoLocation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sendGeoLocation)), __LINE__);
        }
        $this->sendGeoLocation = $sendGeoLocation;
        return $this;
    }
    /**
     * Get cdpnTransformationCssName value
     * @return XFkType|null
     */
    public function getCdpnTransformationCssName()
    {
        return $this->cdpnTransformationCssName;
    }
    /**
     * Set cdpnTransformationCssName value
     * @param XFkType $cdpnTransformationCssName
     * @return RSipTrunk
     */
    public function setCdpnTransformationCssName(XFkType $cdpnTransformationCssName = null)
    {
        $this->cdpnTransformationCssName = $cdpnTransformationCssName;
        return $this;
    }
    /**
     * Get useDevicePoolCdpnTransformCss value
     * @return string|null
     */
    public function getUseDevicePoolCdpnTransformCss()
    {
        return $this->useDevicePoolCdpnTransformCss;
    }
    /**
     * Set useDevicePoolCdpnTransformCss value
     * @param string $useDevicePoolCdpnTransformCss
     * @return RSipTrunk
     */
    public function setUseDevicePoolCdpnTransformCss($useDevicePoolCdpnTransformCss = null)
    {
        // validation for constraint: pattern
        if (is_scalar($useDevicePoolCdpnTransformCss) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $useDevicePoolCdpnTransformCss)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($useDevicePoolCdpnTransformCss, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($useDevicePoolCdpnTransformCss) && !is_string($useDevicePoolCdpnTransformCss)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($useDevicePoolCdpnTransformCss)), __LINE__);
        }
        $this->useDevicePoolCdpnTransformCss = $useDevicePoolCdpnTransformCss;
        return $this;
    }
    /**
     * Get unattendedPort value
     * @return string|null
     */
    public function getUnattendedPort()
    {
        return $this->unattendedPort;
    }
    /**
     * Set unattendedPort value
     * @param string $unattendedPort
     * @return RSipTrunk
     */
    public function setUnattendedPort($unattendedPort = null)
    {
        // validation for constraint: pattern
        if (is_scalar($unattendedPort) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $unattendedPort)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($unattendedPort, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($unattendedPort) && !is_string($unattendedPort)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($unattendedPort)), __LINE__);
        }
        $this->unattendedPort = $unattendedPort;
        return $this;
    }
    /**
     * Get transmitUtf8 value
     * @return string|null
     */
    public function getTransmitUtf8()
    {
        return $this->transmitUtf8;
    }
    /**
     * Set transmitUtf8 value
     * @param string $transmitUtf8
     * @return RSipTrunk
     */
    public function setTransmitUtf8($transmitUtf8 = null)
    {
        // validation for constraint: pattern
        if (is_scalar($transmitUtf8) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $transmitUtf8)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($transmitUtf8, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($transmitUtf8) && !is_string($transmitUtf8)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($transmitUtf8)), __LINE__);
        }
        $this->transmitUtf8 = $transmitUtf8;
        return $this;
    }
    /**
     * Get subscribeCallingSearchSpaceName value
     * @return XFkType|null
     */
    public function getSubscribeCallingSearchSpaceName()
    {
        return $this->subscribeCallingSearchSpaceName;
    }
    /**
     * Set subscribeCallingSearchSpaceName value
     * @param XFkType $subscribeCallingSearchSpaceName
     * @return RSipTrunk
     */
    public function setSubscribeCallingSearchSpaceName(XFkType $subscribeCallingSearchSpaceName = null)
    {
        $this->subscribeCallingSearchSpaceName = $subscribeCallingSearchSpaceName;
        return $this;
    }
    /**
     * Get rerouteCallingSearchSpaceName value
     * @return XFkType|null
     */
    public function getRerouteCallingSearchSpaceName()
    {
        return $this->rerouteCallingSearchSpaceName;
    }
    /**
     * Set rerouteCallingSearchSpaceName value
     * @param XFkType $rerouteCallingSearchSpaceName
     * @return RSipTrunk
     */
    public function setRerouteCallingSearchSpaceName(XFkType $rerouteCallingSearchSpaceName = null)
    {
        $this->rerouteCallingSearchSpaceName = $rerouteCallingSearchSpaceName;
        return $this;
    }
    /**
     * Get referCallingSearchSpaceName value
     * @return XFkType|null
     */
    public function getReferCallingSearchSpaceName()
    {
        return $this->referCallingSearchSpaceName;
    }
    /**
     * Set referCallingSearchSpaceName value
     * @param XFkType $referCallingSearchSpaceName
     * @return RSipTrunk
     */
    public function setReferCallingSearchSpaceName(XFkType $referCallingSearchSpaceName = null)
    {
        $this->referCallingSearchSpaceName = $referCallingSearchSpaceName;
        return $this;
    }
    /**
     * Get mtpRequired value
     * @return string|null
     */
    public function getMtpRequired()
    {
        return $this->mtpRequired;
    }
    /**
     * Set mtpRequired value
     * @param string $mtpRequired
     * @return RSipTrunk
     */
    public function setMtpRequired($mtpRequired = null)
    {
        // validation for constraint: pattern
        if (is_scalar($mtpRequired) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $mtpRequired)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($mtpRequired, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($mtpRequired) && !is_string($mtpRequired)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mtpRequired)), __LINE__);
        }
        $this->mtpRequired = $mtpRequired;
        return $this;
    }
    /**
     * Get presenceGroupName value
     * @return XFkType|null
     */
    public function getPresenceGroupName()
    {
        return $this->presenceGroupName;
    }
    /**
     * Set presenceGroupName value
     * @param XFkType $presenceGroupName
     * @return RSipTrunk
     */
    public function setPresenceGroupName(XFkType $presenceGroupName = null)
    {
        $this->presenceGroupName = $presenceGroupName;
        return $this;
    }
    /**
     * Get unknownPrefix value
     * @return string|null
     */
    public function getUnknownPrefix()
    {
        return $this->unknownPrefix;
    }
    /**
     * Set unknownPrefix value
     * @param string $unknownPrefix
     * @return RSipTrunk
     */
    public function setUnknownPrefix($unknownPrefix = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($unknownPrefix) && strlen($unknownPrefix) > 16) || (is_array($unknownPrefix) && count($unknownPrefix) > 16)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 16 element(s) or a scalar of 16 character(s) at most, "%d" length given', is_scalar($unknownPrefix) ? strlen($unknownPrefix) : count($unknownPrefix)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($unknownPrefix) && !is_string($unknownPrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($unknownPrefix)), __LINE__);
        }
        $this->unknownPrefix = $unknownPrefix;
        return $this;
    }
    /**
     * Get destinationAddress value
     * @return string|null
     */
    public function getDestinationAddress()
    {
        return $this->destinationAddress;
    }
    /**
     * Set destinationAddress value
     * @param string $destinationAddress
     * @return RSipTrunk
     */
    public function setDestinationAddress($destinationAddress = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($destinationAddress) && strlen($destinationAddress) > 50) || (is_array($destinationAddress) && count($destinationAddress) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($destinationAddress) ? strlen($destinationAddress) : count($destinationAddress)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($destinationAddress) && !is_string($destinationAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($destinationAddress)), __LINE__);
        }
        $this->destinationAddress = $destinationAddress;
        return $this;
    }
    /**
     * Get destAddrIsSrv value
     * @return string|null
     */
    public function getDestAddrIsSrv()
    {
        return $this->destAddrIsSrv;
    }
    /**
     * Set destAddrIsSrv value
     * @param string $destAddrIsSrv
     * @return RSipTrunk
     */
    public function setDestAddrIsSrv($destAddrIsSrv = null)
    {
        // validation for constraint: pattern
        if (is_scalar($destAddrIsSrv) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $destAddrIsSrv)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($destAddrIsSrv, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($destAddrIsSrv) && !is_string($destAddrIsSrv)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($destAddrIsSrv)), __LINE__);
        }
        $this->destAddrIsSrv = $destAddrIsSrv;
        return $this;
    }
    /**
     * Get destinationport value
     * @return string|null
     */
    public function getDestinationport()
    {
        return $this->destinationport;
    }
    /**
     * Set destinationport value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $destinationport
     * @return RSipTrunk
     */
    public function setDestinationport($destinationport = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($destinationport)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $destinationport, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->destinationport = $destinationport;
        return $this;
    }
    /**
     * Get tkSipCodec value
     * @return string|null
     */
    public function getTkSipCodec()
    {
        return $this->tkSipCodec;
    }
    /**
     * Set tkSipCodec value
     * @uses XSIPCodec::valueIsValid()
     * @uses XSIPCodec::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $tkSipCodec
     * @return RSipTrunk
     */
    public function setTkSipCodec($tkSipCodec = null)
    {
        // validation for constraint: enumeration
        if (!XSIPCodec::valueIsValid($tkSipCodec)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $tkSipCodec, implode(', ', XSIPCodec::getValidValues())), __LINE__);
        }
        $this->tkSipCodec = $tkSipCodec;
        return $this;
    }
    /**
     * Get sigDigits value
     * @return SigDigits|null
     */
    public function getSigDigits()
    {
        return $this->sigDigits;
    }
    /**
     * Set sigDigits value
     * @param SigDigits $sigDigits
     * @return RSipTrunk
     */
    public function setSigDigits(SigDigits $sigDigits = null)
    {
        $this->sigDigits = $sigDigits;
        return $this;
    }
    /**
     * Get connectedNamePresentation value
     * @return string|null
     */
    public function getConnectedNamePresentation()
    {
        return $this->connectedNamePresentation;
    }
    /**
     * Set connectedNamePresentation value
     * @uses XPresentationBit::valueIsValid()
     * @uses XPresentationBit::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $connectedNamePresentation
     * @return RSipTrunk
     */
    public function setConnectedNamePresentation($connectedNamePresentation = null)
    {
        // validation for constraint: enumeration
        if (!XPresentationBit::valueIsValid($connectedNamePresentation)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $connectedNamePresentation, implode(', ', XPresentationBit::getValidValues())), __LINE__);
        }
        $this->connectedNamePresentation = $connectedNamePresentation;
        return $this;
    }
    /**
     * Get connectedPartyIdPresentation value
     * @return string|null
     */
    public function getConnectedPartyIdPresentation()
    {
        return $this->connectedPartyIdPresentation;
    }
    /**
     * Set connectedPartyIdPresentation value
     * @uses XPresentationBit::valueIsValid()
     * @uses XPresentationBit::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $connectedPartyIdPresentation
     * @return RSipTrunk
     */
    public function setConnectedPartyIdPresentation($connectedPartyIdPresentation = null)
    {
        // validation for constraint: enumeration
        if (!XPresentationBit::valueIsValid($connectedPartyIdPresentation)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $connectedPartyIdPresentation, implode(', ', XPresentationBit::getValidValues())), __LINE__);
        }
        $this->connectedPartyIdPresentation = $connectedPartyIdPresentation;
        return $this;
    }
    /**
     * Get callingPartySelection value
     * @return string|null
     */
    public function getCallingPartySelection()
    {
        return $this->callingPartySelection;
    }
    /**
     * Set callingPartySelection value
     * @uses XCallingPartySelection::valueIsValid()
     * @uses XCallingPartySelection::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callingPartySelection
     * @return RSipTrunk
     */
    public function setCallingPartySelection($callingPartySelection = null)
    {
        // validation for constraint: enumeration
        if (!XCallingPartySelection::valueIsValid($callingPartySelection)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $callingPartySelection, implode(', ', XCallingPartySelection::getValidValues())), __LINE__);
        }
        $this->callingPartySelection = $callingPartySelection;
        return $this;
    }
    /**
     * Get callingname value
     * @return string|null
     */
    public function getCallingname()
    {
        return $this->callingname;
    }
    /**
     * Set callingname value
     * @uses XPresentationBit::valueIsValid()
     * @uses XPresentationBit::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callingname
     * @return RSipTrunk
     */
    public function setCallingname($callingname = null)
    {
        // validation for constraint: enumeration
        if (!XPresentationBit::valueIsValid($callingname)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $callingname, implode(', ', XPresentationBit::getValidValues())), __LINE__);
        }
        $this->callingname = $callingname;
        return $this;
    }
    /**
     * Get callingLineIdPresentation value
     * @return string|null
     */
    public function getCallingLineIdPresentation()
    {
        return $this->callingLineIdPresentation;
    }
    /**
     * Set callingLineIdPresentation value
     * @uses XPresentationBit::valueIsValid()
     * @uses XPresentationBit::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callingLineIdPresentation
     * @return RSipTrunk
     */
    public function setCallingLineIdPresentation($callingLineIdPresentation = null)
    {
        // validation for constraint: enumeration
        if (!XPresentationBit::valueIsValid($callingLineIdPresentation)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $callingLineIdPresentation, implode(', ', XPresentationBit::getValidValues())), __LINE__);
        }
        $this->callingLineIdPresentation = $callingLineIdPresentation;
        return $this;
    }
    /**
     * Get prefixDn value
     * @return string|null
     */
    public function getPrefixDn()
    {
        return $this->prefixDn;
    }
    /**
     * Set prefixDn value
     * @param string $prefixDn
     * @return RSipTrunk
     */
    public function setPrefixDn($prefixDn = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($prefixDn) && strlen($prefixDn) > 50) || (is_array($prefixDn) && count($prefixDn) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($prefixDn) ? strlen($prefixDn) : count($prefixDn)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($prefixDn) && !is_string($prefixDn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($prefixDn)), __LINE__);
        }
        $this->prefixDn = $prefixDn;
        return $this;
    }
    /**
     * Get callerName value
     * @return string|null
     */
    public function getCallerName()
    {
        return $this->callerName;
    }
    /**
     * Set callerName value
     * @param string $callerName
     * @return RSipTrunk
     */
    public function setCallerName($callerName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($callerName) && strlen($callerName) > 50) || (is_array($callerName) && count($callerName) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($callerName) ? strlen($callerName) : count($callerName)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($callerName) && !is_string($callerName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($callerName)), __LINE__);
        }
        $this->callerName = $callerName;
        return $this;
    }
    /**
     * Get callerIdDn value
     * @return string|null
     */
    public function getCallerIdDn()
    {
        return $this->callerIdDn;
    }
    /**
     * Set callerIdDn value
     * @param string $callerIdDn
     * @return RSipTrunk
     */
    public function setCallerIdDn($callerIdDn = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($callerIdDn) && strlen($callerIdDn) > 50) || (is_array($callerIdDn) && count($callerIdDn) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($callerIdDn) ? strlen($callerIdDn) : count($callerIdDn)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($callerIdDn) && !is_string($callerIdDn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($callerIdDn)), __LINE__);
        }
        $this->callerIdDn = $callerIdDn;
        return $this;
    }
    /**
     * Get acceptInboundRdnis value
     * @return string|null
     */
    public function getAcceptInboundRdnis()
    {
        return $this->acceptInboundRdnis;
    }
    /**
     * Set acceptInboundRdnis value
     * @param string $acceptInboundRdnis
     * @return RSipTrunk
     */
    public function setAcceptInboundRdnis($acceptInboundRdnis = null)
    {
        // validation for constraint: pattern
        if (is_scalar($acceptInboundRdnis) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $acceptInboundRdnis)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($acceptInboundRdnis, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($acceptInboundRdnis) && !is_string($acceptInboundRdnis)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($acceptInboundRdnis)), __LINE__);
        }
        $this->acceptInboundRdnis = $acceptInboundRdnis;
        return $this;
    }
    /**
     * Get acceptOutboundRdnis value
     * @return string|null
     */
    public function getAcceptOutboundRdnis()
    {
        return $this->acceptOutboundRdnis;
    }
    /**
     * Set acceptOutboundRdnis value
     * @param string $acceptOutboundRdnis
     * @return RSipTrunk
     */
    public function setAcceptOutboundRdnis($acceptOutboundRdnis = null)
    {
        // validation for constraint: pattern
        if (is_scalar($acceptOutboundRdnis) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $acceptOutboundRdnis)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($acceptOutboundRdnis, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($acceptOutboundRdnis) && !is_string($acceptOutboundRdnis)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($acceptOutboundRdnis)), __LINE__);
        }
        $this->acceptOutboundRdnis = $acceptOutboundRdnis;
        return $this;
    }
    /**
     * Get srtpAllowed value
     * @return string|null
     */
    public function getSrtpAllowed()
    {
        return $this->srtpAllowed;
    }
    /**
     * Set srtpAllowed value
     * @param string $srtpAllowed
     * @return RSipTrunk
     */
    public function setSrtpAllowed($srtpAllowed = null)
    {
        // validation for constraint: pattern
        if (is_scalar($srtpAllowed) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $srtpAllowed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($srtpAllowed, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($srtpAllowed) && !is_string($srtpAllowed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($srtpAllowed)), __LINE__);
        }
        $this->srtpAllowed = $srtpAllowed;
        return $this;
    }
    /**
     * Get srtpFallbackAllowed value
     * @return string|null
     */
    public function getSrtpFallbackAllowed()
    {
        return $this->srtpFallbackAllowed;
    }
    /**
     * Set srtpFallbackAllowed value
     * @param string $srtpFallbackAllowed
     * @return RSipTrunk
     */
    public function setSrtpFallbackAllowed($srtpFallbackAllowed = null)
    {
        // validation for constraint: pattern
        if (is_scalar($srtpFallbackAllowed) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $srtpFallbackAllowed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($srtpFallbackAllowed, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($srtpFallbackAllowed) && !is_string($srtpFallbackAllowed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($srtpFallbackAllowed)), __LINE__);
        }
        $this->srtpFallbackAllowed = $srtpFallbackAllowed;
        return $this;
    }
    /**
     * Get isPaiEnabled value
     * @return string|null
     */
    public function getIsPaiEnabled()
    {
        return $this->isPaiEnabled;
    }
    /**
     * Set isPaiEnabled value
     * @param string $isPaiEnabled
     * @return RSipTrunk
     */
    public function setIsPaiEnabled($isPaiEnabled = null)
    {
        // validation for constraint: pattern
        if (is_scalar($isPaiEnabled) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $isPaiEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($isPaiEnabled, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($isPaiEnabled) && !is_string($isPaiEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($isPaiEnabled)), __LINE__);
        }
        $this->isPaiEnabled = $isPaiEnabled;
        return $this;
    }
    /**
     * Get sipPrivacy value
     * @return string|null
     */
    public function getSipPrivacy()
    {
        return $this->sipPrivacy;
    }
    /**
     * Set sipPrivacy value
     * @uses XSipPrivacy::valueIsValid()
     * @uses XSipPrivacy::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sipPrivacy
     * @return RSipTrunk
     */
    public function setSipPrivacy($sipPrivacy = null)
    {
        // validation for constraint: enumeration
        if (!XSipPrivacy::valueIsValid($sipPrivacy)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $sipPrivacy, implode(', ', XSipPrivacy::getValidValues())), __LINE__);
        }
        $this->sipPrivacy = $sipPrivacy;
        return $this;
    }
    /**
     * Get isRpidEnabled value
     * @return string|null
     */
    public function getIsRpidEnabled()
    {
        return $this->isRpidEnabled;
    }
    /**
     * Set isRpidEnabled value
     * @param string $isRpidEnabled
     * @return RSipTrunk
     */
    public function setIsRpidEnabled($isRpidEnabled = null)
    {
        // validation for constraint: pattern
        if (is_scalar($isRpidEnabled) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $isRpidEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($isRpidEnabled, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($isRpidEnabled) && !is_string($isRpidEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($isRpidEnabled)), __LINE__);
        }
        $this->isRpidEnabled = $isRpidEnabled;
        return $this;
    }
    /**
     * Get sipAssertedType value
     * @return string|null
     */
    public function getSipAssertedType()
    {
        return $this->sipAssertedType;
    }
    /**
     * Set sipAssertedType value
     * @uses XSipAssertedType::valueIsValid()
     * @uses XSipAssertedType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sipAssertedType
     * @return RSipTrunk
     */
    public function setSipAssertedType($sipAssertedType = null)
    {
        // validation for constraint: enumeration
        if (!XSipAssertedType::valueIsValid($sipAssertedType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $sipAssertedType, implode(', ', XSipAssertedType::getValidValues())), __LINE__);
        }
        $this->sipAssertedType = $sipAssertedType;
        return $this;
    }
    /**
     * Get destinationAddressIpv6 value
     * @return string|null
     */
    public function getDestinationAddressIpv6()
    {
        return $this->destinationAddressIpv6;
    }
    /**
     * Set destinationAddressIpv6 value
     * @param string $destinationAddressIpv6
     * @return RSipTrunk
     */
    public function setDestinationAddressIpv6($destinationAddressIpv6 = null)
    {
        // validation for constraint: string
        if (!is_null($destinationAddressIpv6) && !is_string($destinationAddressIpv6)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($destinationAddressIpv6)), __LINE__);
        }
        $this->destinationAddressIpv6 = $destinationAddressIpv6;
        return $this;
    }
    /**
     * Get dtmfSignalingMethod value
     * @return string|null
     */
    public function getDtmfSignalingMethod()
    {
        return $this->dtmfSignalingMethod;
    }
    /**
     * Set dtmfSignalingMethod value
     * @uses XDTMFSignaling::valueIsValid()
     * @uses XDTMFSignaling::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dtmfSignalingMethod
     * @return RSipTrunk
     */
    public function setDtmfSignalingMethod($dtmfSignalingMethod = null)
    {
        // validation for constraint: enumeration
        if (!XDTMFSignaling::valueIsValid($dtmfSignalingMethod)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $dtmfSignalingMethod, implode(', ', XDTMFSignaling::getValidValues())), __LINE__);
        }
        $this->dtmfSignalingMethod = $dtmfSignalingMethod;
        return $this;
    }
    /**
     * Get routeClassSignalling value
     * @return string|null
     */
    public function getRouteClassSignalling()
    {
        return $this->routeClassSignalling;
    }
    /**
     * Set routeClassSignalling value
     * @uses XStatus::valueIsValid()
     * @uses XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $routeClassSignalling
     * @return RSipTrunk
     */
    public function setRouteClassSignalling($routeClassSignalling = null)
    {
        // validation for constraint: enumeration
        if (!XStatus::valueIsValid($routeClassSignalling)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $routeClassSignalling, implode(', ', XStatus::getValidValues())), __LINE__);
        }
        $this->routeClassSignalling = $routeClassSignalling;
        return $this;
    }
    /**
     * Get sipTrunkType value
     * @return string|null
     */
    public function getSipTrunkType()
    {
        return $this->sipTrunkType;
    }
    /**
     * Set sipTrunkType value
     * @uses XTrunkService::valueIsValid()
     * @uses XTrunkService::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sipTrunkType
     * @return RSipTrunk
     */
    public function setSipTrunkType($sipTrunkType = null)
    {
        // validation for constraint: enumeration
        if (!XTrunkService::valueIsValid($sipTrunkType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $sipTrunkType, implode(', ', XTrunkService::getValidValues())), __LINE__);
        }
        $this->sipTrunkType = $sipTrunkType;
        return $this;
    }
    /**
     * Get pstnAccess value
     * @return string|null
     */
    public function getPstnAccess()
    {
        return $this->pstnAccess;
    }
    /**
     * Set pstnAccess value
     * @param string $pstnAccess
     * @return RSipTrunk
     */
    public function setPstnAccess($pstnAccess = null)
    {
        // validation for constraint: pattern
        if (is_scalar($pstnAccess) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $pstnAccess)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($pstnAccess, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($pstnAccess) && !is_string($pstnAccess)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pstnAccess)), __LINE__);
        }
        $this->pstnAccess = $pstnAccess;
        return $this;
    }
    /**
     * Get imeE164TransformationName value
     * @return XFkType|null
     */
    public function getImeE164TransformationName()
    {
        return $this->imeE164TransformationName;
    }
    /**
     * Set imeE164TransformationName value
     * @param XFkType $imeE164TransformationName
     * @return RSipTrunk
     */
    public function setImeE164TransformationName(XFkType $imeE164TransformationName = null)
    {
        $this->imeE164TransformationName = $imeE164TransformationName;
        return $this;
    }
    /**
     * Get useImePublicIpPort value
     * @return string|null
     */
    public function getUseImePublicIpPort()
    {
        return $this->useImePublicIpPort;
    }
    /**
     * Set useImePublicIpPort value
     * @param string $useImePublicIpPort
     * @return RSipTrunk
     */
    public function setUseImePublicIpPort($useImePublicIpPort = null)
    {
        // validation for constraint: pattern
        if (is_scalar($useImePublicIpPort) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $useImePublicIpPort)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($useImePublicIpPort, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($useImePublicIpPort) && !is_string($useImePublicIpPort)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($useImePublicIpPort)), __LINE__);
        }
        $this->useImePublicIpPort = $useImePublicIpPort;
        return $this;
    }
    /**
     * Get useDevicePoolCntdPnTransformationCss value
     * @return string|null
     */
    public function getUseDevicePoolCntdPnTransformationCss()
    {
        return $this->useDevicePoolCntdPnTransformationCss;
    }
    /**
     * Set useDevicePoolCntdPnTransformationCss value
     * @param string $useDevicePoolCntdPnTransformationCss
     * @return RSipTrunk
     */
    public function setUseDevicePoolCntdPnTransformationCss($useDevicePoolCntdPnTransformationCss = null)
    {
        // validation for constraint: pattern
        if (is_scalar($useDevicePoolCntdPnTransformationCss) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $useDevicePoolCntdPnTransformationCss)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($useDevicePoolCntdPnTransformationCss, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($useDevicePoolCntdPnTransformationCss) && !is_string($useDevicePoolCntdPnTransformationCss)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($useDevicePoolCntdPnTransformationCss)), __LINE__);
        }
        $this->useDevicePoolCntdPnTransformationCss = $useDevicePoolCntdPnTransformationCss;
        return $this;
    }
    /**
     * Get cntdPnTransformationCssName value
     * @return XFkType|null
     */
    public function getCntdPnTransformationCssName()
    {
        return $this->cntdPnTransformationCssName;
    }
    /**
     * Set cntdPnTransformationCssName value
     * @param XFkType $cntdPnTransformationCssName
     * @return RSipTrunk
     */
    public function setCntdPnTransformationCssName(XFkType $cntdPnTransformationCssName = null)
    {
        $this->cntdPnTransformationCssName = $cntdPnTransformationCssName;
        return $this;
    }
    /**
     * Get useDevicePoolCgpnTransformCssUnkn value
     * @return string|null
     */
    public function getUseDevicePoolCgpnTransformCssUnkn()
    {
        return $this->useDevicePoolCgpnTransformCssUnkn;
    }
    /**
     * Set useDevicePoolCgpnTransformCssUnkn value
     * @param string $useDevicePoolCgpnTransformCssUnkn
     * @return RSipTrunk
     */
    public function setUseDevicePoolCgpnTransformCssUnkn($useDevicePoolCgpnTransformCssUnkn = null)
    {
        // validation for constraint: pattern
        if (is_scalar($useDevicePoolCgpnTransformCssUnkn) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $useDevicePoolCgpnTransformCssUnkn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($useDevicePoolCgpnTransformCssUnkn, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($useDevicePoolCgpnTransformCssUnkn) && !is_string($useDevicePoolCgpnTransformCssUnkn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($useDevicePoolCgpnTransformCssUnkn)), __LINE__);
        }
        $this->useDevicePoolCgpnTransformCssUnkn = $useDevicePoolCgpnTransformCssUnkn;
        return $this;
    }
    /**
     * Get sipNormalizationScriptName value
     * @return XFkType|null
     */
    public function getSipNormalizationScriptName()
    {
        return $this->sipNormalizationScriptName;
    }
    /**
     * Set sipNormalizationScriptName value
     * @param XFkType $sipNormalizationScriptName
     * @return RSipTrunk
     */
    public function setSipNormalizationScriptName(XFkType $sipNormalizationScriptName = null)
    {
        $this->sipNormalizationScriptName = $sipNormalizationScriptName;
        return $this;
    }
    /**
     * Get runOnEveryNode value
     * @return string|null
     */
    public function getRunOnEveryNode()
    {
        return $this->runOnEveryNode;
    }
    /**
     * Set runOnEveryNode value
     * @param string $runOnEveryNode
     * @return RSipTrunk
     */
    public function setRunOnEveryNode($runOnEveryNode = null)
    {
        // validation for constraint: pattern
        if (is_scalar($runOnEveryNode) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $runOnEveryNode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($runOnEveryNode, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($runOnEveryNode) && !is_string($runOnEveryNode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($runOnEveryNode)), __LINE__);
        }
        $this->runOnEveryNode = $runOnEveryNode;
        return $this;
    }
    /**
     * Get destinations value
     * @return Destinations|null
     */
    public function getDestinations()
    {
        return $this->destinations;
    }
    /**
     * Set destinations value
     * @param Destinations $destinations
     * @return RSipTrunk
     */
    public function setDestinations(Destinations $destinations = null)
    {
        $this->destinations = $destinations;
        return $this;
    }
    /**
     * Get unknownStripDigits value
     * @return int|null
     */
    public function getUnknownStripDigits()
    {
        return $this->unknownStripDigits;
    }
    /**
     * Set unknownStripDigits value
     * @param int $unknownStripDigits
     * @return RSipTrunk
     */
    public function setUnknownStripDigits($unknownStripDigits = null)
    {
        // validation for constraint: int
        if (!is_null($unknownStripDigits) && !is_numeric($unknownStripDigits)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($unknownStripDigits)), __LINE__);
        }
        $this->unknownStripDigits = $unknownStripDigits;
        return $this;
    }
    /**
     * Get cgpnTransformationUnknownCssName value
     * @return XFkType|null
     */
    public function getCgpnTransformationUnknownCssName()
    {
        return $this->cgpnTransformationUnknownCssName;
    }
    /**
     * Set cgpnTransformationUnknownCssName value
     * @param XFkType $cgpnTransformationUnknownCssName
     * @return RSipTrunk
     */
    public function setCgpnTransformationUnknownCssName(XFkType $cgpnTransformationUnknownCssName = null)
    {
        $this->cgpnTransformationUnknownCssName = $cgpnTransformationUnknownCssName;
        return $this;
    }
    /**
     * Get tunneledProtocol value
     * @return string|null
     */
    public function getTunneledProtocol()
    {
        return $this->tunneledProtocol;
    }
    /**
     * Set tunneledProtocol value
     * @uses XTunneledProtocol::valueIsValid()
     * @uses XTunneledProtocol::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $tunneledProtocol
     * @return RSipTrunk
     */
    public function setTunneledProtocol($tunneledProtocol = null)
    {
        // validation for constraint: enumeration
        if (!XTunneledProtocol::valueIsValid($tunneledProtocol)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $tunneledProtocol, implode(', ', XTunneledProtocol::getValidValues())), __LINE__);
        }
        $this->tunneledProtocol = $tunneledProtocol;
        return $this;
    }
    /**
     * Get asn1RoseOidEncoding value
     * @return string|null
     */
    public function getAsn1RoseOidEncoding()
    {
        return $this->asn1RoseOidEncoding;
    }
    /**
     * Set asn1RoseOidEncoding value
     * @uses XASN1RoseOidEncoding::valueIsValid()
     * @uses XASN1RoseOidEncoding::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $asn1RoseOidEncoding
     * @return RSipTrunk
     */
    public function setAsn1RoseOidEncoding($asn1RoseOidEncoding = null)
    {
        // validation for constraint: enumeration
        if (!XASN1RoseOidEncoding::valueIsValid($asn1RoseOidEncoding)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $asn1RoseOidEncoding, implode(', ', XASN1RoseOidEncoding::getValidValues())), __LINE__);
        }
        $this->asn1RoseOidEncoding = $asn1RoseOidEncoding;
        return $this;
    }
    /**
     * Get qsigVariant value
     * @return string|null
     */
    public function getQsigVariant()
    {
        return $this->qsigVariant;
    }
    /**
     * Set qsigVariant value
     * @uses XQSIGVariant::valueIsValid()
     * @uses XQSIGVariant::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $qsigVariant
     * @return RSipTrunk
     */
    public function setQsigVariant($qsigVariant = null)
    {
        // validation for constraint: enumeration
        if (!XQSIGVariant::valueIsValid($qsigVariant)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $qsigVariant, implode(', ', XQSIGVariant::getValidValues())), __LINE__);
        }
        $this->qsigVariant = $qsigVariant;
        return $this;
    }
    /**
     * Get pathReplacementSupport value
     * @return string|null
     */
    public function getPathReplacementSupport()
    {
        return $this->pathReplacementSupport;
    }
    /**
     * Set pathReplacementSupport value
     * @param string $pathReplacementSupport
     * @return RSipTrunk
     */
    public function setPathReplacementSupport($pathReplacementSupport = null)
    {
        // validation for constraint: pattern
        if (is_scalar($pathReplacementSupport) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $pathReplacementSupport)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($pathReplacementSupport, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($pathReplacementSupport) && !is_string($pathReplacementSupport)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pathReplacementSupport)), __LINE__);
        }
        $this->pathReplacementSupport = $pathReplacementSupport;
        return $this;
    }
    /**
     * Get enableQsigUtf8 value
     * @return string|null
     */
    public function getEnableQsigUtf8()
    {
        return $this->enableQsigUtf8;
    }
    /**
     * Set enableQsigUtf8 value
     * @param string $enableQsigUtf8
     * @return RSipTrunk
     */
    public function setEnableQsigUtf8($enableQsigUtf8 = null)
    {
        // validation for constraint: pattern
        if (is_scalar($enableQsigUtf8) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $enableQsigUtf8)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($enableQsigUtf8, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($enableQsigUtf8) && !is_string($enableQsigUtf8)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($enableQsigUtf8)), __LINE__);
        }
        $this->enableQsigUtf8 = $enableQsigUtf8;
        return $this;
    }
    /**
     * Get scriptParameters value
     * @return string|null
     */
    public function getScriptParameters()
    {
        return $this->scriptParameters;
    }
    /**
     * Set scriptParameters value
     * @param string $scriptParameters
     * @return RSipTrunk
     */
    public function setScriptParameters($scriptParameters = null)
    {
        // validation for constraint: string
        if (!is_null($scriptParameters) && !is_string($scriptParameters)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($scriptParameters)), __LINE__);
        }
        $this->scriptParameters = $scriptParameters;
        return $this;
    }
    /**
     * Get scriptTraceEnabled value
     * @return string|null
     */
    public function getScriptTraceEnabled()
    {
        return $this->scriptTraceEnabled;
    }
    /**
     * Set scriptTraceEnabled value
     * @param string $scriptTraceEnabled
     * @return RSipTrunk
     */
    public function setScriptTraceEnabled($scriptTraceEnabled = null)
    {
        // validation for constraint: pattern
        if (is_scalar($scriptTraceEnabled) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $scriptTraceEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($scriptTraceEnabled, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($scriptTraceEnabled) && !is_string($scriptTraceEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($scriptTraceEnabled)), __LINE__);
        }
        $this->scriptTraceEnabled = $scriptTraceEnabled;
        return $this;
    }
    /**
     * Get trunkTrafficSecure value
     * @return string|null
     */
    public function getTrunkTrafficSecure()
    {
        return $this->trunkTrafficSecure;
    }
    /**
     * Set trunkTrafficSecure value
     * @uses XSIPTrunkCallLegSecurity::valueIsValid()
     * @uses XSIPTrunkCallLegSecurity::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $trunkTrafficSecure
     * @return RSipTrunk
     */
    public function setTrunkTrafficSecure($trunkTrafficSecure = null)
    {
        // validation for constraint: enumeration
        if (!XSIPTrunkCallLegSecurity::valueIsValid($trunkTrafficSecure)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $trunkTrafficSecure, implode(', ', XSIPTrunkCallLegSecurity::getValidValues())), __LINE__);
        }
        $this->trunkTrafficSecure = $trunkTrafficSecure;
        return $this;
    }
    /**
     * Get callingAndCalledPartyInfoFormat value
     * @return string|null
     */
    public function getCallingAndCalledPartyInfoFormat()
    {
        return $this->callingAndCalledPartyInfoFormat;
    }
    /**
     * Set callingAndCalledPartyInfoFormat value
     * @uses XSIPIdentityBlend::valueIsValid()
     * @uses XSIPIdentityBlend::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callingAndCalledPartyInfoFormat
     * @return RSipTrunk
     */
    public function setCallingAndCalledPartyInfoFormat($callingAndCalledPartyInfoFormat = null)
    {
        // validation for constraint: enumeration
        if (!XSIPIdentityBlend::valueIsValid($callingAndCalledPartyInfoFormat)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $callingAndCalledPartyInfoFormat, implode(', ', XSIPIdentityBlend::getValidValues())), __LINE__);
        }
        $this->callingAndCalledPartyInfoFormat = $callingAndCalledPartyInfoFormat;
        return $this;
    }
    /**
     * Get useCallerIdCallerNameinUriOutgoingRequest value
     * @return string|null
     */
    public function getUseCallerIdCallerNameinUriOutgoingRequest()
    {
        return $this->useCallerIdCallerNameinUriOutgoingRequest;
    }
    /**
     * Set useCallerIdCallerNameinUriOutgoingRequest value
     * @param string $useCallerIdCallerNameinUriOutgoingRequest
     * @return RSipTrunk
     */
    public function setUseCallerIdCallerNameinUriOutgoingRequest($useCallerIdCallerNameinUriOutgoingRequest = null)
    {
        // validation for constraint: pattern
        if (is_scalar($useCallerIdCallerNameinUriOutgoingRequest) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $useCallerIdCallerNameinUriOutgoingRequest)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($useCallerIdCallerNameinUriOutgoingRequest, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($useCallerIdCallerNameinUriOutgoingRequest) && !is_string($useCallerIdCallerNameinUriOutgoingRequest)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($useCallerIdCallerNameinUriOutgoingRequest)), __LINE__);
        }
        $this->useCallerIdCallerNameinUriOutgoingRequest = $useCallerIdCallerNameinUriOutgoingRequest;
        return $this;
    }
    /**
     * Get requestUriDomainName value
     * @return string|null
     */
    public function getRequestUriDomainName()
    {
        return $this->requestUriDomainName;
    }
    /**
     * Set requestUriDomainName value
     * @param string $requestUriDomainName
     * @return RSipTrunk
     */
    public function setRequestUriDomainName($requestUriDomainName = null)
    {
        // validation for constraint: string
        if (!is_null($requestUriDomainName) && !is_string($requestUriDomainName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($requestUriDomainName)), __LINE__);
        }
        $this->requestUriDomainName = $requestUriDomainName;
        return $this;
    }
    /**
     * Get ctiid value
     * @return int|null
     */
    public function getCtiid()
    {
        return $this->ctiid;
    }
    /**
     * Set ctiid value
     * @param int $ctiid
     * @return RSipTrunk
     */
    public function setCtiid($ctiid = null)
    {
        // validation for constraint: int
        if (!is_null($ctiid) && !is_numeric($ctiid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($ctiid)), __LINE__);
        }
        $this->ctiid = $ctiid;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return RSipTrunk
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\{........-....-....-....-............\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return RSipTrunk
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
