<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RSafCcdPurgeBlockLearnedRoutes StructType
 * @subpackage Structs
 */
class RSafCcdPurgeBlockLearnedRoutes extends AbstractStructBase
{
    /**
     * The learnedPattern
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 50
     * @var string
     */
    public $learnedPattern;
    /**
     * The learnedPatternPrefix
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 50
     * @var string
     */
    public $learnedPatternPrefix;
    /**
     * The callControlIdentity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 50
     * @var string
     */
    public $callControlIdentity;
    /**
     * The ipAddress
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 50
     * @var string
     */
    public $ipAddress;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RSafCcdPurgeBlockLearnedRoutes
     * @uses RSafCcdPurgeBlockLearnedRoutes::setLearnedPattern()
     * @uses RSafCcdPurgeBlockLearnedRoutes::setLearnedPatternPrefix()
     * @uses RSafCcdPurgeBlockLearnedRoutes::setCallControlIdentity()
     * @uses RSafCcdPurgeBlockLearnedRoutes::setIpAddress()
     * @uses RSafCcdPurgeBlockLearnedRoutes::setUuid()
     * @param string $learnedPattern
     * @param string $learnedPatternPrefix
     * @param string $callControlIdentity
     * @param string $ipAddress
     * @param string $uuid
     */
    public function __construct($learnedPattern = null, $learnedPatternPrefix = null, $callControlIdentity = null, $ipAddress = null, $uuid = null)
    {
        $this
            ->setLearnedPattern($learnedPattern)
            ->setLearnedPatternPrefix($learnedPatternPrefix)
            ->setCallControlIdentity($callControlIdentity)
            ->setIpAddress($ipAddress)
            ->setUuid($uuid);
    }
    /**
     * Get learnedPattern value
     * @return string|null
     */
    public function getLearnedPattern()
    {
        return $this->learnedPattern;
    }
    /**
     * Set learnedPattern value
     * @param string $learnedPattern
     * @return RSafCcdPurgeBlockLearnedRoutes
     */
    public function setLearnedPattern($learnedPattern = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($learnedPattern) && strlen($learnedPattern) > 50) || (is_array($learnedPattern) && count($learnedPattern) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($learnedPattern) ? strlen($learnedPattern) : count($learnedPattern)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($learnedPattern) && !is_string($learnedPattern)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($learnedPattern)), __LINE__);
        }
        $this->learnedPattern = $learnedPattern;
        return $this;
    }
    /**
     * Get learnedPatternPrefix value
     * @return string|null
     */
    public function getLearnedPatternPrefix()
    {
        return $this->learnedPatternPrefix;
    }
    /**
     * Set learnedPatternPrefix value
     * @param string $learnedPatternPrefix
     * @return RSafCcdPurgeBlockLearnedRoutes
     */
    public function setLearnedPatternPrefix($learnedPatternPrefix = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($learnedPatternPrefix) && strlen($learnedPatternPrefix) > 50) || (is_array($learnedPatternPrefix) && count($learnedPatternPrefix) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($learnedPatternPrefix) ? strlen($learnedPatternPrefix) : count($learnedPatternPrefix)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($learnedPatternPrefix) && !is_string($learnedPatternPrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($learnedPatternPrefix)), __LINE__);
        }
        $this->learnedPatternPrefix = $learnedPatternPrefix;
        return $this;
    }
    /**
     * Get callControlIdentity value
     * @return string|null
     */
    public function getCallControlIdentity()
    {
        return $this->callControlIdentity;
    }
    /**
     * Set callControlIdentity value
     * @param string $callControlIdentity
     * @return RSafCcdPurgeBlockLearnedRoutes
     */
    public function setCallControlIdentity($callControlIdentity = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($callControlIdentity) && strlen($callControlIdentity) > 50) || (is_array($callControlIdentity) && count($callControlIdentity) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($callControlIdentity) ? strlen($callControlIdentity) : count($callControlIdentity)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($callControlIdentity) && !is_string($callControlIdentity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($callControlIdentity)), __LINE__);
        }
        $this->callControlIdentity = $callControlIdentity;
        return $this;
    }
    /**
     * Get ipAddress value
     * @return string|null
     */
    public function getIpAddress()
    {
        return $this->ipAddress;
    }
    /**
     * Set ipAddress value
     * @param string $ipAddress
     * @return RSafCcdPurgeBlockLearnedRoutes
     */
    public function setIpAddress($ipAddress = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($ipAddress) && strlen($ipAddress) > 50) || (is_array($ipAddress) && count($ipAddress) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($ipAddress) ? strlen($ipAddress) : count($ipAddress)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($ipAddress) && !is_string($ipAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ipAddress)), __LINE__);
        }
        $this->ipAddress = $ipAddress;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return RSafCcdPurgeBlockLearnedRoutes
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\{........-....-....-....-............\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return RSafCcdPurgeBlockLearnedRoutes
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
