<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RObjectList StructType
 * @subpackage Structs
 */
class RObjectList extends AbstractStructBase
{
    /**
     * The object
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 32
     * @var string
     */
    public $object;
    /**
     * Constructor method for RObjectList
     * @uses RObjectList::setObject()
     * @param string $object
     */
    public function __construct($object = null)
    {
        $this
            ->setObject($object);
    }
    /**
     * Get object value
     * @return string|null
     */
    public function getObject()
    {
        return $this->object;
    }
    /**
     * Set object value
     * @param string $object
     * @return RObjectList
     */
    public function setObject($object = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($object) && strlen($object) > 32) || (is_array($object) && count($object) > 32)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 32 element(s) or a scalar of 32 character(s) at most, "%d" length given', is_scalar($object) ? strlen($object) : count($object)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($object) && !is_string($object)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($object)), __LINE__);
        }
        $this->object = $object;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return RObjectList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
