<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RNotification StructType
 * @subpackage Structs
 */
class RNotification extends AbstractStructBase
{
    /**
     * The objectList
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var XNotification[]
     */
    public $objectList;
    /**
     * Constructor method for RNotification
     * @uses RNotification::setObjectList()
     * @param XNotification[] $objectList
     */
    public function __construct(array $objectList = array())
    {
        $this
            ->setObjectList($objectList);
    }
    /**
     * Get objectList value
     * @return XNotification[]|null
     */
    public function getObjectList()
    {
        return $this->objectList;
    }
    /**
     * Set objectList value
     * @throws \InvalidArgumentException
     * @param XNotification[] $objectList
     * @return RNotification
     */
    public function setObjectList(array $objectList = array())
    {
        foreach ($objectList as $rNotificationObjectListItem) {
            // validation for constraint: itemType
            if (!$rNotificationObjectListItem instanceof XNotification) {
                throw new \InvalidArgumentException(sprintf('The objectList property can only contain items of XNotification, "%s" given', is_object($rNotificationObjectListItem) ? get_class($rNotificationObjectListItem) : gettype($rNotificationObjectListItem)), __LINE__);
            }
        }
        $this->objectList = $objectList;
        return $this;
    }
    /**
     * Add item to objectList value
     * @throws \InvalidArgumentException
     * @param XNotification $item
     * @return RNotification
     */
    public function addToObjectList(XNotification $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof XNotification) {
            throw new \InvalidArgumentException(sprintf('The objectList property can only contain items of XNotification, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->objectList[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return RNotification
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
