<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RImeClient StructType
 * @subpackage Structs
 */
class RImeClient extends AbstractStructBase
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 50
     * @var string
     */
    public $name;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The domain
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 255
     * @var string
     */
    public $domain;
    /**
     * The isActivated
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $isActivated;
    /**
     * The sipTrunkName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $sipTrunkName;
    /**
     * The primaryImeServerName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $primaryImeServerName;
    /**
     * The secondaryImeServerName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $secondaryImeServerName;
    /**
     * The learnedRouteFilterGroupName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $learnedRouteFilterGroupName;
    /**
     * The exclusionNumberGroupName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $exclusionNumberGroupName;
    /**
     * The firewallName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $firewallName;
    /**
     * The members
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var Members
     */
    public $members;
    /**
     * The ccmExternalIpMaps
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var CcmExternalIpMaps
     */
    public $ccmExternalIpMaps;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RImeClient
     * @uses RImeClient::setName()
     * @uses RImeClient::setDescription()
     * @uses RImeClient::setDomain()
     * @uses RImeClient::setIsActivated()
     * @uses RImeClient::setSipTrunkName()
     * @uses RImeClient::setPrimaryImeServerName()
     * @uses RImeClient::setSecondaryImeServerName()
     * @uses RImeClient::setLearnedRouteFilterGroupName()
     * @uses RImeClient::setExclusionNumberGroupName()
     * @uses RImeClient::setFirewallName()
     * @uses RImeClient::setMembers()
     * @uses RImeClient::setCcmExternalIpMaps()
     * @uses RImeClient::setUuid()
     * @param string $name
     * @param string $description
     * @param string $domain
     * @param string $isActivated
     * @param XFkType $sipTrunkName
     * @param XFkType $primaryImeServerName
     * @param XFkType $secondaryImeServerName
     * @param XFkType $learnedRouteFilterGroupName
     * @param XFkType $exclusionNumberGroupName
     * @param XFkType $firewallName
     * @param Members $members
     * @param CcmExternalIpMaps $ccmExternalIpMaps
     * @param string $uuid
     */
    public function __construct($name = null, $description = null, $domain = null, $isActivated = null, XFkType $sipTrunkName = null, XFkType $primaryImeServerName = null, XFkType $secondaryImeServerName = null, XFkType $learnedRouteFilterGroupName = null, XFkType $exclusionNumberGroupName = null, XFkType $firewallName = null, Members $members = null, CcmExternalIpMaps $ccmExternalIpMaps = null, $uuid = null)
    {
        $this
            ->setName($name)
            ->setDescription($description)
            ->setDomain($domain)
            ->setIsActivated($isActivated)
            ->setSipTrunkName($sipTrunkName)
            ->setPrimaryImeServerName($primaryImeServerName)
            ->setSecondaryImeServerName($secondaryImeServerName)
            ->setLearnedRouteFilterGroupName($learnedRouteFilterGroupName)
            ->setExclusionNumberGroupName($exclusionNumberGroupName)
            ->setFirewallName($firewallName)
            ->setMembers($members)
            ->setCcmExternalIpMaps($ccmExternalIpMaps)
            ->setUuid($uuid);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return RImeClient
     */
    public function setName($name = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($name) && strlen($name) > 50) || (is_array($name) && count($name) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($name) ? strlen($name) : count($name)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return RImeClient
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get domain value
     * @return string|null
     */
    public function getDomain()
    {
        return $this->domain;
    }
    /**
     * Set domain value
     * @param string $domain
     * @return RImeClient
     */
    public function setDomain($domain = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($domain) && strlen($domain) > 255) || (is_array($domain) && count($domain) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($domain) ? strlen($domain) : count($domain)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($domain) && !is_string($domain)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($domain)), __LINE__);
        }
        $this->domain = $domain;
        return $this;
    }
    /**
     * Get isActivated value
     * @return string|null
     */
    public function getIsActivated()
    {
        return $this->isActivated;
    }
    /**
     * Set isActivated value
     * @param string $isActivated
     * @return RImeClient
     */
    public function setIsActivated($isActivated = null)
    {
        // validation for constraint: pattern
        if (is_scalar($isActivated) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $isActivated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($isActivated, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($isActivated) && !is_string($isActivated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($isActivated)), __LINE__);
        }
        $this->isActivated = $isActivated;
        return $this;
    }
    /**
     * Get sipTrunkName value
     * @return XFkType|null
     */
    public function getSipTrunkName()
    {
        return $this->sipTrunkName;
    }
    /**
     * Set sipTrunkName value
     * @param XFkType $sipTrunkName
     * @return RImeClient
     */
    public function setSipTrunkName(XFkType $sipTrunkName = null)
    {
        $this->sipTrunkName = $sipTrunkName;
        return $this;
    }
    /**
     * Get primaryImeServerName value
     * @return XFkType|null
     */
    public function getPrimaryImeServerName()
    {
        return $this->primaryImeServerName;
    }
    /**
     * Set primaryImeServerName value
     * @param XFkType $primaryImeServerName
     * @return RImeClient
     */
    public function setPrimaryImeServerName(XFkType $primaryImeServerName = null)
    {
        $this->primaryImeServerName = $primaryImeServerName;
        return $this;
    }
    /**
     * Get secondaryImeServerName value
     * @return XFkType|null
     */
    public function getSecondaryImeServerName()
    {
        return $this->secondaryImeServerName;
    }
    /**
     * Set secondaryImeServerName value
     * @param XFkType $secondaryImeServerName
     * @return RImeClient
     */
    public function setSecondaryImeServerName(XFkType $secondaryImeServerName = null)
    {
        $this->secondaryImeServerName = $secondaryImeServerName;
        return $this;
    }
    /**
     * Get learnedRouteFilterGroupName value
     * @return XFkType|null
     */
    public function getLearnedRouteFilterGroupName()
    {
        return $this->learnedRouteFilterGroupName;
    }
    /**
     * Set learnedRouteFilterGroupName value
     * @param XFkType $learnedRouteFilterGroupName
     * @return RImeClient
     */
    public function setLearnedRouteFilterGroupName(XFkType $learnedRouteFilterGroupName = null)
    {
        $this->learnedRouteFilterGroupName = $learnedRouteFilterGroupName;
        return $this;
    }
    /**
     * Get exclusionNumberGroupName value
     * @return XFkType|null
     */
    public function getExclusionNumberGroupName()
    {
        return $this->exclusionNumberGroupName;
    }
    /**
     * Set exclusionNumberGroupName value
     * @param XFkType $exclusionNumberGroupName
     * @return RImeClient
     */
    public function setExclusionNumberGroupName(XFkType $exclusionNumberGroupName = null)
    {
        $this->exclusionNumberGroupName = $exclusionNumberGroupName;
        return $this;
    }
    /**
     * Get firewallName value
     * @return XFkType|null
     */
    public function getFirewallName()
    {
        return $this->firewallName;
    }
    /**
     * Set firewallName value
     * @param XFkType $firewallName
     * @return RImeClient
     */
    public function setFirewallName(XFkType $firewallName = null)
    {
        $this->firewallName = $firewallName;
        return $this;
    }
    /**
     * Get members value
     * @return Members|null
     */
    public function getMembers()
    {
        return $this->members;
    }
    /**
     * Set members value
     * @param Members $members
     * @return RImeClient
     */
    public function setMembers(Members $members = null)
    {
        $this->members = $members;
        return $this;
    }
    /**
     * Get ccmExternalIpMaps value
     * @return CcmExternalIpMaps|null
     */
    public function getCcmExternalIpMaps()
    {
        return $this->ccmExternalIpMaps;
    }
    /**
     * Set ccmExternalIpMaps value
     * @param CcmExternalIpMaps $ccmExternalIpMaps
     * @return RImeClient
     */
    public function setCcmExternalIpMaps(CcmExternalIpMaps $ccmExternalIpMaps = null)
    {
        $this->ccmExternalIpMaps = $ccmExternalIpMaps;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return RImeClient
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\{........-....-....-....-............\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return RImeClient
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
