<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for REnterpriseFeatureAccessConfiguration StructType
 * @subpackage Structs
 */
class REnterpriseFeatureAccessConfiguration extends AbstractStructBase
{
    /**
     * The pattern
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 16
     * @var string
     */
    public $pattern;
    /**
     * The routePartitionName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $routePartitionName;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The isDefaultEafNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $isDefaultEafNumber;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for REnterpriseFeatureAccessConfiguration
     * @uses REnterpriseFeatureAccessConfiguration::setPattern()
     * @uses REnterpriseFeatureAccessConfiguration::setRoutePartitionName()
     * @uses REnterpriseFeatureAccessConfiguration::setDescription()
     * @uses REnterpriseFeatureAccessConfiguration::setIsDefaultEafNumber()
     * @uses REnterpriseFeatureAccessConfiguration::setUuid()
     * @param string $pattern
     * @param XFkType $routePartitionName
     * @param string $description
     * @param string $isDefaultEafNumber
     * @param string $uuid
     */
    public function __construct($pattern = null, XFkType $routePartitionName = null, $description = null, $isDefaultEafNumber = null, $uuid = null)
    {
        $this
            ->setPattern($pattern)
            ->setRoutePartitionName($routePartitionName)
            ->setDescription($description)
            ->setIsDefaultEafNumber($isDefaultEafNumber)
            ->setUuid($uuid);
    }
    /**
     * Get pattern value
     * @return string|null
     */
    public function getPattern()
    {
        return $this->pattern;
    }
    /**
     * Set pattern value
     * @param string $pattern
     * @return REnterpriseFeatureAccessConfiguration
     */
    public function setPattern($pattern = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($pattern) && strlen($pattern) > 16) || (is_array($pattern) && count($pattern) > 16)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 16 element(s) or a scalar of 16 character(s) at most, "%d" length given', is_scalar($pattern) ? strlen($pattern) : count($pattern)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($pattern) && !is_string($pattern)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pattern)), __LINE__);
        }
        $this->pattern = $pattern;
        return $this;
    }
    /**
     * Get routePartitionName value
     * @return XFkType|null
     */
    public function getRoutePartitionName()
    {
        return $this->routePartitionName;
    }
    /**
     * Set routePartitionName value
     * @param XFkType $routePartitionName
     * @return REnterpriseFeatureAccessConfiguration
     */
    public function setRoutePartitionName(XFkType $routePartitionName = null)
    {
        $this->routePartitionName = $routePartitionName;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return REnterpriseFeatureAccessConfiguration
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get isDefaultEafNumber value
     * @return string|null
     */
    public function getIsDefaultEafNumber()
    {
        return $this->isDefaultEafNumber;
    }
    /**
     * Set isDefaultEafNumber value
     * @param string $isDefaultEafNumber
     * @return REnterpriseFeatureAccessConfiguration
     */
    public function setIsDefaultEafNumber($isDefaultEafNumber = null)
    {
        // validation for constraint: pattern
        if (is_scalar($isDefaultEafNumber) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $isDefaultEafNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($isDefaultEafNumber, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($isDefaultEafNumber) && !is_string($isDefaultEafNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($isDefaultEafNumber)), __LINE__);
        }
        $this->isDefaultEafNumber = $isDefaultEafNumber;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return REnterpriseFeatureAccessConfiguration
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\{........-....-....-....-............\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return REnterpriseFeatureAccessConfiguration
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
