<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RDhcpServer StructType
 * @subpackage Structs
 */
class RDhcpServer extends AbstractStructBase
{
    /**
     * The processNodeName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $processNodeName;
    /**
     * The primaryDnsIpAddress
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $primaryDnsIpAddress;
    /**
     * The secondaryDnsIpAddress
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $secondaryDnsIpAddress;
    /**
     * The primaryTftpServerIpAddress
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $primaryTftpServerIpAddress;
    /**
     * The secondaryTftpServerIpAddress
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $secondaryTftpServerIpAddress;
    /**
     * The bootstrapServerIpAddress
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $bootstrapServerIpAddress;
    /**
     * The domainName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $domainName;
    /**
     * The tftpServerName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $tftpServerName;
    /**
     * The arpCacheTimeout
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $arpCacheTimeout;
    /**
     * The ipAddressLeaseTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ipAddressLeaseTime;
    /**
     * The renewalTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $renewalTime;
    /**
     * The rebindingTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $rebindingTime;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - use: optional
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RDhcpServer
     * @uses RDhcpServer::setProcessNodeName()
     * @uses RDhcpServer::setPrimaryDnsIpAddress()
     * @uses RDhcpServer::setSecondaryDnsIpAddress()
     * @uses RDhcpServer::setPrimaryTftpServerIpAddress()
     * @uses RDhcpServer::setSecondaryTftpServerIpAddress()
     * @uses RDhcpServer::setBootstrapServerIpAddress()
     * @uses RDhcpServer::setDomainName()
     * @uses RDhcpServer::setTftpServerName()
     * @uses RDhcpServer::setArpCacheTimeout()
     * @uses RDhcpServer::setIpAddressLeaseTime()
     * @uses RDhcpServer::setRenewalTime()
     * @uses RDhcpServer::setRebindingTime()
     * @uses RDhcpServer::setUuid()
     * @param XFkType $processNodeName
     * @param string $primaryDnsIpAddress
     * @param string $secondaryDnsIpAddress
     * @param string $primaryTftpServerIpAddress
     * @param string $secondaryTftpServerIpAddress
     * @param string $bootstrapServerIpAddress
     * @param string $domainName
     * @param string $tftpServerName
     * @param string $arpCacheTimeout
     * @param string $ipAddressLeaseTime
     * @param string $renewalTime
     * @param string $rebindingTime
     * @param string $uuid
     */
    public function __construct(XFkType $processNodeName = null, $primaryDnsIpAddress = null, $secondaryDnsIpAddress = null, $primaryTftpServerIpAddress = null, $secondaryTftpServerIpAddress = null, $bootstrapServerIpAddress = null, $domainName = null, $tftpServerName = null, $arpCacheTimeout = null, $ipAddressLeaseTime = null, $renewalTime = null, $rebindingTime = null, $uuid = null)
    {
        $this
            ->setProcessNodeName($processNodeName)
            ->setPrimaryDnsIpAddress($primaryDnsIpAddress)
            ->setSecondaryDnsIpAddress($secondaryDnsIpAddress)
            ->setPrimaryTftpServerIpAddress($primaryTftpServerIpAddress)
            ->setSecondaryTftpServerIpAddress($secondaryTftpServerIpAddress)
            ->setBootstrapServerIpAddress($bootstrapServerIpAddress)
            ->setDomainName($domainName)
            ->setTftpServerName($tftpServerName)
            ->setArpCacheTimeout($arpCacheTimeout)
            ->setIpAddressLeaseTime($ipAddressLeaseTime)
            ->setRenewalTime($renewalTime)
            ->setRebindingTime($rebindingTime)
            ->setUuid($uuid);
    }
    /**
     * Get processNodeName value
     * @return XFkType|null
     */
    public function getProcessNodeName()
    {
        return $this->processNodeName;
    }
    /**
     * Set processNodeName value
     * @param XFkType $processNodeName
     * @return RDhcpServer
     */
    public function setProcessNodeName(XFkType $processNodeName = null)
    {
        $this->processNodeName = $processNodeName;
        return $this;
    }
    /**
     * Get primaryDnsIpAddress value
     * @return string|null
     */
    public function getPrimaryDnsIpAddress()
    {
        return $this->primaryDnsIpAddress;
    }
    /**
     * Set primaryDnsIpAddress value
     * @param string $primaryDnsIpAddress
     * @return RDhcpServer
     */
    public function setPrimaryDnsIpAddress($primaryDnsIpAddress = null)
    {
        // validation for constraint: string
        if (!is_null($primaryDnsIpAddress) && !is_string($primaryDnsIpAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($primaryDnsIpAddress)), __LINE__);
        }
        $this->primaryDnsIpAddress = $primaryDnsIpAddress;
        return $this;
    }
    /**
     * Get secondaryDnsIpAddress value
     * @return string|null
     */
    public function getSecondaryDnsIpAddress()
    {
        return $this->secondaryDnsIpAddress;
    }
    /**
     * Set secondaryDnsIpAddress value
     * @param string $secondaryDnsIpAddress
     * @return RDhcpServer
     */
    public function setSecondaryDnsIpAddress($secondaryDnsIpAddress = null)
    {
        // validation for constraint: string
        if (!is_null($secondaryDnsIpAddress) && !is_string($secondaryDnsIpAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($secondaryDnsIpAddress)), __LINE__);
        }
        $this->secondaryDnsIpAddress = $secondaryDnsIpAddress;
        return $this;
    }
    /**
     * Get primaryTftpServerIpAddress value
     * @return string|null
     */
    public function getPrimaryTftpServerIpAddress()
    {
        return $this->primaryTftpServerIpAddress;
    }
    /**
     * Set primaryTftpServerIpAddress value
     * @param string $primaryTftpServerIpAddress
     * @return RDhcpServer
     */
    public function setPrimaryTftpServerIpAddress($primaryTftpServerIpAddress = null)
    {
        // validation for constraint: string
        if (!is_null($primaryTftpServerIpAddress) && !is_string($primaryTftpServerIpAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($primaryTftpServerIpAddress)), __LINE__);
        }
        $this->primaryTftpServerIpAddress = $primaryTftpServerIpAddress;
        return $this;
    }
    /**
     * Get secondaryTftpServerIpAddress value
     * @return string|null
     */
    public function getSecondaryTftpServerIpAddress()
    {
        return $this->secondaryTftpServerIpAddress;
    }
    /**
     * Set secondaryTftpServerIpAddress value
     * @param string $secondaryTftpServerIpAddress
     * @return RDhcpServer
     */
    public function setSecondaryTftpServerIpAddress($secondaryTftpServerIpAddress = null)
    {
        // validation for constraint: string
        if (!is_null($secondaryTftpServerIpAddress) && !is_string($secondaryTftpServerIpAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($secondaryTftpServerIpAddress)), __LINE__);
        }
        $this->secondaryTftpServerIpAddress = $secondaryTftpServerIpAddress;
        return $this;
    }
    /**
     * Get bootstrapServerIpAddress value
     * @return string|null
     */
    public function getBootstrapServerIpAddress()
    {
        return $this->bootstrapServerIpAddress;
    }
    /**
     * Set bootstrapServerIpAddress value
     * @param string $bootstrapServerIpAddress
     * @return RDhcpServer
     */
    public function setBootstrapServerIpAddress($bootstrapServerIpAddress = null)
    {
        // validation for constraint: string
        if (!is_null($bootstrapServerIpAddress) && !is_string($bootstrapServerIpAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bootstrapServerIpAddress)), __LINE__);
        }
        $this->bootstrapServerIpAddress = $bootstrapServerIpAddress;
        return $this;
    }
    /**
     * Get domainName value
     * @return string|null
     */
    public function getDomainName()
    {
        return $this->domainName;
    }
    /**
     * Set domainName value
     * @param string $domainName
     * @return RDhcpServer
     */
    public function setDomainName($domainName = null)
    {
        // validation for constraint: string
        if (!is_null($domainName) && !is_string($domainName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($domainName)), __LINE__);
        }
        $this->domainName = $domainName;
        return $this;
    }
    /**
     * Get tftpServerName value
     * @return string|null
     */
    public function getTftpServerName()
    {
        return $this->tftpServerName;
    }
    /**
     * Set tftpServerName value
     * @param string $tftpServerName
     * @return RDhcpServer
     */
    public function setTftpServerName($tftpServerName = null)
    {
        // validation for constraint: string
        if (!is_null($tftpServerName) && !is_string($tftpServerName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tftpServerName)), __LINE__);
        }
        $this->tftpServerName = $tftpServerName;
        return $this;
    }
    /**
     * Get arpCacheTimeout value
     * @return string|null
     */
    public function getArpCacheTimeout()
    {
        return $this->arpCacheTimeout;
    }
    /**
     * Set arpCacheTimeout value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $arpCacheTimeout
     * @return RDhcpServer
     */
    public function setArpCacheTimeout($arpCacheTimeout = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($arpCacheTimeout)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $arpCacheTimeout, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->arpCacheTimeout = $arpCacheTimeout;
        return $this;
    }
    /**
     * Get ipAddressLeaseTime value
     * @return string|null
     */
    public function getIpAddressLeaseTime()
    {
        return $this->ipAddressLeaseTime;
    }
    /**
     * Set ipAddressLeaseTime value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $ipAddressLeaseTime
     * @return RDhcpServer
     */
    public function setIpAddressLeaseTime($ipAddressLeaseTime = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($ipAddressLeaseTime)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $ipAddressLeaseTime, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->ipAddressLeaseTime = $ipAddressLeaseTime;
        return $this;
    }
    /**
     * Get renewalTime value
     * @return string|null
     */
    public function getRenewalTime()
    {
        return $this->renewalTime;
    }
    /**
     * Set renewalTime value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $renewalTime
     * @return RDhcpServer
     */
    public function setRenewalTime($renewalTime = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($renewalTime)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $renewalTime, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->renewalTime = $renewalTime;
        return $this;
    }
    /**
     * Get rebindingTime value
     * @return string|null
     */
    public function getRebindingTime()
    {
        return $this->rebindingTime;
    }
    /**
     * Set rebindingTime value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $rebindingTime
     * @return RDhcpServer
     */
    public function setRebindingTime($rebindingTime = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($rebindingTime)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $rebindingTime, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->rebindingTime = $rebindingTime;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return RDhcpServer
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\{........-....-....-....-............\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return RDhcpServer
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
