<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RCallPickupGroup StructType
 * @subpackage Structs
 */
class RCallPickupGroup extends AbstractStructBase
{
    /**
     * The pattern
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $pattern;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The usage
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $usage;
    /**
     * The routePartitionName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $routePartitionName;
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The members
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var Members
     */
    public $members;
    /**
     * The pickupNotification
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $pickupNotification;
    /**
     * The pickupNotificationTimer
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $pickupNotificationTimer;
    /**
     * The callInfoForPickupNotification
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var CallInfoForPickupNotification
     */
    public $callInfoForPickupNotification;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RCallPickupGroup
     * @uses RCallPickupGroup::setPattern()
     * @uses RCallPickupGroup::setDescription()
     * @uses RCallPickupGroup::setUsage()
     * @uses RCallPickupGroup::setRoutePartitionName()
     * @uses RCallPickupGroup::setName()
     * @uses RCallPickupGroup::setMembers()
     * @uses RCallPickupGroup::setPickupNotification()
     * @uses RCallPickupGroup::setPickupNotificationTimer()
     * @uses RCallPickupGroup::setCallInfoForPickupNotification()
     * @uses RCallPickupGroup::setUuid()
     * @param string $pattern
     * @param string $description
     * @param string $usage
     * @param XFkType $routePartitionName
     * @param string $name
     * @param Members $members
     * @param string $pickupNotification
     * @param string $pickupNotificationTimer
     * @param CallInfoForPickupNotification $callInfoForPickupNotification
     * @param string $uuid
     */
    public function __construct($pattern = null, $description = null, $usage = null, XFkType $routePartitionName = null, $name = null, Members $members = null, $pickupNotification = null, $pickupNotificationTimer = null, CallInfoForPickupNotification $callInfoForPickupNotification = null, $uuid = null)
    {
        $this
            ->setPattern($pattern)
            ->setDescription($description)
            ->setUsage($usage)
            ->setRoutePartitionName($routePartitionName)
            ->setName($name)
            ->setMembers($members)
            ->setPickupNotification($pickupNotification)
            ->setPickupNotificationTimer($pickupNotificationTimer)
            ->setCallInfoForPickupNotification($callInfoForPickupNotification)
            ->setUuid($uuid);
    }
    /**
     * Get pattern value
     * @return string|null
     */
    public function getPattern()
    {
        return $this->pattern;
    }
    /**
     * Set pattern value
     * @param string $pattern
     * @return RCallPickupGroup
     */
    public function setPattern($pattern = null)
    {
        // validation for constraint: string
        if (!is_null($pattern) && !is_string($pattern)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pattern)), __LINE__);
        }
        $this->pattern = $pattern;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return RCallPickupGroup
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get usage value
     * @return string|null
     */
    public function getUsage()
    {
        return $this->usage;
    }
    /**
     * Set usage value
     * @uses XPatternUsage::valueIsValid()
     * @uses XPatternUsage::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $usage
     * @return RCallPickupGroup
     */
    public function setUsage($usage = null)
    {
        // validation for constraint: enumeration
        if (!XPatternUsage::valueIsValid($usage)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $usage, implode(', ', XPatternUsage::getValidValues())), __LINE__);
        }
        $this->usage = $usage;
        return $this;
    }
    /**
     * Get routePartitionName value
     * @return XFkType|null
     */
    public function getRoutePartitionName()
    {
        return $this->routePartitionName;
    }
    /**
     * Set routePartitionName value
     * @param XFkType $routePartitionName
     * @return RCallPickupGroup
     */
    public function setRoutePartitionName(XFkType $routePartitionName = null)
    {
        $this->routePartitionName = $routePartitionName;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return RCallPickupGroup
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get members value
     * @return Members|null
     */
    public function getMembers()
    {
        return $this->members;
    }
    /**
     * Set members value
     * @param Members $members
     * @return RCallPickupGroup
     */
    public function setMembers(Members $members = null)
    {
        $this->members = $members;
        return $this;
    }
    /**
     * Get pickupNotification value
     * @return string|null
     */
    public function getPickupNotification()
    {
        return $this->pickupNotification;
    }
    /**
     * Set pickupNotification value
     * @uses XPickupNotification::valueIsValid()
     * @uses XPickupNotification::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $pickupNotification
     * @return RCallPickupGroup
     */
    public function setPickupNotification($pickupNotification = null)
    {
        // validation for constraint: enumeration
        if (!XPickupNotification::valueIsValid($pickupNotification)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $pickupNotification, implode(', ', XPickupNotification::getValidValues())), __LINE__);
        }
        $this->pickupNotification = $pickupNotification;
        return $this;
    }
    /**
     * Get pickupNotificationTimer value
     * @return string|null
     */
    public function getPickupNotificationTimer()
    {
        return $this->pickupNotificationTimer;
    }
    /**
     * Set pickupNotificationTimer value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $pickupNotificationTimer
     * @return RCallPickupGroup
     */
    public function setPickupNotificationTimer($pickupNotificationTimer = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($pickupNotificationTimer)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $pickupNotificationTimer, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->pickupNotificationTimer = $pickupNotificationTimer;
        return $this;
    }
    /**
     * Get callInfoForPickupNotification value
     * @return CallInfoForPickupNotification|null
     */
    public function getCallInfoForPickupNotification()
    {
        return $this->callInfoForPickupNotification;
    }
    /**
     * Set callInfoForPickupNotification value
     * @param CallInfoForPickupNotification $callInfoForPickupNotification
     * @return RCallPickupGroup
     */
    public function setCallInfoForPickupNotification(CallInfoForPickupNotification $callInfoForPickupNotification = null)
    {
        $this->callInfoForPickupNotification = $callInfoForPickupNotification;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return RCallPickupGroup
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\{........-....-....-....-............\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return RCallPickupGroup
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
