<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RCallForwardNoAnswer StructType
 * @subpackage Structs
 */
class RCallForwardNoAnswer extends AbstractStructBase
{
    /**
     * The forwardToVoiceMail
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $forwardToVoiceMail;
    /**
     * The callingSearchSpaceName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $callingSearchSpaceName;
    /**
     * The destination
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 50
     * @var string
     */
    public $destination;
    /**
     * The duration
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $duration;
    /**
     * Constructor method for RCallForwardNoAnswer
     * @uses RCallForwardNoAnswer::setForwardToVoiceMail()
     * @uses RCallForwardNoAnswer::setCallingSearchSpaceName()
     * @uses RCallForwardNoAnswer::setDestination()
     * @uses RCallForwardNoAnswer::setDuration()
     * @param string $forwardToVoiceMail
     * @param XFkType $callingSearchSpaceName
     * @param string $destination
     * @param string $duration
     */
    public function __construct($forwardToVoiceMail = null, XFkType $callingSearchSpaceName = null, $destination = null, $duration = null)
    {
        $this
            ->setForwardToVoiceMail($forwardToVoiceMail)
            ->setCallingSearchSpaceName($callingSearchSpaceName)
            ->setDestination($destination)
            ->setDuration($duration);
    }
    /**
     * Get forwardToVoiceMail value
     * @return string|null
     */
    public function getForwardToVoiceMail()
    {
        return $this->forwardToVoiceMail;
    }
    /**
     * Set forwardToVoiceMail value
     * @param string $forwardToVoiceMail
     * @return RCallForwardNoAnswer
     */
    public function setForwardToVoiceMail($forwardToVoiceMail = null)
    {
        // validation for constraint: pattern
        if (is_scalar($forwardToVoiceMail) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $forwardToVoiceMail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($forwardToVoiceMail, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($forwardToVoiceMail) && !is_string($forwardToVoiceMail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($forwardToVoiceMail)), __LINE__);
        }
        $this->forwardToVoiceMail = $forwardToVoiceMail;
        return $this;
    }
    /**
     * Get callingSearchSpaceName value
     * @return XFkType|null
     */
    public function getCallingSearchSpaceName()
    {
        return $this->callingSearchSpaceName;
    }
    /**
     * Set callingSearchSpaceName value
     * @param XFkType $callingSearchSpaceName
     * @return RCallForwardNoAnswer
     */
    public function setCallingSearchSpaceName(XFkType $callingSearchSpaceName = null)
    {
        $this->callingSearchSpaceName = $callingSearchSpaceName;
        return $this;
    }
    /**
     * Get destination value
     * @return string|null
     */
    public function getDestination()
    {
        return $this->destination;
    }
    /**
     * Set destination value
     * @param string $destination
     * @return RCallForwardNoAnswer
     */
    public function setDestination($destination = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($destination) && strlen($destination) > 50) || (is_array($destination) && count($destination) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($destination) ? strlen($destination) : count($destination)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($destination) && !is_string($destination)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($destination)), __LINE__);
        }
        $this->destination = $destination;
        return $this;
    }
    /**
     * Get duration value
     * @return string|null
     */
    public function getDuration()
    {
        return $this->duration;
    }
    /**
     * Set duration value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $duration
     * @return RCallForwardNoAnswer
     */
    public function setDuration($duration = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($duration)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $duration, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->duration = $duration;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return RCallForwardNoAnswer
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
