<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RBLFDirectedCallPark StructType
 * @subpackage Structs
 */
class RBLFDirectedCallPark extends AbstractStructBase
{
    /**
     * The label
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 50
     * @var string
     */
    public $label;
    /**
     * The directedCallParkId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $directedCallParkId;
    /**
     * The directedCallParkDnAndPartition
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var DirectedCallParkDnAndPartition
     */
    public $directedCallParkDnAndPartition;
    /**
     * The labelAscii
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 50
     * @var string
     */
    public $labelAscii;
    /**
     * The index
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $index;
    /**
     * Constructor method for RBLFDirectedCallPark
     * @uses RBLFDirectedCallPark::setLabel()
     * @uses RBLFDirectedCallPark::setDirectedCallParkId()
     * @uses RBLFDirectedCallPark::setDirectedCallParkDnAndPartition()
     * @uses RBLFDirectedCallPark::setLabelAscii()
     * @uses RBLFDirectedCallPark::setIndex()
     * @param string $label
     * @param string $directedCallParkId
     * @param DirectedCallParkDnAndPartition $directedCallParkDnAndPartition
     * @param string $labelAscii
     * @param string $index
     */
    public function __construct($label = null, $directedCallParkId = null, DirectedCallParkDnAndPartition $directedCallParkDnAndPartition = null, $labelAscii = null, $index = null)
    {
        $this
            ->setLabel($label)
            ->setDirectedCallParkId($directedCallParkId)
            ->setDirectedCallParkDnAndPartition($directedCallParkDnAndPartition)
            ->setLabelAscii($labelAscii)
            ->setIndex($index);
    }
    /**
     * Get label value
     * @return string|null
     */
    public function getLabel()
    {
        return $this->label;
    }
    /**
     * Set label value
     * @param string $label
     * @return RBLFDirectedCallPark
     */
    public function setLabel($label = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($label) && strlen($label) > 50) || (is_array($label) && count($label) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($label) ? strlen($label) : count($label)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($label) && !is_string($label)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($label)), __LINE__);
        }
        $this->label = $label;
        return $this;
    }
    /**
     * Get directedCallParkId value
     * @return string|null
     */
    public function getDirectedCallParkId()
    {
        return $this->directedCallParkId;
    }
    /**
     * Set directedCallParkId value
     * @param string $directedCallParkId
     * @return RBLFDirectedCallPark
     */
    public function setDirectedCallParkId($directedCallParkId = null)
    {
        // validation for constraint: pattern
        if (is_scalar($directedCallParkId) && !preg_match('/\{........-....-....-....-............\}/', $directedCallParkId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($directedCallParkId, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($directedCallParkId) && !is_string($directedCallParkId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($directedCallParkId)), __LINE__);
        }
        $this->directedCallParkId = $directedCallParkId;
        return $this;
    }
    /**
     * Get directedCallParkDnAndPartition value
     * @return DirectedCallParkDnAndPartition|null
     */
    public function getDirectedCallParkDnAndPartition()
    {
        return $this->directedCallParkDnAndPartition;
    }
    /**
     * Set directedCallParkDnAndPartition value
     * @param DirectedCallParkDnAndPartition $directedCallParkDnAndPartition
     * @return RBLFDirectedCallPark
     */
    public function setDirectedCallParkDnAndPartition(DirectedCallParkDnAndPartition $directedCallParkDnAndPartition = null)
    {
        $this->directedCallParkDnAndPartition = $directedCallParkDnAndPartition;
        return $this;
    }
    /**
     * Get labelAscii value
     * @return string|null
     */
    public function getLabelAscii()
    {
        return $this->labelAscii;
    }
    /**
     * Set labelAscii value
     * @param string $labelAscii
     * @return RBLFDirectedCallPark
     */
    public function setLabelAscii($labelAscii = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($labelAscii) && strlen($labelAscii) > 50) || (is_array($labelAscii) && count($labelAscii) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($labelAscii) ? strlen($labelAscii) : count($labelAscii)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($labelAscii) && !is_string($labelAscii)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($labelAscii)), __LINE__);
        }
        $this->labelAscii = $labelAscii;
        return $this;
    }
    /**
     * Get index value
     * @return string|null
     */
    public function getIndex()
    {
        return $this->index;
    }
    /**
     * Set index value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $index
     * @return RBLFDirectedCallPark
     */
    public function setIndex($index = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($index)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $index, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->index = $index;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return RBLFDirectedCallPark
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
