<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RAarGroupMatrix StructType
 * @subpackage Structs
 */
class RAarGroupMatrix extends AbstractStructBase
{
    /**
     * The prefixDigit
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 255
     * @var string
     */
    public $prefixDigit;
    /**
     * The aarGroupFromName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $aarGroupFromName;
    /**
     * The aarGroupToName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $aarGroupToName;
    /**
     * Constructor method for RAarGroupMatrix
     * @uses RAarGroupMatrix::setPrefixDigit()
     * @uses RAarGroupMatrix::setAarGroupFromName()
     * @uses RAarGroupMatrix::setAarGroupToName()
     * @param string $prefixDigit
     * @param XFkType $aarGroupFromName
     * @param XFkType $aarGroupToName
     */
    public function __construct($prefixDigit = null, XFkType $aarGroupFromName = null, XFkType $aarGroupToName = null)
    {
        $this
            ->setPrefixDigit($prefixDigit)
            ->setAarGroupFromName($aarGroupFromName)
            ->setAarGroupToName($aarGroupToName);
    }
    /**
     * Get prefixDigit value
     * @return string|null
     */
    public function getPrefixDigit()
    {
        return $this->prefixDigit;
    }
    /**
     * Set prefixDigit value
     * @param string $prefixDigit
     * @return RAarGroupMatrix
     */
    public function setPrefixDigit($prefixDigit = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($prefixDigit) && strlen($prefixDigit) > 255) || (is_array($prefixDigit) && count($prefixDigit) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($prefixDigit) ? strlen($prefixDigit) : count($prefixDigit)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($prefixDigit) && !is_string($prefixDigit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($prefixDigit)), __LINE__);
        }
        $this->prefixDigit = $prefixDigit;
        return $this;
    }
    /**
     * Get aarGroupFromName value
     * @return XFkType|null
     */
    public function getAarGroupFromName()
    {
        return $this->aarGroupFromName;
    }
    /**
     * Set aarGroupFromName value
     * @param XFkType $aarGroupFromName
     * @return RAarGroupMatrix
     */
    public function setAarGroupFromName(XFkType $aarGroupFromName = null)
    {
        $this->aarGroupFromName = $aarGroupFromName;
        return $this;
    }
    /**
     * Get aarGroupToName value
     * @return XFkType|null
     */
    public function getAarGroupToName()
    {
        return $this->aarGroupToName;
    }
    /**
     * Set aarGroupToName value
     * @param XFkType $aarGroupToName
     * @return RAarGroupMatrix
     */
    public function setAarGroupToName(XFkType $aarGroupToName = null)
    {
        $this->aarGroupToName = $aarGroupToName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return RAarGroupMatrix
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
