<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for phoneLicenseFeature StructType
 * @subpackage Structs
 */
class PhoneLicenseFeature extends AbstractStructBase
{
    /**
     * The unitsAuthorized
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $unitsAuthorized;
    /**
     * The unitsUsed
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $unitsUsed;
    /**
     * The unitsRemaining
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $unitsRemaining;
    /**
     * The unitsPending
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $unitsPending;
    /**
     * The status
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $status;
    /**
     * Constructor method for phoneLicenseFeature
     * @uses PhoneLicenseFeature::setUnitsAuthorized()
     * @uses PhoneLicenseFeature::setUnitsUsed()
     * @uses PhoneLicenseFeature::setUnitsRemaining()
     * @uses PhoneLicenseFeature::setUnitsPending()
     * @uses PhoneLicenseFeature::setStatus()
     * @param int $unitsAuthorized
     * @param int $unitsUsed
     * @param int $unitsRemaining
     * @param int $unitsPending
     * @param string $status
     */
    public function __construct($unitsAuthorized = null, $unitsUsed = null, $unitsRemaining = null, $unitsPending = null, $status = null)
    {
        $this
            ->setUnitsAuthorized($unitsAuthorized)
            ->setUnitsUsed($unitsUsed)
            ->setUnitsRemaining($unitsRemaining)
            ->setUnitsPending($unitsPending)
            ->setStatus($status);
    }
    /**
     * Get unitsAuthorized value
     * @return int|null
     */
    public function getUnitsAuthorized()
    {
        return $this->unitsAuthorized;
    }
    /**
     * Set unitsAuthorized value
     * @param int $unitsAuthorized
     * @return PhoneLicenseFeature
     */
    public function setUnitsAuthorized($unitsAuthorized = null)
    {
        // validation for constraint: int
        if (!is_null($unitsAuthorized) && !is_numeric($unitsAuthorized)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($unitsAuthorized)), __LINE__);
        }
        $this->unitsAuthorized = $unitsAuthorized;
        return $this;
    }
    /**
     * Get unitsUsed value
     * @return int|null
     */
    public function getUnitsUsed()
    {
        return $this->unitsUsed;
    }
    /**
     * Set unitsUsed value
     * @param int $unitsUsed
     * @return PhoneLicenseFeature
     */
    public function setUnitsUsed($unitsUsed = null)
    {
        // validation for constraint: int
        if (!is_null($unitsUsed) && !is_numeric($unitsUsed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($unitsUsed)), __LINE__);
        }
        $this->unitsUsed = $unitsUsed;
        return $this;
    }
    /**
     * Get unitsRemaining value
     * @return int|null
     */
    public function getUnitsRemaining()
    {
        return $this->unitsRemaining;
    }
    /**
     * Set unitsRemaining value
     * @param int $unitsRemaining
     * @return PhoneLicenseFeature
     */
    public function setUnitsRemaining($unitsRemaining = null)
    {
        // validation for constraint: int
        if (!is_null($unitsRemaining) && !is_numeric($unitsRemaining)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($unitsRemaining)), __LINE__);
        }
        $this->unitsRemaining = $unitsRemaining;
        return $this;
    }
    /**
     * Get unitsPending value
     * @return int|null
     */
    public function getUnitsPending()
    {
        return $this->unitsPending;
    }
    /**
     * Set unitsPending value
     * @param int $unitsPending
     * @return PhoneLicenseFeature
     */
    public function setUnitsPending($unitsPending = null)
    {
        // validation for constraint: int
        if (!is_null($unitsPending) && !is_numeric($unitsPending)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($unitsPending)), __LINE__);
        }
        $this->unitsPending = $unitsPending;
        return $this;
    }
    /**
     * Get status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param string $status
     * @return PhoneLicenseFeature
     */
    public function setStatus($status = null)
    {
        // validation for constraint: pattern
        if (is_scalar($status) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($status, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($status)), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return PhoneLicenseFeature
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
