<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LServiceParameter StructType
 * @subpackage Structs
 */
class LServiceParameter extends AbstractStructBase
{
    /**
     * The processNodeName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $processNodeName;
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The service
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $service;
    /**
     * The value
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $value;
    /**
     * The valueType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $valueType;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - use: optional
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LServiceParameter
     * @uses LServiceParameter::setProcessNodeName()
     * @uses LServiceParameter::setName()
     * @uses LServiceParameter::setService()
     * @uses LServiceParameter::setValue()
     * @uses LServiceParameter::setValueType()
     * @uses LServiceParameter::setUuid()
     * @param XFkType $processNodeName
     * @param string $name
     * @param string $service
     * @param string $value
     * @param string $valueType
     * @param string $uuid
     */
    public function __construct(XFkType $processNodeName = null, $name = null, $service = null, $value = null, $valueType = null, $uuid = null)
    {
        $this
            ->setProcessNodeName($processNodeName)
            ->setName($name)
            ->setService($service)
            ->setValue($value)
            ->setValueType($valueType)
            ->setUuid($uuid);
    }
    /**
     * Get processNodeName value
     * @return XFkType|null
     */
    public function getProcessNodeName()
    {
        return $this->processNodeName;
    }
    /**
     * Set processNodeName value
     * @param XFkType $processNodeName
     * @return LServiceParameter
     */
    public function setProcessNodeName(XFkType $processNodeName = null)
    {
        $this->processNodeName = $processNodeName;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return LServiceParameter
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get service value
     * @return string|null
     */
    public function getService()
    {
        return $this->service;
    }
    /**
     * Set service value
     * @uses XService::valueIsValid()
     * @uses XService::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $service
     * @return LServiceParameter
     */
    public function setService($service = null)
    {
        // validation for constraint: enumeration
        if (!XService::valueIsValid($service)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $service, implode(', ', XService::getValidValues())), __LINE__);
        }
        $this->service = $service;
        return $this;
    }
    /**
     * Get value value
     * @return string|null
     */
    public function getValue()
    {
        return $this->value;
    }
    /**
     * Set value value
     * @param string $value
     * @return LServiceParameter
     */
    public function setValue($value = null)
    {
        // validation for constraint: string
        if (!is_null($value) && !is_string($value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($value)), __LINE__);
        }
        $this->value = $value;
        return $this;
    }
    /**
     * Get valueType value
     * @return string|null
     */
    public function getValueType()
    {
        return $this->valueType;
    }
    /**
     * Set valueType value
     * @uses XParam::valueIsValid()
     * @uses XParam::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $valueType
     * @return LServiceParameter
     */
    public function setValueType($valueType = null)
    {
        // validation for constraint: enumeration
        if (!XParam::valueIsValid($valueType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $valueType, implode(', ', XParam::getValidValues())), __LINE__);
        }
        $this->valueType = $valueType;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return LServiceParameter
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\{........-....-....-....-............\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return LServiceParameter
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
