<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LRouteGroup StructType
 * @subpackage Structs
 */
class LRouteGroup extends AbstractStructBase
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The dialPlanWizardGenld
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $dialPlanWizardGenld;
    /**
     * The distributionAlgorithm
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $distributionAlgorithm;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - use: optional
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LRouteGroup
     * @uses LRouteGroup::setName()
     * @uses LRouteGroup::setDialPlanWizardGenld()
     * @uses LRouteGroup::setDistributionAlgorithm()
     * @uses LRouteGroup::setUuid()
     * @param string $name
     * @param string $dialPlanWizardGenld
     * @param string $distributionAlgorithm
     * @param string $uuid
     */
    public function __construct($name = null, $dialPlanWizardGenld = null, $distributionAlgorithm = null, $uuid = null)
    {
        $this
            ->setName($name)
            ->setDialPlanWizardGenld($dialPlanWizardGenld)
            ->setDistributionAlgorithm($distributionAlgorithm)
            ->setUuid($uuid);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return LRouteGroup
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get dialPlanWizardGenld value
     * @return string|null
     */
    public function getDialPlanWizardGenld()
    {
        return $this->dialPlanWizardGenld;
    }
    /**
     * Set dialPlanWizardGenld value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dialPlanWizardGenld
     * @return LRouteGroup
     */
    public function setDialPlanWizardGenld($dialPlanWizardGenld = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($dialPlanWizardGenld)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $dialPlanWizardGenld, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->dialPlanWizardGenld = $dialPlanWizardGenld;
        return $this;
    }
    /**
     * Get distributionAlgorithm value
     * @return string|null
     */
    public function getDistributionAlgorithm()
    {
        return $this->distributionAlgorithm;
    }
    /**
     * Set distributionAlgorithm value
     * @uses XDistributeAlgorithm::valueIsValid()
     * @uses XDistributeAlgorithm::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $distributionAlgorithm
     * @return LRouteGroup
     */
    public function setDistributionAlgorithm($distributionAlgorithm = null)
    {
        // validation for constraint: enumeration
        if (!XDistributeAlgorithm::valueIsValid($distributionAlgorithm)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $distributionAlgorithm, implode(', ', XDistributeAlgorithm::getValidValues())), __LINE__);
        }
        $this->distributionAlgorithm = $distributionAlgorithm;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return LRouteGroup
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\{........-....-....-....-............\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return LRouteGroup
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
