<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LRouteFilter StructType
 * @subpackage Structs
 */
class LRouteFilter extends AbstractStructBase
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The clause
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $clause;
    /**
     * The dialPlanName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $dialPlanName;
    /**
     * The dialPlanWizardGenId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $dialPlanWizardGenId;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - use: optional
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LRouteFilter
     * @uses LRouteFilter::setName()
     * @uses LRouteFilter::setClause()
     * @uses LRouteFilter::setDialPlanName()
     * @uses LRouteFilter::setDialPlanWizardGenId()
     * @uses LRouteFilter::setUuid()
     * @param string $name
     * @param string $clause
     * @param XFkType $dialPlanName
     * @param string $dialPlanWizardGenId
     * @param string $uuid
     */
    public function __construct($name = null, $clause = null, XFkType $dialPlanName = null, $dialPlanWizardGenId = null, $uuid = null)
    {
        $this
            ->setName($name)
            ->setClause($clause)
            ->setDialPlanName($dialPlanName)
            ->setDialPlanWizardGenId($dialPlanWizardGenId)
            ->setUuid($uuid);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return LRouteFilter
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get clause value
     * @return string|null
     */
    public function getClause()
    {
        return $this->clause;
    }
    /**
     * Set clause value
     * @param string $clause
     * @return LRouteFilter
     */
    public function setClause($clause = null)
    {
        // validation for constraint: string
        if (!is_null($clause) && !is_string($clause)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($clause)), __LINE__);
        }
        $this->clause = $clause;
        return $this;
    }
    /**
     * Get dialPlanName value
     * @return XFkType|null
     */
    public function getDialPlanName()
    {
        return $this->dialPlanName;
    }
    /**
     * Set dialPlanName value
     * @param XFkType $dialPlanName
     * @return LRouteFilter
     */
    public function setDialPlanName(XFkType $dialPlanName = null)
    {
        $this->dialPlanName = $dialPlanName;
        return $this;
    }
    /**
     * Get dialPlanWizardGenId value
     * @return string|null
     */
    public function getDialPlanWizardGenId()
    {
        return $this->dialPlanWizardGenId;
    }
    /**
     * Set dialPlanWizardGenId value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dialPlanWizardGenId
     * @return LRouteFilter
     */
    public function setDialPlanWizardGenId($dialPlanWizardGenId = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($dialPlanWizardGenId)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $dialPlanWizardGenId, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->dialPlanWizardGenId = $dialPlanWizardGenId;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return LRouteFilter
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\{........-....-....-....-............\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return LRouteFilter
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
