<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LPhoneSecurityProfile StructType
 * @subpackage Structs
 */
class LPhoneSecurityProfile extends AbstractStructBase
{
    /**
     * The phoneType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $phoneType;
    /**
     * The protocol
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $protocol;
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The deviceSecurityMode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $deviceSecurityMode;
    /**
     * The authenticationMode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $authenticationMode;
    /**
     * The keySize
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $keySize;
    /**
     * The tftpEncryptedConfig
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $tftpEncryptedConfig;
    /**
     * The nonceValidityTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $nonceValidityTime;
    /**
     * The transportType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $transportType;
    /**
     * The sipPhonePort
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sipPhonePort;
    /**
     * The enableDigestAuthentication
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enableDigestAuthentication;
    /**
     * The excludeDigestCredentials
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $excludeDigestCredentials;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LPhoneSecurityProfile
     * @uses LPhoneSecurityProfile::setPhoneType()
     * @uses LPhoneSecurityProfile::setProtocol()
     * @uses LPhoneSecurityProfile::setName()
     * @uses LPhoneSecurityProfile::setDescription()
     * @uses LPhoneSecurityProfile::setDeviceSecurityMode()
     * @uses LPhoneSecurityProfile::setAuthenticationMode()
     * @uses LPhoneSecurityProfile::setKeySize()
     * @uses LPhoneSecurityProfile::setTftpEncryptedConfig()
     * @uses LPhoneSecurityProfile::setNonceValidityTime()
     * @uses LPhoneSecurityProfile::setTransportType()
     * @uses LPhoneSecurityProfile::setSipPhonePort()
     * @uses LPhoneSecurityProfile::setEnableDigestAuthentication()
     * @uses LPhoneSecurityProfile::setExcludeDigestCredentials()
     * @uses LPhoneSecurityProfile::setUuid()
     * @param string $phoneType
     * @param string $protocol
     * @param string $name
     * @param string $description
     * @param string $deviceSecurityMode
     * @param string $authenticationMode
     * @param string $keySize
     * @param string $tftpEncryptedConfig
     * @param string $nonceValidityTime
     * @param string $transportType
     * @param string $sipPhonePort
     * @param string $enableDigestAuthentication
     * @param string $excludeDigestCredentials
     * @param string $uuid
     */
    public function __construct($phoneType = null, $protocol = null, $name = null, $description = null, $deviceSecurityMode = null, $authenticationMode = null, $keySize = null, $tftpEncryptedConfig = null, $nonceValidityTime = null, $transportType = null, $sipPhonePort = null, $enableDigestAuthentication = null, $excludeDigestCredentials = null, $uuid = null)
    {
        $this
            ->setPhoneType($phoneType)
            ->setProtocol($protocol)
            ->setName($name)
            ->setDescription($description)
            ->setDeviceSecurityMode($deviceSecurityMode)
            ->setAuthenticationMode($authenticationMode)
            ->setKeySize($keySize)
            ->setTftpEncryptedConfig($tftpEncryptedConfig)
            ->setNonceValidityTime($nonceValidityTime)
            ->setTransportType($transportType)
            ->setSipPhonePort($sipPhonePort)
            ->setEnableDigestAuthentication($enableDigestAuthentication)
            ->setExcludeDigestCredentials($excludeDigestCredentials)
            ->setUuid($uuid);
    }
    /**
     * Get phoneType value
     * @return string|null
     */
    public function getPhoneType()
    {
        return $this->phoneType;
    }
    /**
     * Set phoneType value
     * @uses XModel::valueIsValid()
     * @uses XModel::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $phoneType
     * @return LPhoneSecurityProfile
     */
    public function setPhoneType($phoneType = null)
    {
        // validation for constraint: enumeration
        if (!XModel::valueIsValid($phoneType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $phoneType, implode(', ', XModel::getValidValues())), __LINE__);
        }
        $this->phoneType = $phoneType;
        return $this;
    }
    /**
     * Get protocol value
     * @return string|null
     */
    public function getProtocol()
    {
        return $this->protocol;
    }
    /**
     * Set protocol value
     * @uses XDeviceProtocol::valueIsValid()
     * @uses XDeviceProtocol::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $protocol
     * @return LPhoneSecurityProfile
     */
    public function setProtocol($protocol = null)
    {
        // validation for constraint: enumeration
        if (!XDeviceProtocol::valueIsValid($protocol)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $protocol, implode(', ', XDeviceProtocol::getValidValues())), __LINE__);
        }
        $this->protocol = $protocol;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return LPhoneSecurityProfile
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return LPhoneSecurityProfile
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get deviceSecurityMode value
     * @return string|null
     */
    public function getDeviceSecurityMode()
    {
        return $this->deviceSecurityMode;
    }
    /**
     * Set deviceSecurityMode value
     * @uses XDeviceSecurityMode::valueIsValid()
     * @uses XDeviceSecurityMode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $deviceSecurityMode
     * @return LPhoneSecurityProfile
     */
    public function setDeviceSecurityMode($deviceSecurityMode = null)
    {
        // validation for constraint: enumeration
        if (!XDeviceSecurityMode::valueIsValid($deviceSecurityMode)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $deviceSecurityMode, implode(', ', XDeviceSecurityMode::getValidValues())), __LINE__);
        }
        $this->deviceSecurityMode = $deviceSecurityMode;
        return $this;
    }
    /**
     * Get authenticationMode value
     * @return string|null
     */
    public function getAuthenticationMode()
    {
        return $this->authenticationMode;
    }
    /**
     * Set authenticationMode value
     * @uses XAuthenticationMode::valueIsValid()
     * @uses XAuthenticationMode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $authenticationMode
     * @return LPhoneSecurityProfile
     */
    public function setAuthenticationMode($authenticationMode = null)
    {
        // validation for constraint: enumeration
        if (!XAuthenticationMode::valueIsValid($authenticationMode)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $authenticationMode, implode(', ', XAuthenticationMode::getValidValues())), __LINE__);
        }
        $this->authenticationMode = $authenticationMode;
        return $this;
    }
    /**
     * Get keySize value
     * @return string|null
     */
    public function getKeySize()
    {
        return $this->keySize;
    }
    /**
     * Set keySize value
     * @uses XKeySize::valueIsValid()
     * @uses XKeySize::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $keySize
     * @return LPhoneSecurityProfile
     */
    public function setKeySize($keySize = null)
    {
        // validation for constraint: enumeration
        if (!XKeySize::valueIsValid($keySize)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $keySize, implode(', ', XKeySize::getValidValues())), __LINE__);
        }
        $this->keySize = $keySize;
        return $this;
    }
    /**
     * Get tftpEncryptedConfig value
     * @return string|null
     */
    public function getTftpEncryptedConfig()
    {
        return $this->tftpEncryptedConfig;
    }
    /**
     * Set tftpEncryptedConfig value
     * @param string $tftpEncryptedConfig
     * @return LPhoneSecurityProfile
     */
    public function setTftpEncryptedConfig($tftpEncryptedConfig = null)
    {
        // validation for constraint: pattern
        if (is_scalar($tftpEncryptedConfig) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $tftpEncryptedConfig)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($tftpEncryptedConfig, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($tftpEncryptedConfig) && !is_string($tftpEncryptedConfig)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tftpEncryptedConfig)), __LINE__);
        }
        $this->tftpEncryptedConfig = $tftpEncryptedConfig;
        return $this;
    }
    /**
     * Get nonceValidityTime value
     * @return string|null
     */
    public function getNonceValidityTime()
    {
        return $this->nonceValidityTime;
    }
    /**
     * Set nonceValidityTime value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $nonceValidityTime
     * @return LPhoneSecurityProfile
     */
    public function setNonceValidityTime($nonceValidityTime = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($nonceValidityTime)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $nonceValidityTime, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->nonceValidityTime = $nonceValidityTime;
        return $this;
    }
    /**
     * Get transportType value
     * @return string|null
     */
    public function getTransportType()
    {
        return $this->transportType;
    }
    /**
     * Set transportType value
     * @uses XTransport::valueIsValid()
     * @uses XTransport::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $transportType
     * @return LPhoneSecurityProfile
     */
    public function setTransportType($transportType = null)
    {
        // validation for constraint: enumeration
        if (!XTransport::valueIsValid($transportType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $transportType, implode(', ', XTransport::getValidValues())), __LINE__);
        }
        $this->transportType = $transportType;
        return $this;
    }
    /**
     * Get sipPhonePort value
     * @return string|null
     */
    public function getSipPhonePort()
    {
        return $this->sipPhonePort;
    }
    /**
     * Set sipPhonePort value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sipPhonePort
     * @return LPhoneSecurityProfile
     */
    public function setSipPhonePort($sipPhonePort = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($sipPhonePort)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $sipPhonePort, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->sipPhonePort = $sipPhonePort;
        return $this;
    }
    /**
     * Get enableDigestAuthentication value
     * @return string|null
     */
    public function getEnableDigestAuthentication()
    {
        return $this->enableDigestAuthentication;
    }
    /**
     * Set enableDigestAuthentication value
     * @param string $enableDigestAuthentication
     * @return LPhoneSecurityProfile
     */
    public function setEnableDigestAuthentication($enableDigestAuthentication = null)
    {
        // validation for constraint: pattern
        if (is_scalar($enableDigestAuthentication) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $enableDigestAuthentication)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($enableDigestAuthentication, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($enableDigestAuthentication) && !is_string($enableDigestAuthentication)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($enableDigestAuthentication)), __LINE__);
        }
        $this->enableDigestAuthentication = $enableDigestAuthentication;
        return $this;
    }
    /**
     * Get excludeDigestCredentials value
     * @return string|null
     */
    public function getExcludeDigestCredentials()
    {
        return $this->excludeDigestCredentials;
    }
    /**
     * Set excludeDigestCredentials value
     * @param string $excludeDigestCredentials
     * @return LPhoneSecurityProfile
     */
    public function setExcludeDigestCredentials($excludeDigestCredentials = null)
    {
        // validation for constraint: pattern
        if (is_scalar($excludeDigestCredentials) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $excludeDigestCredentials)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($excludeDigestCredentials, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($excludeDigestCredentials) && !is_string($excludeDigestCredentials)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($excludeDigestCredentials)), __LINE__);
        }
        $this->excludeDigestCredentials = $excludeDigestCredentials;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return LPhoneSecurityProfile
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\{........-....-....-....-............\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return LPhoneSecurityProfile
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
