<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LPhoneLine StructType
 * @subpackage Structs
 */
class LPhoneLine extends AbstractStructBase
{
    /**
     * The index
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $index;
    /**
     * The label
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 50
     * @var string
     */
    public $label;
    /**
     * The asciiLabel
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 50
     * @var string
     */
    public $asciiLabel;
    /**
     * The display
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 50
     * @var string
     */
    public $display;
    /**
     * The dirn
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var LDirn
     */
    public $dirn;
    /**
     * The ringSetting
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ringSetting;
    /**
     * The consecutiveRingSetting
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $consecutiveRingSetting;
    /**
     * The ringSettingIdlePickupAlert
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ringSettingIdlePickupAlert;
    /**
     * The ringSettingActivePickupAlert
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ringSettingActivePickupAlert;
    /**
     * The displayAscii
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 50
     * @var string
     */
    public $displayAscii;
    /**
     * The e164Mask
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 255
     * @var string
     */
    public $e164Mask;
    /**
     * The dialPlanWizardId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $dialPlanWizardId;
    /**
     * The mwlPolicy
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $mwlPolicy;
    /**
     * The maxNumCalls
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $maxNumCalls;
    /**
     * The busyTrigger
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $busyTrigger;
    /**
     * The callInfoDisplay
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var CallInfoDisplay
     */
    public $callInfoDisplay;
    /**
     * The recordingProfileName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $recordingProfileName;
    /**
     * The monitoringCssName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $monitoringCssName;
    /**
     * The recordingFlag
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $recordingFlag;
    /**
     * The audibleMwi
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $audibleMwi;
    /**
     * The speedDial
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $speedDial;
    /**
     * The partitionUsage
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $partitionUsage;
    /**
     * The missedCallLogging
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $missedCallLogging;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * The ctiid
     * @var int
     */
    public $ctiid;
    /**
     * Constructor method for LPhoneLine
     * @uses LPhoneLine::setIndex()
     * @uses LPhoneLine::setLabel()
     * @uses LPhoneLine::setAsciiLabel()
     * @uses LPhoneLine::setDisplay()
     * @uses LPhoneLine::setDirn()
     * @uses LPhoneLine::setRingSetting()
     * @uses LPhoneLine::setConsecutiveRingSetting()
     * @uses LPhoneLine::setRingSettingIdlePickupAlert()
     * @uses LPhoneLine::setRingSettingActivePickupAlert()
     * @uses LPhoneLine::setDisplayAscii()
     * @uses LPhoneLine::setE164Mask()
     * @uses LPhoneLine::setDialPlanWizardId()
     * @uses LPhoneLine::setMwlPolicy()
     * @uses LPhoneLine::setMaxNumCalls()
     * @uses LPhoneLine::setBusyTrigger()
     * @uses LPhoneLine::setCallInfoDisplay()
     * @uses LPhoneLine::setRecordingProfileName()
     * @uses LPhoneLine::setMonitoringCssName()
     * @uses LPhoneLine::setRecordingFlag()
     * @uses LPhoneLine::setAudibleMwi()
     * @uses LPhoneLine::setSpeedDial()
     * @uses LPhoneLine::setPartitionUsage()
     * @uses LPhoneLine::setMissedCallLogging()
     * @uses LPhoneLine::setUuid()
     * @uses LPhoneLine::setCtiid()
     * @param string $index
     * @param string $label
     * @param string $asciiLabel
     * @param string $display
     * @param LDirn $dirn
     * @param string $ringSetting
     * @param string $consecutiveRingSetting
     * @param string $ringSettingIdlePickupAlert
     * @param string $ringSettingActivePickupAlert
     * @param string $displayAscii
     * @param string $e164Mask
     * @param string $dialPlanWizardId
     * @param string $mwlPolicy
     * @param string $maxNumCalls
     * @param string $busyTrigger
     * @param CallInfoDisplay $callInfoDisplay
     * @param XFkType $recordingProfileName
     * @param XFkType $monitoringCssName
     * @param string $recordingFlag
     * @param string $audibleMwi
     * @param string $speedDial
     * @param string $partitionUsage
     * @param string $missedCallLogging
     * @param string $uuid
     * @param int $ctiid
     */
    public function __construct($index = null, $label = null, $asciiLabel = null, $display = null, LDirn $dirn = null, $ringSetting = null, $consecutiveRingSetting = null, $ringSettingIdlePickupAlert = null, $ringSettingActivePickupAlert = null, $displayAscii = null, $e164Mask = null, $dialPlanWizardId = null, $mwlPolicy = null, $maxNumCalls = null, $busyTrigger = null, CallInfoDisplay $callInfoDisplay = null, XFkType $recordingProfileName = null, XFkType $monitoringCssName = null, $recordingFlag = null, $audibleMwi = null, $speedDial = null, $partitionUsage = null, $missedCallLogging = null, $uuid = null, $ctiid = null)
    {
        $this
            ->setIndex($index)
            ->setLabel($label)
            ->setAsciiLabel($asciiLabel)
            ->setDisplay($display)
            ->setDirn($dirn)
            ->setRingSetting($ringSetting)
            ->setConsecutiveRingSetting($consecutiveRingSetting)
            ->setRingSettingIdlePickupAlert($ringSettingIdlePickupAlert)
            ->setRingSettingActivePickupAlert($ringSettingActivePickupAlert)
            ->setDisplayAscii($displayAscii)
            ->setE164Mask($e164Mask)
            ->setDialPlanWizardId($dialPlanWizardId)
            ->setMwlPolicy($mwlPolicy)
            ->setMaxNumCalls($maxNumCalls)
            ->setBusyTrigger($busyTrigger)
            ->setCallInfoDisplay($callInfoDisplay)
            ->setRecordingProfileName($recordingProfileName)
            ->setMonitoringCssName($monitoringCssName)
            ->setRecordingFlag($recordingFlag)
            ->setAudibleMwi($audibleMwi)
            ->setSpeedDial($speedDial)
            ->setPartitionUsage($partitionUsage)
            ->setMissedCallLogging($missedCallLogging)
            ->setUuid($uuid)
            ->setCtiid($ctiid);
    }
    /**
     * Get index value
     * @return string|null
     */
    public function getIndex()
    {
        return $this->index;
    }
    /**
     * Set index value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $index
     * @return LPhoneLine
     */
    public function setIndex($index = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($index)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $index, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->index = $index;
        return $this;
    }
    /**
     * Get label value
     * @return string|null
     */
    public function getLabel()
    {
        return $this->label;
    }
    /**
     * Set label value
     * @param string $label
     * @return LPhoneLine
     */
    public function setLabel($label = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($label) && strlen($label) > 50) || (is_array($label) && count($label) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($label) ? strlen($label) : count($label)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($label) && !is_string($label)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($label)), __LINE__);
        }
        $this->label = $label;
        return $this;
    }
    /**
     * Get asciiLabel value
     * @return string|null
     */
    public function getAsciiLabel()
    {
        return $this->asciiLabel;
    }
    /**
     * Set asciiLabel value
     * @param string $asciiLabel
     * @return LPhoneLine
     */
    public function setAsciiLabel($asciiLabel = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($asciiLabel) && strlen($asciiLabel) > 50) || (is_array($asciiLabel) && count($asciiLabel) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($asciiLabel) ? strlen($asciiLabel) : count($asciiLabel)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($asciiLabel) && !is_string($asciiLabel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($asciiLabel)), __LINE__);
        }
        $this->asciiLabel = $asciiLabel;
        return $this;
    }
    /**
     * Get display value
     * @return string|null
     */
    public function getDisplay()
    {
        return $this->display;
    }
    /**
     * Set display value
     * @param string $display
     * @return LPhoneLine
     */
    public function setDisplay($display = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($display) && strlen($display) > 50) || (is_array($display) && count($display) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($display) ? strlen($display) : count($display)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($display) && !is_string($display)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($display)), __LINE__);
        }
        $this->display = $display;
        return $this;
    }
    /**
     * Get dirn value
     * @return LDirn|null
     */
    public function getDirn()
    {
        return $this->dirn;
    }
    /**
     * Set dirn value
     * @param LDirn $dirn
     * @return LPhoneLine
     */
    public function setDirn(LDirn $dirn = null)
    {
        $this->dirn = $dirn;
        return $this;
    }
    /**
     * Get ringSetting value
     * @return string|null
     */
    public function getRingSetting()
    {
        return $this->ringSetting;
    }
    /**
     * Set ringSetting value
     * @uses XRingSetting::valueIsValid()
     * @uses XRingSetting::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $ringSetting
     * @return LPhoneLine
     */
    public function setRingSetting($ringSetting = null)
    {
        // validation for constraint: enumeration
        if (!XRingSetting::valueIsValid($ringSetting)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $ringSetting, implode(', ', XRingSetting::getValidValues())), __LINE__);
        }
        $this->ringSetting = $ringSetting;
        return $this;
    }
    /**
     * Get consecutiveRingSetting value
     * @return string|null
     */
    public function getConsecutiveRingSetting()
    {
        return $this->consecutiveRingSetting;
    }
    /**
     * Set consecutiveRingSetting value
     * @uses XRingSetting::valueIsValid()
     * @uses XRingSetting::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $consecutiveRingSetting
     * @return LPhoneLine
     */
    public function setConsecutiveRingSetting($consecutiveRingSetting = null)
    {
        // validation for constraint: enumeration
        if (!XRingSetting::valueIsValid($consecutiveRingSetting)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $consecutiveRingSetting, implode(', ', XRingSetting::getValidValues())), __LINE__);
        }
        $this->consecutiveRingSetting = $consecutiveRingSetting;
        return $this;
    }
    /**
     * Get ringSettingIdlePickupAlert value
     * @return string|null
     */
    public function getRingSettingIdlePickupAlert()
    {
        return $this->ringSettingIdlePickupAlert;
    }
    /**
     * Set ringSettingIdlePickupAlert value
     * @uses XRingSetting::valueIsValid()
     * @uses XRingSetting::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $ringSettingIdlePickupAlert
     * @return LPhoneLine
     */
    public function setRingSettingIdlePickupAlert($ringSettingIdlePickupAlert = null)
    {
        // validation for constraint: enumeration
        if (!XRingSetting::valueIsValid($ringSettingIdlePickupAlert)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $ringSettingIdlePickupAlert, implode(', ', XRingSetting::getValidValues())), __LINE__);
        }
        $this->ringSettingIdlePickupAlert = $ringSettingIdlePickupAlert;
        return $this;
    }
    /**
     * Get ringSettingActivePickupAlert value
     * @return string|null
     */
    public function getRingSettingActivePickupAlert()
    {
        return $this->ringSettingActivePickupAlert;
    }
    /**
     * Set ringSettingActivePickupAlert value
     * @uses XRingSetting::valueIsValid()
     * @uses XRingSetting::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $ringSettingActivePickupAlert
     * @return LPhoneLine
     */
    public function setRingSettingActivePickupAlert($ringSettingActivePickupAlert = null)
    {
        // validation for constraint: enumeration
        if (!XRingSetting::valueIsValid($ringSettingActivePickupAlert)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $ringSettingActivePickupAlert, implode(', ', XRingSetting::getValidValues())), __LINE__);
        }
        $this->ringSettingActivePickupAlert = $ringSettingActivePickupAlert;
        return $this;
    }
    /**
     * Get displayAscii value
     * @return string|null
     */
    public function getDisplayAscii()
    {
        return $this->displayAscii;
    }
    /**
     * Set displayAscii value
     * @param string $displayAscii
     * @return LPhoneLine
     */
    public function setDisplayAscii($displayAscii = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($displayAscii) && strlen($displayAscii) > 50) || (is_array($displayAscii) && count($displayAscii) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($displayAscii) ? strlen($displayAscii) : count($displayAscii)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($displayAscii) && !is_string($displayAscii)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($displayAscii)), __LINE__);
        }
        $this->displayAscii = $displayAscii;
        return $this;
    }
    /**
     * Get e164Mask value
     * @return string|null
     */
    public function getE164Mask()
    {
        return $this->e164Mask;
    }
    /**
     * Set e164Mask value
     * @param string $e164Mask
     * @return LPhoneLine
     */
    public function setE164Mask($e164Mask = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($e164Mask) && strlen($e164Mask) > 255) || (is_array($e164Mask) && count($e164Mask) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($e164Mask) ? strlen($e164Mask) : count($e164Mask)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($e164Mask) && !is_string($e164Mask)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($e164Mask)), __LINE__);
        }
        $this->e164Mask = $e164Mask;
        return $this;
    }
    /**
     * Get dialPlanWizardId value
     * @return string|null
     */
    public function getDialPlanWizardId()
    {
        return $this->dialPlanWizardId;
    }
    /**
     * Set dialPlanWizardId value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dialPlanWizardId
     * @return LPhoneLine
     */
    public function setDialPlanWizardId($dialPlanWizardId = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($dialPlanWizardId)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $dialPlanWizardId, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->dialPlanWizardId = $dialPlanWizardId;
        return $this;
    }
    /**
     * Get mwlPolicy value
     * @return string|null
     */
    public function getMwlPolicy()
    {
        return $this->mwlPolicy;
    }
    /**
     * Set mwlPolicy value
     * @uses XMWLPolicy::valueIsValid()
     * @uses XMWLPolicy::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $mwlPolicy
     * @return LPhoneLine
     */
    public function setMwlPolicy($mwlPolicy = null)
    {
        // validation for constraint: enumeration
        if (!XMWLPolicy::valueIsValid($mwlPolicy)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $mwlPolicy, implode(', ', XMWLPolicy::getValidValues())), __LINE__);
        }
        $this->mwlPolicy = $mwlPolicy;
        return $this;
    }
    /**
     * Get maxNumCalls value
     * @return string|null
     */
    public function getMaxNumCalls()
    {
        return $this->maxNumCalls;
    }
    /**
     * Set maxNumCalls value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $maxNumCalls
     * @return LPhoneLine
     */
    public function setMaxNumCalls($maxNumCalls = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($maxNumCalls)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $maxNumCalls, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->maxNumCalls = $maxNumCalls;
        return $this;
    }
    /**
     * Get busyTrigger value
     * @return string|null
     */
    public function getBusyTrigger()
    {
        return $this->busyTrigger;
    }
    /**
     * Set busyTrigger value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $busyTrigger
     * @return LPhoneLine
     */
    public function setBusyTrigger($busyTrigger = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($busyTrigger)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $busyTrigger, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->busyTrigger = $busyTrigger;
        return $this;
    }
    /**
     * Get callInfoDisplay value
     * @return CallInfoDisplay|null
     */
    public function getCallInfoDisplay()
    {
        return $this->callInfoDisplay;
    }
    /**
     * Set callInfoDisplay value
     * @param CallInfoDisplay $callInfoDisplay
     * @return LPhoneLine
     */
    public function setCallInfoDisplay(CallInfoDisplay $callInfoDisplay = null)
    {
        $this->callInfoDisplay = $callInfoDisplay;
        return $this;
    }
    /**
     * Get recordingProfileName value
     * @return XFkType|null
     */
    public function getRecordingProfileName()
    {
        return $this->recordingProfileName;
    }
    /**
     * Set recordingProfileName value
     * @param XFkType $recordingProfileName
     * @return LPhoneLine
     */
    public function setRecordingProfileName(XFkType $recordingProfileName = null)
    {
        $this->recordingProfileName = $recordingProfileName;
        return $this;
    }
    /**
     * Get monitoringCssName value
     * @return XFkType|null
     */
    public function getMonitoringCssName()
    {
        return $this->monitoringCssName;
    }
    /**
     * Set monitoringCssName value
     * @param XFkType $monitoringCssName
     * @return LPhoneLine
     */
    public function setMonitoringCssName(XFkType $monitoringCssName = null)
    {
        $this->monitoringCssName = $monitoringCssName;
        return $this;
    }
    /**
     * Get recordingFlag value
     * @return string|null
     */
    public function getRecordingFlag()
    {
        return $this->recordingFlag;
    }
    /**
     * Set recordingFlag value
     * @uses XRecordingFlag::valueIsValid()
     * @uses XRecordingFlag::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $recordingFlag
     * @return LPhoneLine
     */
    public function setRecordingFlag($recordingFlag = null)
    {
        // validation for constraint: enumeration
        if (!XRecordingFlag::valueIsValid($recordingFlag)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $recordingFlag, implode(', ', XRecordingFlag::getValidValues())), __LINE__);
        }
        $this->recordingFlag = $recordingFlag;
        return $this;
    }
    /**
     * Get audibleMwi value
     * @return string|null
     */
    public function getAudibleMwi()
    {
        return $this->audibleMwi;
    }
    /**
     * Set audibleMwi value
     * @uses XStatus::valueIsValid()
     * @uses XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $audibleMwi
     * @return LPhoneLine
     */
    public function setAudibleMwi($audibleMwi = null)
    {
        // validation for constraint: enumeration
        if (!XStatus::valueIsValid($audibleMwi)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $audibleMwi, implode(', ', XStatus::getValidValues())), __LINE__);
        }
        $this->audibleMwi = $audibleMwi;
        return $this;
    }
    /**
     * Get speedDial value
     * @return string|null
     */
    public function getSpeedDial()
    {
        return $this->speedDial;
    }
    /**
     * Set speedDial value
     * @param string $speedDial
     * @return LPhoneLine
     */
    public function setSpeedDial($speedDial = null)
    {
        // validation for constraint: string
        if (!is_null($speedDial) && !is_string($speedDial)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($speedDial)), __LINE__);
        }
        $this->speedDial = $speedDial;
        return $this;
    }
    /**
     * Get partitionUsage value
     * @return string|null
     */
    public function getPartitionUsage()
    {
        return $this->partitionUsage;
    }
    /**
     * Set partitionUsage value
     * @uses XPartitionUsage::valueIsValid()
     * @uses XPartitionUsage::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $partitionUsage
     * @return LPhoneLine
     */
    public function setPartitionUsage($partitionUsage = null)
    {
        // validation for constraint: enumeration
        if (!XPartitionUsage::valueIsValid($partitionUsage)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $partitionUsage, implode(', ', XPartitionUsage::getValidValues())), __LINE__);
        }
        $this->partitionUsage = $partitionUsage;
        return $this;
    }
    /**
     * Get missedCallLogging value
     * @return string|null
     */
    public function getMissedCallLogging()
    {
        return $this->missedCallLogging;
    }
    /**
     * Set missedCallLogging value
     * @param string $missedCallLogging
     * @return LPhoneLine
     */
    public function setMissedCallLogging($missedCallLogging = null)
    {
        // validation for constraint: pattern
        if (is_scalar($missedCallLogging) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $missedCallLogging)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($missedCallLogging, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($missedCallLogging) && !is_string($missedCallLogging)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($missedCallLogging)), __LINE__);
        }
        $this->missedCallLogging = $missedCallLogging;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return LPhoneLine
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\{........-....-....-....-............\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Get ctiid value
     * @return int|null
     */
    public function getCtiid()
    {
        return $this->ctiid;
    }
    /**
     * Set ctiid value
     * @param int $ctiid
     * @return LPhoneLine
     */
    public function setCtiid($ctiid = null)
    {
        // validation for constraint: int
        if (!is_null($ctiid) && !is_numeric($ctiid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($ctiid)), __LINE__);
        }
        $this->ctiid = $ctiid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return LPhoneLine
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
