<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LH323TrunkDestination StructType
 * @subpackage Structs
 */
class LH323TrunkDestination extends AbstractStructBase
{
    /**
     * The addressIpv4
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 255
     * @var string
     */
    public $addressIpv4;
    /**
     * The sortOrder
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sortOrder;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LH323TrunkDestination
     * @uses LH323TrunkDestination::setAddressIpv4()
     * @uses LH323TrunkDestination::setSortOrder()
     * @uses LH323TrunkDestination::setUuid()
     * @param string $addressIpv4
     * @param string $sortOrder
     * @param string $uuid
     */
    public function __construct($addressIpv4 = null, $sortOrder = null, $uuid = null)
    {
        $this
            ->setAddressIpv4($addressIpv4)
            ->setSortOrder($sortOrder)
            ->setUuid($uuid);
    }
    /**
     * Get addressIpv4 value
     * @return string|null
     */
    public function getAddressIpv4()
    {
        return $this->addressIpv4;
    }
    /**
     * Set addressIpv4 value
     * @param string $addressIpv4
     * @return LH323TrunkDestination
     */
    public function setAddressIpv4($addressIpv4 = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($addressIpv4) && strlen($addressIpv4) > 255) || (is_array($addressIpv4) && count($addressIpv4) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($addressIpv4) ? strlen($addressIpv4) : count($addressIpv4)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($addressIpv4) && !is_string($addressIpv4)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($addressIpv4)), __LINE__);
        }
        $this->addressIpv4 = $addressIpv4;
        return $this;
    }
    /**
     * Get sortOrder value
     * @return string|null
     */
    public function getSortOrder()
    {
        return $this->sortOrder;
    }
    /**
     * Set sortOrder value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sortOrder
     * @return LH323TrunkDestination
     */
    public function setSortOrder($sortOrder = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($sortOrder)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $sortOrder, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->sortOrder = $sortOrder;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return LH323TrunkDestination
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\{........-....-....-....-............\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return LH323TrunkDestination
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
