<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LEndUserCapfProfile StructType
 * @subpackage Structs
 */
class LEndUserCapfProfile extends AbstractStructBase
{
    /**
     * The endUserId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $endUserId;
    /**
     * The instanceId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $instanceId;
    /**
     * The certificationOperation
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $certificationOperation;
    /**
     * The authenticationMode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $authenticationMode;
    /**
     * The authenticationString
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $authenticationString;
    /**
     * The keySize
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $keySize;
    /**
     * The operationCompletion
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $operationCompletion;
    /**
     * The certificationOperationStatus
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $certificationOperationStatus;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - use: optional
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LEndUserCapfProfile
     * @uses LEndUserCapfProfile::setEndUserId()
     * @uses LEndUserCapfProfile::setInstanceId()
     * @uses LEndUserCapfProfile::setCertificationOperation()
     * @uses LEndUserCapfProfile::setAuthenticationMode()
     * @uses LEndUserCapfProfile::setAuthenticationString()
     * @uses LEndUserCapfProfile::setKeySize()
     * @uses LEndUserCapfProfile::setOperationCompletion()
     * @uses LEndUserCapfProfile::setCertificationOperationStatus()
     * @uses LEndUserCapfProfile::setUuid()
     * @param XFkType $endUserId
     * @param string $instanceId
     * @param string $certificationOperation
     * @param string $authenticationMode
     * @param string $authenticationString
     * @param string $keySize
     * @param string $operationCompletion
     * @param string $certificationOperationStatus
     * @param string $uuid
     */
    public function __construct(XFkType $endUserId = null, $instanceId = null, $certificationOperation = null, $authenticationMode = null, $authenticationString = null, $keySize = null, $operationCompletion = null, $certificationOperationStatus = null, $uuid = null)
    {
        $this
            ->setEndUserId($endUserId)
            ->setInstanceId($instanceId)
            ->setCertificationOperation($certificationOperation)
            ->setAuthenticationMode($authenticationMode)
            ->setAuthenticationString($authenticationString)
            ->setKeySize($keySize)
            ->setOperationCompletion($operationCompletion)
            ->setCertificationOperationStatus($certificationOperationStatus)
            ->setUuid($uuid);
    }
    /**
     * Get endUserId value
     * @return XFkType|null
     */
    public function getEndUserId()
    {
        return $this->endUserId;
    }
    /**
     * Set endUserId value
     * @param XFkType $endUserId
     * @return LEndUserCapfProfile
     */
    public function setEndUserId(XFkType $endUserId = null)
    {
        $this->endUserId = $endUserId;
        return $this;
    }
    /**
     * Get instanceId value
     * @return string|null
     */
    public function getInstanceId()
    {
        return $this->instanceId;
    }
    /**
     * Set instanceId value
     * @param string $instanceId
     * @return LEndUserCapfProfile
     */
    public function setInstanceId($instanceId = null)
    {
        // validation for constraint: string
        if (!is_null($instanceId) && !is_string($instanceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($instanceId)), __LINE__);
        }
        $this->instanceId = $instanceId;
        return $this;
    }
    /**
     * Get certificationOperation value
     * @return string|null
     */
    public function getCertificationOperation()
    {
        return $this->certificationOperation;
    }
    /**
     * Set certificationOperation value
     * @uses XCertificateOperation::valueIsValid()
     * @uses XCertificateOperation::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $certificationOperation
     * @return LEndUserCapfProfile
     */
    public function setCertificationOperation($certificationOperation = null)
    {
        // validation for constraint: enumeration
        if (!XCertificateOperation::valueIsValid($certificationOperation)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $certificationOperation, implode(', ', XCertificateOperation::getValidValues())), __LINE__);
        }
        $this->certificationOperation = $certificationOperation;
        return $this;
    }
    /**
     * Get authenticationMode value
     * @return string|null
     */
    public function getAuthenticationMode()
    {
        return $this->authenticationMode;
    }
    /**
     * Set authenticationMode value
     * @uses XAuthenticationMode::valueIsValid()
     * @uses XAuthenticationMode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $authenticationMode
     * @return LEndUserCapfProfile
     */
    public function setAuthenticationMode($authenticationMode = null)
    {
        // validation for constraint: enumeration
        if (!XAuthenticationMode::valueIsValid($authenticationMode)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $authenticationMode, implode(', ', XAuthenticationMode::getValidValues())), __LINE__);
        }
        $this->authenticationMode = $authenticationMode;
        return $this;
    }
    /**
     * Get authenticationString value
     * @return string|null
     */
    public function getAuthenticationString()
    {
        return $this->authenticationString;
    }
    /**
     * Set authenticationString value
     * @param string $authenticationString
     * @return LEndUserCapfProfile
     */
    public function setAuthenticationString($authenticationString = null)
    {
        // validation for constraint: string
        if (!is_null($authenticationString) && !is_string($authenticationString)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($authenticationString)), __LINE__);
        }
        $this->authenticationString = $authenticationString;
        return $this;
    }
    /**
     * Get keySize value
     * @return string|null
     */
    public function getKeySize()
    {
        return $this->keySize;
    }
    /**
     * Set keySize value
     * @uses XKeySize::valueIsValid()
     * @uses XKeySize::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $keySize
     * @return LEndUserCapfProfile
     */
    public function setKeySize($keySize = null)
    {
        // validation for constraint: enumeration
        if (!XKeySize::valueIsValid($keySize)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $keySize, implode(', ', XKeySize::getValidValues())), __LINE__);
        }
        $this->keySize = $keySize;
        return $this;
    }
    /**
     * Get operationCompletion value
     * @return string|null
     */
    public function getOperationCompletion()
    {
        return $this->operationCompletion;
    }
    /**
     * Set operationCompletion value
     * @param string $operationCompletion
     * @return LEndUserCapfProfile
     */
    public function setOperationCompletion($operationCompletion = null)
    {
        // validation for constraint: string
        if (!is_null($operationCompletion) && !is_string($operationCompletion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($operationCompletion)), __LINE__);
        }
        $this->operationCompletion = $operationCompletion;
        return $this;
    }
    /**
     * Get certificationOperationStatus value
     * @return string|null
     */
    public function getCertificationOperationStatus()
    {
        return $this->certificationOperationStatus;
    }
    /**
     * Set certificationOperationStatus value
     * @uses XCertificateStatus::valueIsValid()
     * @uses XCertificateStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $certificationOperationStatus
     * @return LEndUserCapfProfile
     */
    public function setCertificationOperationStatus($certificationOperationStatus = null)
    {
        // validation for constraint: enumeration
        if (!XCertificateStatus::valueIsValid($certificationOperationStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $certificationOperationStatus, implode(', ', XCertificateStatus::getValidValues())), __LINE__);
        }
        $this->certificationOperationStatus = $certificationOperationStatus;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return LEndUserCapfProfile
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\{........-....-....-....-............\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return LEndUserCapfProfile
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
