<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LDirectedCallPark StructType
 * @subpackage Structs
 */
class LDirectedCallPark extends AbstractStructBase
{
    /**
     * The pattern
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $pattern;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The usage
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $usage;
    /**
     * The routePartitionName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $routePartitionName;
    /**
     * The retrievalPrefix
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $retrievalPrefix;
    /**
     * The reversionPattern
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $reversionPattern;
    /**
     * The revertCssName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $revertCssName;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - use: optional
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LDirectedCallPark
     * @uses LDirectedCallPark::setPattern()
     * @uses LDirectedCallPark::setDescription()
     * @uses LDirectedCallPark::setUsage()
     * @uses LDirectedCallPark::setRoutePartitionName()
     * @uses LDirectedCallPark::setRetrievalPrefix()
     * @uses LDirectedCallPark::setReversionPattern()
     * @uses LDirectedCallPark::setRevertCssName()
     * @uses LDirectedCallPark::setUuid()
     * @param string $pattern
     * @param string $description
     * @param string $usage
     * @param XFkType $routePartitionName
     * @param string $retrievalPrefix
     * @param string $reversionPattern
     * @param XFkType $revertCssName
     * @param string $uuid
     */
    public function __construct($pattern = null, $description = null, $usage = null, XFkType $routePartitionName = null, $retrievalPrefix = null, $reversionPattern = null, XFkType $revertCssName = null, $uuid = null)
    {
        $this
            ->setPattern($pattern)
            ->setDescription($description)
            ->setUsage($usage)
            ->setRoutePartitionName($routePartitionName)
            ->setRetrievalPrefix($retrievalPrefix)
            ->setReversionPattern($reversionPattern)
            ->setRevertCssName($revertCssName)
            ->setUuid($uuid);
    }
    /**
     * Get pattern value
     * @return string|null
     */
    public function getPattern()
    {
        return $this->pattern;
    }
    /**
     * Set pattern value
     * @param string $pattern
     * @return LDirectedCallPark
     */
    public function setPattern($pattern = null)
    {
        // validation for constraint: string
        if (!is_null($pattern) && !is_string($pattern)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pattern)), __LINE__);
        }
        $this->pattern = $pattern;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return LDirectedCallPark
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get usage value
     * @return string|null
     */
    public function getUsage()
    {
        return $this->usage;
    }
    /**
     * Set usage value
     * @uses XPatternUsage::valueIsValid()
     * @uses XPatternUsage::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $usage
     * @return LDirectedCallPark
     */
    public function setUsage($usage = null)
    {
        // validation for constraint: enumeration
        if (!XPatternUsage::valueIsValid($usage)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $usage, implode(', ', XPatternUsage::getValidValues())), __LINE__);
        }
        $this->usage = $usage;
        return $this;
    }
    /**
     * Get routePartitionName value
     * @return XFkType|null
     */
    public function getRoutePartitionName()
    {
        return $this->routePartitionName;
    }
    /**
     * Set routePartitionName value
     * @param XFkType $routePartitionName
     * @return LDirectedCallPark
     */
    public function setRoutePartitionName(XFkType $routePartitionName = null)
    {
        $this->routePartitionName = $routePartitionName;
        return $this;
    }
    /**
     * Get retrievalPrefix value
     * @return string|null
     */
    public function getRetrievalPrefix()
    {
        return $this->retrievalPrefix;
    }
    /**
     * Set retrievalPrefix value
     * @param string $retrievalPrefix
     * @return LDirectedCallPark
     */
    public function setRetrievalPrefix($retrievalPrefix = null)
    {
        // validation for constraint: string
        if (!is_null($retrievalPrefix) && !is_string($retrievalPrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($retrievalPrefix)), __LINE__);
        }
        $this->retrievalPrefix = $retrievalPrefix;
        return $this;
    }
    /**
     * Get reversionPattern value
     * @return string|null
     */
    public function getReversionPattern()
    {
        return $this->reversionPattern;
    }
    /**
     * Set reversionPattern value
     * @param string $reversionPattern
     * @return LDirectedCallPark
     */
    public function setReversionPattern($reversionPattern = null)
    {
        // validation for constraint: string
        if (!is_null($reversionPattern) && !is_string($reversionPattern)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($reversionPattern)), __LINE__);
        }
        $this->reversionPattern = $reversionPattern;
        return $this;
    }
    /**
     * Get revertCssName value
     * @return XFkType|null
     */
    public function getRevertCssName()
    {
        return $this->revertCssName;
    }
    /**
     * Set revertCssName value
     * @param XFkType $revertCssName
     * @return LDirectedCallPark
     */
    public function setRevertCssName(XFkType $revertCssName = null)
    {
        $this->revertCssName = $revertCssName;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return LDirectedCallPark
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\{........-....-....-....-............\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return LDirectedCallPark
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
