<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetSafCcdPurgeBlockLearnedRoutesReq StructType
 * @subpackage Structs
 */
class GetSafCcdPurgeBlockLearnedRoutesReq extends AbstractStructBase
{
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * The learnedPattern
     * Meta informations extracted from the WSDL
     * - documentation: Either learnedPattern or learnedPatternPrefix has to be set
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 50
     * @var string
     */
    public $learnedPattern;
    /**
     * The learnedPatternPrefix
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 50
     * @var string
     */
    public $learnedPatternPrefix;
    /**
     * The callControlIdentity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 50
     * @var string
     */
    public $callControlIdentity;
    /**
     * The ipAddress
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 50
     * @var string
     */
    public $ipAddress;
    /**
     * The returnedTags
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var RSafCcdPurgeBlockLearnedRoutes
     */
    public $returnedTags;
    /**
     * The sequence
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var int
     */
    public $sequence;
    /**
     * Constructor method for GetSafCcdPurgeBlockLearnedRoutesReq
     * @uses GetSafCcdPurgeBlockLearnedRoutesReq::setUuid()
     * @uses GetSafCcdPurgeBlockLearnedRoutesReq::setLearnedPattern()
     * @uses GetSafCcdPurgeBlockLearnedRoutesReq::setLearnedPatternPrefix()
     * @uses GetSafCcdPurgeBlockLearnedRoutesReq::setCallControlIdentity()
     * @uses GetSafCcdPurgeBlockLearnedRoutesReq::setIpAddress()
     * @uses GetSafCcdPurgeBlockLearnedRoutesReq::setReturnedTags()
     * @uses GetSafCcdPurgeBlockLearnedRoutesReq::setSequence()
     * @param string $uuid
     * @param string $learnedPattern
     * @param string $learnedPatternPrefix
     * @param string $callControlIdentity
     * @param string $ipAddress
     * @param RSafCcdPurgeBlockLearnedRoutes $returnedTags
     * @param int $sequence
     */
    public function __construct($uuid = null, $learnedPattern = null, $learnedPatternPrefix = null, $callControlIdentity = null, $ipAddress = null, RSafCcdPurgeBlockLearnedRoutes $returnedTags = null, $sequence = null)
    {
        $this
            ->setUuid($uuid)
            ->setLearnedPattern($learnedPattern)
            ->setLearnedPatternPrefix($learnedPatternPrefix)
            ->setCallControlIdentity($callControlIdentity)
            ->setIpAddress($ipAddress)
            ->setReturnedTags($returnedTags)
            ->setSequence($sequence);
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return GetSafCcdPurgeBlockLearnedRoutesReq
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\{........-....-....-....-............\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Get learnedPattern value
     * @return string|null
     */
    public function getLearnedPattern()
    {
        return $this->learnedPattern;
    }
    /**
     * Set learnedPattern value
     * @param string $learnedPattern
     * @return GetSafCcdPurgeBlockLearnedRoutesReq
     */
    public function setLearnedPattern($learnedPattern = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($learnedPattern) && strlen($learnedPattern) > 50) || (is_array($learnedPattern) && count($learnedPattern) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($learnedPattern) ? strlen($learnedPattern) : count($learnedPattern)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($learnedPattern) && !is_string($learnedPattern)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($learnedPattern)), __LINE__);
        }
        $this->learnedPattern = $learnedPattern;
        return $this;
    }
    /**
     * Get learnedPatternPrefix value
     * @return string|null
     */
    public function getLearnedPatternPrefix()
    {
        return $this->learnedPatternPrefix;
    }
    /**
     * Set learnedPatternPrefix value
     * @param string $learnedPatternPrefix
     * @return GetSafCcdPurgeBlockLearnedRoutesReq
     */
    public function setLearnedPatternPrefix($learnedPatternPrefix = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($learnedPatternPrefix) && strlen($learnedPatternPrefix) > 50) || (is_array($learnedPatternPrefix) && count($learnedPatternPrefix) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($learnedPatternPrefix) ? strlen($learnedPatternPrefix) : count($learnedPatternPrefix)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($learnedPatternPrefix) && !is_string($learnedPatternPrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($learnedPatternPrefix)), __LINE__);
        }
        $this->learnedPatternPrefix = $learnedPatternPrefix;
        return $this;
    }
    /**
     * Get callControlIdentity value
     * @return string|null
     */
    public function getCallControlIdentity()
    {
        return $this->callControlIdentity;
    }
    /**
     * Set callControlIdentity value
     * @param string $callControlIdentity
     * @return GetSafCcdPurgeBlockLearnedRoutesReq
     */
    public function setCallControlIdentity($callControlIdentity = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($callControlIdentity) && strlen($callControlIdentity) > 50) || (is_array($callControlIdentity) && count($callControlIdentity) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($callControlIdentity) ? strlen($callControlIdentity) : count($callControlIdentity)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($callControlIdentity) && !is_string($callControlIdentity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($callControlIdentity)), __LINE__);
        }
        $this->callControlIdentity = $callControlIdentity;
        return $this;
    }
    /**
     * Get ipAddress value
     * @return string|null
     */
    public function getIpAddress()
    {
        return $this->ipAddress;
    }
    /**
     * Set ipAddress value
     * @param string $ipAddress
     * @return GetSafCcdPurgeBlockLearnedRoutesReq
     */
    public function setIpAddress($ipAddress = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($ipAddress) && strlen($ipAddress) > 50) || (is_array($ipAddress) && count($ipAddress) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($ipAddress) ? strlen($ipAddress) : count($ipAddress)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($ipAddress) && !is_string($ipAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ipAddress)), __LINE__);
        }
        $this->ipAddress = $ipAddress;
        return $this;
    }
    /**
     * Get returnedTags value
     * @return RSafCcdPurgeBlockLearnedRoutes|null
     */
    public function getReturnedTags()
    {
        return $this->returnedTags;
    }
    /**
     * Set returnedTags value
     * @param RSafCcdPurgeBlockLearnedRoutes $returnedTags
     * @return GetSafCcdPurgeBlockLearnedRoutesReq
     */
    public function setReturnedTags(RSafCcdPurgeBlockLearnedRoutes $returnedTags = null)
    {
        $this->returnedTags = $returnedTags;
        return $this;
    }
    /**
     * Get sequence value
     * @return int|null
     */
    public function getSequence()
    {
        return $this->sequence;
    }
    /**
     * Set sequence value
     * @param int $sequence
     * @return GetSafCcdPurgeBlockLearnedRoutesReq
     */
    public function setSequence($sequence = null)
    {
        // validation for constraint: int
        if (!is_null($sequence) && !is_numeric($sequence)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sequence)), __LINE__);
        }
        $this->sequence = $sequence;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return GetSafCcdPurgeBlockLearnedRoutesReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
