<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetPhoneTypeDisplayInstanceReq StructType
 * @subpackage Structs
 */
class GetPhoneTypeDisplayInstanceReq extends APIRequest
{
    /**
     * The productName
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * - maxLength: 32
     * @var string
     */
    public $productName;
    /**
     * The protocol
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * - maxLength: 32
     * @var string
     */
    public $protocol;
    /**
     * Constructor method for GetPhoneTypeDisplayInstanceReq
     * @uses GetPhoneTypeDisplayInstanceReq::setProductName()
     * @uses GetPhoneTypeDisplayInstanceReq::setProtocol()
     * @param string $productName
     * @param string $protocol
     */
    public function __construct($productName = null, $protocol = null)
    {
        $this
            ->setProductName($productName)
            ->setProtocol($protocol);
    }
    /**
     * Get productName value
     * @return string
     */
    public function getProductName()
    {
        return $this->productName;
    }
    /**
     * Set productName value
     * @param string $productName
     * @return GetPhoneTypeDisplayInstanceReq
     */
    public function setProductName($productName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($productName) && strlen($productName) > 32) || (is_array($productName) && count($productName) > 32)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 32 element(s) or a scalar of 32 character(s) at most, "%d" length given', is_scalar($productName) ? strlen($productName) : count($productName)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($productName) && !is_string($productName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($productName)), __LINE__);
        }
        $this->productName = $productName;
        return $this;
    }
    /**
     * Get protocol value
     * @return string
     */
    public function getProtocol()
    {
        return $this->protocol;
    }
    /**
     * Set protocol value
     * @param string $protocol
     * @return GetPhoneTypeDisplayInstanceReq
     */
    public function setProtocol($protocol = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($protocol) && strlen($protocol) > 32) || (is_array($protocol) && count($protocol) > 32)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 32 element(s) or a scalar of 32 character(s) at most, "%d" length given', is_scalar($protocol) ? strlen($protocol) : count($protocol)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($protocol) && !is_string($protocol)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($protocol)), __LINE__);
        }
        $this->protocol = $protocol;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return GetPhoneTypeDisplayInstanceReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
