<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DoUpdateRemoteClusterReq StructType
 * @subpackage Structs
 */
class DoUpdateRemoteClusterReq extends APIRequest
{
    /**
     * The server
     * Meta informations extracted from the WSDL
     * - maxLength: 32
     * @var string
     */
    public $server;
    /**
     * The clusterId
     * Meta informations extracted from the WSDL
     * - maxLength: 32
     * @var string
     */
    public $clusterId;
    /**
     * Constructor method for DoUpdateRemoteClusterReq
     * @uses DoUpdateRemoteClusterReq::setServer()
     * @uses DoUpdateRemoteClusterReq::setClusterId()
     * @param string $server
     * @param string $clusterId
     */
    public function __construct($server = null, $clusterId = null)
    {
        $this
            ->setServer($server)
            ->setClusterId($clusterId);
    }
    /**
     * Get server value
     * @return string|null
     */
    public function getServer()
    {
        return $this->server;
    }
    /**
     * Set server value
     * @param string $server
     * @return DoUpdateRemoteClusterReq
     */
    public function setServer($server = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($server) && strlen($server) > 32) || (is_array($server) && count($server) > 32)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 32 element(s) or a scalar of 32 character(s) at most, "%d" length given', is_scalar($server) ? strlen($server) : count($server)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($server) && !is_string($server)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($server)), __LINE__);
        }
        $this->server = $server;
        return $this;
    }
    /**
     * Get clusterId value
     * @return string|null
     */
    public function getClusterId()
    {
        return $this->clusterId;
    }
    /**
     * Set clusterId value
     * @param string $clusterId
     * @return DoUpdateRemoteClusterReq
     */
    public function setClusterId($clusterId = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($clusterId) && strlen($clusterId) > 32) || (is_array($clusterId) && count($clusterId) > 32)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 32 element(s) or a scalar of 32 character(s) at most, "%d" length given', is_scalar($clusterId) ? strlen($clusterId) : count($clusterId)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($clusterId) && !is_string($clusterId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($clusterId)), __LINE__);
        }
        $this->clusterId = $clusterId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return DoUpdateRemoteClusterReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
