<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DoNotificationRegisterRes StructType
 * @subpackage Structs
 */
class DoNotificationRegisterRes extends APIResponse
{
    /**
     * The registrationId
     * Meta informations extracted from the WSDL
     * - maxLength: 32
     * @var string
     */
    public $registrationId;
    /**
     * The pollingInterval
     * Meta informations extracted from the WSDL
     * - maxLength: 32
     * @var string
     */
    public $pollingInterval;
    /**
     * The pollingStartTime
     * Meta informations extracted from the WSDL
     * - maxLength: 32
     * @var string
     */
    public $pollingStartTime;
    /**
     * Constructor method for DoNotificationRegisterRes
     * @uses DoNotificationRegisterRes::setRegistrationId()
     * @uses DoNotificationRegisterRes::setPollingInterval()
     * @uses DoNotificationRegisterRes::setPollingStartTime()
     * @param string $registrationId
     * @param string $pollingInterval
     * @param string $pollingStartTime
     */
    public function __construct($registrationId = null, $pollingInterval = null, $pollingStartTime = null)
    {
        $this
            ->setRegistrationId($registrationId)
            ->setPollingInterval($pollingInterval)
            ->setPollingStartTime($pollingStartTime);
    }
    /**
     * Get registrationId value
     * @return string|null
     */
    public function getRegistrationId()
    {
        return $this->registrationId;
    }
    /**
     * Set registrationId value
     * @param string $registrationId
     * @return DoNotificationRegisterRes
     */
    public function setRegistrationId($registrationId = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($registrationId) && strlen($registrationId) > 32) || (is_array($registrationId) && count($registrationId) > 32)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 32 element(s) or a scalar of 32 character(s) at most, "%d" length given', is_scalar($registrationId) ? strlen($registrationId) : count($registrationId)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($registrationId) && !is_string($registrationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($registrationId)), __LINE__);
        }
        $this->registrationId = $registrationId;
        return $this;
    }
    /**
     * Get pollingInterval value
     * @return string|null
     */
    public function getPollingInterval()
    {
        return $this->pollingInterval;
    }
    /**
     * Set pollingInterval value
     * @param string $pollingInterval
     * @return DoNotificationRegisterRes
     */
    public function setPollingInterval($pollingInterval = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($pollingInterval) && strlen($pollingInterval) > 32) || (is_array($pollingInterval) && count($pollingInterval) > 32)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 32 element(s) or a scalar of 32 character(s) at most, "%d" length given', is_scalar($pollingInterval) ? strlen($pollingInterval) : count($pollingInterval)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($pollingInterval) && !is_string($pollingInterval)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pollingInterval)), __LINE__);
        }
        $this->pollingInterval = $pollingInterval;
        return $this;
    }
    /**
     * Get pollingStartTime value
     * @return string|null
     */
    public function getPollingStartTime()
    {
        return $this->pollingStartTime;
    }
    /**
     * Set pollingStartTime value
     * @param string $pollingStartTime
     * @return DoNotificationRegisterRes
     */
    public function setPollingStartTime($pollingStartTime = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($pollingStartTime) && strlen($pollingStartTime) > 32) || (is_array($pollingStartTime) && count($pollingStartTime) > 32)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 32 element(s) or a scalar of 32 character(s) at most, "%d" length given', is_scalar($pollingStartTime) ? strlen($pollingStartTime) : count($pollingStartTime)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($pollingStartTime) && !is_string($pollingStartTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pollingStartTime)), __LINE__);
        }
        $this->pollingStartTime = $pollingStartTime;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return DoNotificationRegisterRes
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
