<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DoNotificationAckReq StructType
 * @subpackage Structs
 */
class DoNotificationAckReq extends APIRequest
{
    /**
     * The registrationId
     * Meta informations extracted from the WSDL
     * - maxLength: 32
     * @var string
     */
    public $registrationId;
    /**
     * The object
     * Meta informations extracted from the WSDL
     * - maxLength: 32
     * @var string
     */
    public $object;
    /**
     * The count
     * Meta informations extracted from the WSDL
     * - maxLength: 32
     * @var string
     */
    public $count;
    /**
     * Constructor method for DoNotificationAckReq
     * @uses DoNotificationAckReq::setRegistrationId()
     * @uses DoNotificationAckReq::setObject()
     * @uses DoNotificationAckReq::setCount()
     * @param string $registrationId
     * @param string $object
     * @param string $count
     */
    public function __construct($registrationId = null, $object = null, $count = null)
    {
        $this
            ->setRegistrationId($registrationId)
            ->setObject($object)
            ->setCount($count);
    }
    /**
     * Get registrationId value
     * @return string|null
     */
    public function getRegistrationId()
    {
        return $this->registrationId;
    }
    /**
     * Set registrationId value
     * @param string $registrationId
     * @return DoNotificationAckReq
     */
    public function setRegistrationId($registrationId = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($registrationId) && strlen($registrationId) > 32) || (is_array($registrationId) && count($registrationId) > 32)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 32 element(s) or a scalar of 32 character(s) at most, "%d" length given', is_scalar($registrationId) ? strlen($registrationId) : count($registrationId)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($registrationId) && !is_string($registrationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($registrationId)), __LINE__);
        }
        $this->registrationId = $registrationId;
        return $this;
    }
    /**
     * Get object value
     * @return string|null
     */
    public function getObject()
    {
        return $this->object;
    }
    /**
     * Set object value
     * @param string $object
     * @return DoNotificationAckReq
     */
    public function setObject($object = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($object) && strlen($object) > 32) || (is_array($object) && count($object) > 32)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 32 element(s) or a scalar of 32 character(s) at most, "%d" length given', is_scalar($object) ? strlen($object) : count($object)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($object) && !is_string($object)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($object)), __LINE__);
        }
        $this->object = $object;
        return $this;
    }
    /**
     * Get count value
     * @return string|null
     */
    public function getCount()
    {
        return $this->count;
    }
    /**
     * Set count value
     * @param string $count
     * @return DoNotificationAckReq
     */
    public function setCount($count = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($count) && strlen($count) > 32) || (is_array($count) && count($count) > 32)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 32 element(s) or a scalar of 32 character(s) at most, "%d" length given', is_scalar($count) ? strlen($count) : count($count)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($count) && !is_string($count)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($count)), __LINE__);
        }
        $this->count = $count;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return DoNotificationAckReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
