<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for autoRegistration StructType
 * @subpackage Structs
 */
class AutoRegistration extends AbstractStructBase
{
    /**
     * The startDn
     * Meta informations extracted from the WSDL
     * - default: 1000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 255
     * @var string
     */
    public $startDn;
    /**
     * The endDn
     * Meta informations extracted from the WSDL
     * - default: 1000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 255
     * @var string
     */
    public $endDn;
    /**
     * The nextDn
     * Meta informations extracted from the WSDL
     * - default: 1000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 255
     * @var string
     */
    public $nextDn;
    /**
     * The routePartitionName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $routePartitionName;
    /**
     * The e164Mask
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 50
     * @var string
     */
    public $e164Mask;
    /**
     * Constructor method for autoRegistration
     * @uses AutoRegistration::setStartDn()
     * @uses AutoRegistration::setEndDn()
     * @uses AutoRegistration::setNextDn()
     * @uses AutoRegistration::setRoutePartitionName()
     * @uses AutoRegistration::setE164Mask()
     * @param string $startDn
     * @param string $endDn
     * @param string $nextDn
     * @param XFkType $routePartitionName
     * @param string $e164Mask
     */
    public function __construct($startDn = '1000', $endDn = '1000', $nextDn = '1000', XFkType $routePartitionName = null, $e164Mask = null)
    {
        $this
            ->setStartDn($startDn)
            ->setEndDn($endDn)
            ->setNextDn($nextDn)
            ->setRoutePartitionName($routePartitionName)
            ->setE164Mask($e164Mask);
    }
    /**
     * Get startDn value
     * @return string|null
     */
    public function getStartDn()
    {
        return $this->startDn;
    }
    /**
     * Set startDn value
     * @param string $startDn
     * @return AutoRegistration
     */
    public function setStartDn($startDn = '1000')
    {
        // validation for constraint: maxLength
        if ((is_scalar($startDn) && strlen($startDn) > 255) || (is_array($startDn) && count($startDn) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($startDn) ? strlen($startDn) : count($startDn)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($startDn) && !is_string($startDn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($startDn)), __LINE__);
        }
        $this->startDn = $startDn;
        return $this;
    }
    /**
     * Get endDn value
     * @return string|null
     */
    public function getEndDn()
    {
        return $this->endDn;
    }
    /**
     * Set endDn value
     * @param string $endDn
     * @return AutoRegistration
     */
    public function setEndDn($endDn = '1000')
    {
        // validation for constraint: maxLength
        if ((is_scalar($endDn) && strlen($endDn) > 255) || (is_array($endDn) && count($endDn) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($endDn) ? strlen($endDn) : count($endDn)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($endDn) && !is_string($endDn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($endDn)), __LINE__);
        }
        $this->endDn = $endDn;
        return $this;
    }
    /**
     * Get nextDn value
     * @return string|null
     */
    public function getNextDn()
    {
        return $this->nextDn;
    }
    /**
     * Set nextDn value
     * @param string $nextDn
     * @return AutoRegistration
     */
    public function setNextDn($nextDn = '1000')
    {
        // validation for constraint: maxLength
        if ((is_scalar($nextDn) && strlen($nextDn) > 255) || (is_array($nextDn) && count($nextDn) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($nextDn) ? strlen($nextDn) : count($nextDn)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($nextDn) && !is_string($nextDn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nextDn)), __LINE__);
        }
        $this->nextDn = $nextDn;
        return $this;
    }
    /**
     * Get routePartitionName value
     * @return XFkType|null
     */
    public function getRoutePartitionName()
    {
        return $this->routePartitionName;
    }
    /**
     * Set routePartitionName value
     * @param XFkType $routePartitionName
     * @return AutoRegistration
     */
    public function setRoutePartitionName(XFkType $routePartitionName = null)
    {
        $this->routePartitionName = $routePartitionName;
        return $this;
    }
    /**
     * Get e164Mask value
     * @return string|null
     */
    public function getE164Mask()
    {
        return $this->e164Mask;
    }
    /**
     * Set e164Mask value
     * @param string $e164Mask
     * @return AutoRegistration
     */
    public function setE164Mask($e164Mask = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($e164Mask) && strlen($e164Mask) > 50) || (is_array($e164Mask) && count($e164Mask) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($e164Mask) ? strlen($e164Mask) : count($e164Mask)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($e164Mask) && !is_string($e164Mask)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($e164Mask)), __LINE__);
        }
        $this->e164Mask = $e164Mask;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return AutoRegistration
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
