<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for addAssociatedTrunks StructType
 * @subpackage Structs
 */
class AddAssociatedTrunks extends XCommonMembersExtension
{
    /**
     * The associatedTrunk
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var XCcdRequestingServiceMember[]
     */
    public $associatedTrunk;
    /**
     * Constructor method for addAssociatedTrunks
     * @uses AddAssociatedTrunks::setAssociatedTrunk()
     * @param XCcdRequestingServiceMember[] $associatedTrunk
     */
    public function __construct(array $associatedTrunk = array())
    {
        $this
            ->setAssociatedTrunk($associatedTrunk);
    }
    /**
     * Get associatedTrunk value
     * @return XCcdRequestingServiceMember[]
     */
    public function getAssociatedTrunk()
    {
        return $this->associatedTrunk;
    }
    /**
     * Set associatedTrunk value
     * @throws \InvalidArgumentException
     * @param XCcdRequestingServiceMember[] $associatedTrunk
     * @return AddAssociatedTrunks
     */
    public function setAssociatedTrunk(array $associatedTrunk = array())
    {
        foreach ($associatedTrunk as $addAssociatedTrunksAssociatedTrunkItem) {
            // validation for constraint: itemType
            if (!$addAssociatedTrunksAssociatedTrunkItem instanceof XCcdRequestingServiceMember) {
                throw new \InvalidArgumentException(sprintf('The associatedTrunk property can only contain items of XCcdRequestingServiceMember, "%s" given', is_object($addAssociatedTrunksAssociatedTrunkItem) ? get_class($addAssociatedTrunksAssociatedTrunkItem) : gettype($addAssociatedTrunksAssociatedTrunkItem)), __LINE__);
            }
        }
        $this->associatedTrunk = $associatedTrunk;
        return $this;
    }
    /**
     * Add item to associatedTrunk value
     * @throws \InvalidArgumentException
     * @param XCcdRequestingServiceMember $item
     * @return AddAssociatedTrunks
     */
    public function addToAssociatedTrunk(XCcdRequestingServiceMember $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof XCcdRequestingServiceMember) {
            throw new \InvalidArgumentException(sprintf('The associatedTrunk property can only contain items of XCcdRequestingServiceMember, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->associatedTrunk[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return AddAssociatedTrunks
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
