<?php
/**
 * This class stands for XWinCharSet EnumType
 * @subpackage Enumerations
 */
class XWinCharSet
{
    /**
     * Constant for value 'iso-8859-1'
     * @return string 'iso-8859-1'
     */
    const VALUE_ISO_8859_1 = 'iso-8859-1';
    /**
     * Constant for value 'iso-8859-2'
     * @return string 'iso-8859-2'
     */
    const VALUE_ISO_8859_2 = 'iso-8859-2';
    /**
     * Constant for value 'UTF-8 Unicode'
     * @return string 'UTF-8 Unicode'
     */
    const VALUE_UTF_8_UNICODE = 'UTF-8 Unicode';
    /**
     * Constant for value 'UTF-7 Unicode'
     * @return string 'UTF-7 Unicode'
     */
    const VALUE_UTF_7_UNICODE = 'UTF-7 Unicode';
    /**
     * Constant for value 'windows-1251'
     * @return string 'windows-1251'
     */
    const VALUE_WINDOWS_1251 = 'windows-1251';
    /**
     * Constant for value 'Shift_JIS'
     * @return string 'Shift_JIS'
     */
    const VALUE_SHIFT_JIS = 'Shift_JIS';
    /**
     * Constant for value 'windows-1253'
     * @return string 'windows-1253'
     */
    const VALUE_WINDOWS_1253 = 'windows-1253';
    /**
     * Constant for value 'GB2312'
     * @return string 'GB2312'
     */
    const VALUE_GB_2312 = 'GB2312';
    /**
     * Constant for value 'BIG5'
     * @return string 'BIG5'
     */
    const VALUE_BIG_5 = 'BIG5';
    /**
     * Constant for value 'KSC5061'
     * @return string 'KSC5061'
     */
    const VALUE_KSC_5061 = 'KSC5061';
    /**
     * Constant for value 'UTF-8'
     * @return string 'UTF-8'
     */
    const VALUE_UTF_8 = 'UTF-8';
    /**
     * Constant for value 'windows-1254'
     * @return string 'windows-1254'
     */
    const VALUE_WINDOWS_1254 = 'windows-1254';
    /**
     * Constant for value 'windows-1255'
     * @return string 'windows-1255'
     */
    const VALUE_WINDOWS_1255 = 'windows-1255';
    /**
     * Constant for value 'windows-1256'
     * @return string 'windows-1256'
     */
    const VALUE_WINDOWS_1256 = 'windows-1256';
    /**
     * Constant for value 'iso-8859-6'
     * @return string 'iso-8859-6'
     */
    const VALUE_ISO_8859_6 = 'iso-8859-6';
    /**
     * Constant for value 'iso-8859-8-l'
     * @return string 'iso-8859-8-l'
     */
    const VALUE_ISO_8859_8_L = 'iso-8859-8-l';
    /**
     * Constant for value 'windows-874'
     * @return string 'windows-874'
     */
    const VALUE_WINDOWS_874 = 'windows-874';
    /**
     * Constant for value 'windows-1258'
     * @return string 'windows-1258'
     */
    const VALUE_WINDOWS_1258 = 'windows-1258';
    /**
     * Constant for value 'windows-1257'
     * @return string 'windows-1257'
     */
    const VALUE_WINDOWS_1257 = 'windows-1257';
    /**
     * Constant for value 'iso-8859-4'
     * @return string 'iso-8859-4'
     */
    const VALUE_ISO_8859_4 = 'iso-8859-4';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ISO_8859_1
     * @uses self::VALUE_ISO_8859_2
     * @uses self::VALUE_UTF_8_UNICODE
     * @uses self::VALUE_UTF_7_UNICODE
     * @uses self::VALUE_WINDOWS_1251
     * @uses self::VALUE_SHIFT_JIS
     * @uses self::VALUE_WINDOWS_1253
     * @uses self::VALUE_GB_2312
     * @uses self::VALUE_BIG_5
     * @uses self::VALUE_KSC_5061
     * @uses self::VALUE_UTF_8
     * @uses self::VALUE_WINDOWS_1254
     * @uses self::VALUE_WINDOWS_1255
     * @uses self::VALUE_WINDOWS_1256
     * @uses self::VALUE_ISO_8859_6
     * @uses self::VALUE_ISO_8859_8_L
     * @uses self::VALUE_WINDOWS_874
     * @uses self::VALUE_WINDOWS_1258
     * @uses self::VALUE_WINDOWS_1257
     * @uses self::VALUE_ISO_8859_4
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ISO_8859_1,
            self::VALUE_ISO_8859_2,
            self::VALUE_UTF_8_UNICODE,
            self::VALUE_UTF_7_UNICODE,
            self::VALUE_WINDOWS_1251,
            self::VALUE_SHIFT_JIS,
            self::VALUE_WINDOWS_1253,
            self::VALUE_GB_2312,
            self::VALUE_BIG_5,
            self::VALUE_KSC_5061,
            self::VALUE_UTF_8,
            self::VALUE_WINDOWS_1254,
            self::VALUE_WINDOWS_1255,
            self::VALUE_WINDOWS_1256,
            self::VALUE_ISO_8859_6,
            self::VALUE_ISO_8859_8_L,
            self::VALUE_WINDOWS_874,
            self::VALUE_WINDOWS_1258,
            self::VALUE_WINDOWS_1257,
            self::VALUE_ISO_8859_4,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
