<?php
/**
 * This class stands for XWebPage EnumType
 * @subpackage Enumerations
 */
class XWebPage
{
    /**
     * Constant for value 'Common Device Template'
     * @return string 'Common Device Template'
     */
    const VALUE_COMMON_DEVICE_TEMPLATE = 'Common Device Template';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_COMMON_DEVICE_TEMPLATE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_COMMON_DEVICE_TEMPLATE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
