<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XUserPhoneAssociation StructType
 * @subpackage Structs
 */
class XUserPhoneAssociation extends AbstractStructBase
{
    /**
     * The userId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $userId;
    /**
     * The lastName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $lastName;
    /**
     * The productType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $productType;
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - maxLength: 128
     * @var string
     */
    public $name;
    /**
     * The e164Mask
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $e164Mask;
    /**
     * The extension
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $extension;
    /**
     * The password
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $password;
    /**
     * The pin
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $pin;
    /**
     * The middleName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $middleName;
    /**
     * The firstName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $firstName;
    /**
     * The dnCssName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $dnCssName;
    /**
     * The phoneCssName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $phoneCssName;
    /**
     * The routePartitionName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $routePartitionName;
    /**
     * The voiceMailProfileName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $voiceMailProfileName;
    /**
     * The enableExtensionMobility
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enableExtensionMobility;
    /**
     * The DirectoryURI
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $DirectoryURI;
    /**
     * The DirectoryNumberURIPartition
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $DirectoryNumberURIPartition;
    /**
     * Constructor method for XUserPhoneAssociation
     * @uses XUserPhoneAssociation::setUserId()
     * @uses XUserPhoneAssociation::setLastName()
     * @uses XUserPhoneAssociation::setProductType()
     * @uses XUserPhoneAssociation::setName()
     * @uses XUserPhoneAssociation::setE164Mask()
     * @uses XUserPhoneAssociation::setExtension()
     * @uses XUserPhoneAssociation::setPassword()
     * @uses XUserPhoneAssociation::setPin()
     * @uses XUserPhoneAssociation::setMiddleName()
     * @uses XUserPhoneAssociation::setFirstName()
     * @uses XUserPhoneAssociation::setDnCssName()
     * @uses XUserPhoneAssociation::setPhoneCssName()
     * @uses XUserPhoneAssociation::setRoutePartitionName()
     * @uses XUserPhoneAssociation::setVoiceMailProfileName()
     * @uses XUserPhoneAssociation::setEnableExtensionMobility()
     * @uses XUserPhoneAssociation::setDirectoryURI()
     * @uses XUserPhoneAssociation::setDirectoryNumberURIPartition()
     * @param string $userId
     * @param string $lastName
     * @param string $productType
     * @param string $name
     * @param string $e164Mask
     * @param string $extension
     * @param string $password
     * @param string $pin
     * @param string $middleName
     * @param string $firstName
     * @param XFkType $dnCssName
     * @param XFkType $phoneCssName
     * @param XFkType $routePartitionName
     * @param XFkType $voiceMailProfileName
     * @param string $enableExtensionMobility
     * @param string $directoryURI
     * @param XFkType $directoryNumberURIPartition
     */
    public function __construct($userId = null, $lastName = null, $productType = null, $name = null, $e164Mask = null, $extension = null, $password = null, $pin = null, $middleName = null, $firstName = null, XFkType $dnCssName = null, XFkType $phoneCssName = null, XFkType $routePartitionName = null, XFkType $voiceMailProfileName = null, $enableExtensionMobility = null, $directoryURI = null, XFkType $directoryNumberURIPartition = null)
    {
        $this
            ->setUserId($userId)
            ->setLastName($lastName)
            ->setProductType($productType)
            ->setName($name)
            ->setE164Mask($e164Mask)
            ->setExtension($extension)
            ->setPassword($password)
            ->setPin($pin)
            ->setMiddleName($middleName)
            ->setFirstName($firstName)
            ->setDnCssName($dnCssName)
            ->setPhoneCssName($phoneCssName)
            ->setRoutePartitionName($routePartitionName)
            ->setVoiceMailProfileName($voiceMailProfileName)
            ->setEnableExtensionMobility($enableExtensionMobility)
            ->setDirectoryURI($directoryURI)
            ->setDirectoryNumberURIPartition($directoryNumberURIPartition);
    }
    /**
     * Get userId value
     * @return string
     */
    public function getUserId()
    {
        return $this->userId;
    }
    /**
     * Set userId value
     * @param string $userId
     * @return XUserPhoneAssociation
     */
    public function setUserId($userId = null)
    {
        // validation for constraint: string
        if (!is_null($userId) && !is_string($userId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userId)), __LINE__);
        }
        $this->userId = $userId;
        return $this;
    }
    /**
     * Get lastName value
     * @return string
     */
    public function getLastName()
    {
        return $this->lastName;
    }
    /**
     * Set lastName value
     * @param string $lastName
     * @return XUserPhoneAssociation
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastName)), __LINE__);
        }
        $this->lastName = $lastName;
        return $this;
    }
    /**
     * Get productType value
     * @return string
     */
    public function getProductType()
    {
        return $this->productType;
    }
    /**
     * Set productType value
     * @uses XModel::valueIsValid()
     * @uses XModel::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $productType
     * @return XUserPhoneAssociation
     */
    public function setProductType($productType = null)
    {
        // validation for constraint: enumeration
        if (!XModel::valueIsValid($productType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $productType, implode(', ', XModel::getValidValues())), __LINE__);
        }
        $this->productType = $productType;
        return $this;
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return XUserPhoneAssociation
     */
    public function setName($name = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($name) && strlen($name) > 128) || (is_array($name) && count($name) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($name) ? strlen($name) : count($name)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get e164Mask value
     * @return string
     */
    public function getE164Mask()
    {
        return $this->e164Mask;
    }
    /**
     * Set e164Mask value
     * @param string $e164Mask
     * @return XUserPhoneAssociation
     */
    public function setE164Mask($e164Mask = null)
    {
        // validation for constraint: string
        if (!is_null($e164Mask) && !is_string($e164Mask)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($e164Mask)), __LINE__);
        }
        $this->e164Mask = $e164Mask;
        return $this;
    }
    /**
     * Get extension value
     * @return string
     */
    public function getExtension()
    {
        return $this->extension;
    }
    /**
     * Set extension value
     * @param string $extension
     * @return XUserPhoneAssociation
     */
    public function setExtension($extension = null)
    {
        // validation for constraint: string
        if (!is_null($extension) && !is_string($extension)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($extension)), __LINE__);
        }
        $this->extension = $extension;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return XUserPhoneAssociation
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
    /**
     * Get pin value
     * @return string|null
     */
    public function getPin()
    {
        return $this->pin;
    }
    /**
     * Set pin value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $pin
     * @return XUserPhoneAssociation
     */
    public function setPin($pin = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($pin)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $pin, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->pin = $pin;
        return $this;
    }
    /**
     * Get middleName value
     * @return string|null
     */
    public function getMiddleName()
    {
        return $this->middleName;
    }
    /**
     * Set middleName value
     * @param string $middleName
     * @return XUserPhoneAssociation
     */
    public function setMiddleName($middleName = null)
    {
        // validation for constraint: string
        if (!is_null($middleName) && !is_string($middleName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($middleName)), __LINE__);
        }
        $this->middleName = $middleName;
        return $this;
    }
    /**
     * Get firstName value
     * @return string|null
     */
    public function getFirstName()
    {
        return $this->firstName;
    }
    /**
     * Set firstName value
     * @param string $firstName
     * @return XUserPhoneAssociation
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($firstName)), __LINE__);
        }
        $this->firstName = $firstName;
        return $this;
    }
    /**
     * Get dnCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getDnCssName()
    {
        return isset($this->dnCssName) ? $this->dnCssName : null;
    }
    /**
     * Set dnCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $dnCssName
     * @return XUserPhoneAssociation
     */
    public function setDnCssName(XFkType $dnCssName = null)
    {
        if (is_null($dnCssName) || (is_array($dnCssName) && empty($dnCssName))) {
            unset($this->dnCssName);
        } else {
            $this->dnCssName = $dnCssName;
        }
        return $this;
    }
    /**
     * Get phoneCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getPhoneCssName()
    {
        return isset($this->phoneCssName) ? $this->phoneCssName : null;
    }
    /**
     * Set phoneCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $phoneCssName
     * @return XUserPhoneAssociation
     */
    public function setPhoneCssName(XFkType $phoneCssName = null)
    {
        if (is_null($phoneCssName) || (is_array($phoneCssName) && empty($phoneCssName))) {
            unset($this->phoneCssName);
        } else {
            $this->phoneCssName = $phoneCssName;
        }
        return $this;
    }
    /**
     * Get routePartitionName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getRoutePartitionName()
    {
        return isset($this->routePartitionName) ? $this->routePartitionName : null;
    }
    /**
     * Set routePartitionName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $routePartitionName
     * @return XUserPhoneAssociation
     */
    public function setRoutePartitionName(XFkType $routePartitionName = null)
    {
        if (is_null($routePartitionName) || (is_array($routePartitionName) && empty($routePartitionName))) {
            unset($this->routePartitionName);
        } else {
            $this->routePartitionName = $routePartitionName;
        }
        return $this;
    }
    /**
     * Get voiceMailProfileName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getVoiceMailProfileName()
    {
        return isset($this->voiceMailProfileName) ? $this->voiceMailProfileName : null;
    }
    /**
     * Set voiceMailProfileName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $voiceMailProfileName
     * @return XUserPhoneAssociation
     */
    public function setVoiceMailProfileName(XFkType $voiceMailProfileName = null)
    {
        if (is_null($voiceMailProfileName) || (is_array($voiceMailProfileName) && empty($voiceMailProfileName))) {
            unset($this->voiceMailProfileName);
        } else {
            $this->voiceMailProfileName = $voiceMailProfileName;
        }
        return $this;
    }
    /**
     * Get enableExtensionMobility value
     * @return string|null
     */
    public function getEnableExtensionMobility()
    {
        return $this->enableExtensionMobility;
    }
    /**
     * Set enableExtensionMobility value
     * @param string $enableExtensionMobility
     * @return XUserPhoneAssociation
     */
    public function setEnableExtensionMobility($enableExtensionMobility = null)
    {
        // validation for constraint: pattern
        if (is_scalar($enableExtensionMobility) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $enableExtensionMobility)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($enableExtensionMobility, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($enableExtensionMobility) && !is_string($enableExtensionMobility)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($enableExtensionMobility)), __LINE__);
        }
        $this->enableExtensionMobility = $enableExtensionMobility;
        return $this;
    }
    /**
     * Get DirectoryURI value
     * @return string|null
     */
    public function getDirectoryURI()
    {
        return $this->DirectoryURI;
    }
    /**
     * Set DirectoryURI value
     * @param string $directoryURI
     * @return XUserPhoneAssociation
     */
    public function setDirectoryURI($directoryURI = null)
    {
        // validation for constraint: string
        if (!is_null($directoryURI) && !is_string($directoryURI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($directoryURI)), __LINE__);
        }
        $this->DirectoryURI = $directoryURI;
        return $this;
    }
    /**
     * Get DirectoryNumberURIPartition value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getDirectoryNumberURIPartition()
    {
        return isset($this->DirectoryNumberURIPartition) ? $this->DirectoryNumberURIPartition : null;
    }
    /**
     * Set DirectoryNumberURIPartition value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $directoryNumberURIPartition
     * @return XUserPhoneAssociation
     */
    public function setDirectoryNumberURIPartition(XFkType $directoryNumberURIPartition = null)
    {
        if (is_null($directoryNumberURIPartition) || (is_array($directoryNumberURIPartition) && empty($directoryNumberURIPartition))) {
            unset($this->DirectoryNumberURIPartition);
        } else {
            $this->DirectoryNumberURIPartition = $directoryNumberURIPartition;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return XUserPhoneAssociation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
