<?php
/**
 * This class stands for XTrunkLevel EnumType
 * @subpackage Enumerations
 */
class XTrunkLevel
{
    /**
     * Constant for value 'AAL(A)'
     * @return string 'AAL(A)'
     */
    const VALUE_AAL_A = 'AAL(A)';
    /**
     * Constant for value 'AAL(D)'
     * @return string 'AAL(D)'
     */
    const VALUE_AAL_D = 'AAL(D)';
    /**
     * Constant for value 'A/TT'
     * @return string 'A/TT'
     */
    const VALUE_A_TT = 'A/TT';
    /**
     * Constant for value 'DAL'
     * @return string 'DAL'
     */
    const VALUE_DAL = 'DAL';
    /**
     * Constant for value 'ICS'
     * @return string 'ICS'
     */
    const VALUE_ICS = 'ICS';
    /**
     * Constant for value 'ISD/TT'
     * @return string 'ISD/TT'
     */
    const VALUE_ISD_TT = 'ISD/TT';
    /**
     * Constant for value 'IST'
     * @return string 'IST'
     */
    const VALUE_IST = 'IST';
    /**
     * Constant for value 'ONS'
     * @return string 'ONS'
     */
    const VALUE_ONS = 'ONS';
    /**
     * Constant for value 'OPS'
     * @return string 'OPS'
     */
    const VALUE_OPS = 'OPS';
    /**
     * Constant for value 'S/ATT'
     * @return string 'S/ATT'
     */
    const VALUE_S_ATT = 'S/ATT';
    /**
     * Constant for value 'S/DTT'
     * @return string 'S/DTT'
     */
    const VALUE_S_DTT = 'S/DTT';
    /**
     * Constant for value 'A/TO'
     * @return string 'A/TO'
     */
    const VALUE_A_TO = 'A/TO';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_AAL_A
     * @uses self::VALUE_AAL_D
     * @uses self::VALUE_A_TT
     * @uses self::VALUE_DAL
     * @uses self::VALUE_ICS
     * @uses self::VALUE_ISD_TT
     * @uses self::VALUE_IST
     * @uses self::VALUE_ONS
     * @uses self::VALUE_OPS
     * @uses self::VALUE_S_ATT
     * @uses self::VALUE_S_DTT
     * @uses self::VALUE_A_TO
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_AAL_A,
            self::VALUE_AAL_D,
            self::VALUE_A_TT,
            self::VALUE_DAL,
            self::VALUE_ICS,
            self::VALUE_ISD_TT,
            self::VALUE_IST,
            self::VALUE_ONS,
            self::VALUE_OPS,
            self::VALUE_S_ATT,
            self::VALUE_S_DTT,
            self::VALUE_A_TO,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
