<?php
/**
 * This class stands for XSupportsFeature EnumType
 * @subpackage Enumerations
 */
class XSupportsFeature
{
    /**
     * Constant for value 'IP Phone Services'
     * @return string 'IP Phone Services'
     */
    const VALUE_IP_PHONE_SERVICES = 'IP Phone Services';
    /**
     * Constant for value 'Is legacy device'
     * @return string 'Is legacy device'
     */
    const VALUE_IS_LEGACY_DEVICE = 'Is legacy device';
    /**
     * Constant for value 'HTTP Server Enabled'
     * @return string 'HTTP Server Enabled'
     */
    const VALUE_HTTP_SERVER_ENABLED = 'HTTP Server Enabled';
    /**
     * Constant for value 'Music On Hold'
     * @return string 'Music On Hold'
     */
    const VALUE_MUSIC_ON_HOLD = 'Music On Hold';
    /**
     * Constant for value 'Ring Setting on This Line'
     * @return string 'Ring Setting on This Line'
     */
    const VALUE_RING_SETTING_ON_THIS_LINE = 'Ring Setting on This Line';
    /**
     * Constant for value 'Call Waiting'
     * @return string 'Call Waiting'
     */
    const VALUE_CALL_WAITING = 'Call Waiting';
    /**
     * Constant for value 'Auto Answer'
     * @return string 'Auto Answer'
     */
    const VALUE_AUTO_ANSWER = 'Auto Answer';
    /**
     * Constant for value 'Shared Line Appearance'
     * @return string 'Shared Line Appearance'
     */
    const VALUE_SHARED_LINE_APPEARANCE = 'Shared Line Appearance';
    /**
     * Constant for value 'Extension Mobility'
     * @return string 'Extension Mobility'
     */
    const VALUE_EXTENSION_MOBILITY = 'Extension Mobility';
    /**
     * Constant for value 'Show Speeddial Labels'
     * @return string 'Show Speeddial Labels'
     */
    const VALUE_SHOW_SPEEDDIAL_LABELS = 'Show Speeddial Labels';
    /**
     * Constant for value 'Show Forward on Failure'
     * @return string 'Show Forward on Failure'
     */
    const VALUE_SHOW_FORWARD_ON_FAILURE = 'Show Forward on Failure';
    /**
     * Constant for value 'Has firmware load'
     * @return string 'Has firmware load'
     */
    const VALUE_HAS_FIRMWARE_LOAD = 'Has firmware load';
    /**
     * Constant for value 'Has phone templates'
     * @return string 'Has phone templates'
     */
    const VALUE_HAS_PHONE_TEMPLATES = 'Has phone templates';
    /**
     * Constant for value 'Media Resource Managed'
     * @return string 'Media Resource Managed'
     */
    const VALUE_MEDIA_RESOURCE_MANAGED = 'Media Resource Managed';
    /**
     * Constant for value 'CTI controlled'
     * @return string 'CTI controlled'
     */
    const VALUE_CTI_CONTROLLED = 'CTI controlled';
    /**
     * Constant for value 'Phone template is User Modifiable'
     * @return string 'Phone template is User Modifiable'
     */
    const VALUE_PHONE_TEMPLATE_IS_USER_MODIFIABLE = 'Phone template is User Modifiable';
    /**
     * Constant for value 'Localization'
     * @return string 'Localization'
     */
    const VALUE_LOCALIZATION = 'Localization';
    /**
     * Constant for value 'Has softkey template'
     * @return string 'Has softkey template'
     */
    const VALUE_HAS_SOFTKEY_TEMPLATE = 'Has softkey template';
    /**
     * Constant for value 'Supports different port types for FXO module'
     * @return string 'Supports different port types for FXO module'
     */
    const VALUE_SUPPORTS_DIFFERENT_PORT_TYPES_FOR_FXO_MODULE = 'Supports different port types for FXO module';
    /**
     * Constant for value 'Phone attached to a Gateway (Like Chalice)'
     * @return string 'Phone attached to a Gateway (Like Chalice)'
     */
    const VALUE_PHONE_ATTACHED_TO_A_GATEWAY_LIKE_CHALICE = 'Phone attached to a Gateway (Like Chalice)';
    /**
     * Constant for value 'Automated Alternate Routing (AAR)'
     * @return string 'Automated Alternate Routing (AAR)'
     */
    const VALUE_AUTOMATED_ALTERNATE_ROUTING_AAR = 'Automated Alternate Routing (AAR)';
    /**
     * Constant for value 'Network Hold'
     * @return string 'Network Hold'
     */
    const VALUE_NETWORK_HOLD = 'Network Hold';
    /**
     * Constant for value 'User Hold'
     * @return string 'User Hold'
     */
    const VALUE_USER_HOLD = 'User Hold';
    /**
     * Constant for value 'Monitor'
     * @return string 'Monitor'
     */
    const VALUE_MONITOR = 'Monitor';
    /**
     * Constant for value 'Record'
     * @return string 'Record'
     */
    const VALUE_RECORD = 'Record';
    /**
     * Constant for value 'Auto Registration'
     * @return string 'Auto Registration'
     */
    const VALUE_AUTO_REGISTRATION = 'Auto Registration';
    /**
     * Constant for value 'Use Generic Icon'
     * @return string 'Use Generic Icon'
     */
    const VALUE_USE_GENERIC_ICON = 'Use Generic Icon';
    /**
     * Constant for value 'MWL Policy'
     * @return string 'MWL Policy'
     */
    const VALUE_MWL_POLICY = 'MWL Policy';
    /**
     * Constant for value 'Line Text Label'
     * @return string 'Line Text Label'
     */
    const VALUE_LINE_TEXT_LABEL = 'Line Text Label';
    /**
     * Constant for value 'Multiple Call Display'
     * @return string 'Multiple Call Display'
     */
    const VALUE_MULTIPLE_CALL_DISPLAY = 'Multiple Call Display';
    /**
     * Constant for value 'Abbreviated Dial'
     * @return string 'Abbreviated Dial'
     */
    const VALUE_ABBREVIATED_DIAL = 'Abbreviated Dial';
    /**
     * Constant for value 'Built In Bridge'
     * @return string 'Built In Bridge'
     */
    const VALUE_BUILT_IN_BRIDGE = 'Built In Bridge';
    /**
     * Constant for value 'Malicious Call Identification'
     * @return string 'Malicious Call Identification'
     */
    const VALUE_MALICIOUS_CALL_IDENTIFICATION = 'Malicious Call Identification';
    /**
     * Constant for value 'Call Precedence (for MLPP)'
     * @return string 'Call Precedence (for MLPP)'
     */
    const VALUE_CALL_PRECEDENCE_FOR_MLPP = 'Call Precedence (for MLPP)';
    /**
     * Constant for value 'Call Pre-emption (for MLPP)'
     * @return string 'Call Pre-emption (for MLPP)'
     */
    const VALUE_CALL_PRE_EMPTION_FOR_MLPP = 'Call Pre-emption (for MLPP)';
    /**
     * Constant for value 'Status Report (Busy Device Indicator)'
     * @return string 'Status Report (Busy Device Indicator)'
     */
    const VALUE_STATUS_REPORT_BUSY_DEVICE_INDICATOR = 'Status Report (Busy Device Indicator)';
    /**
     * Constant for value 'Video'
     * @return string 'Video'
     */
    const VALUE_VIDEO = 'Video';
    /**
     * Constant for value 'Security Authentication'
     * @return string 'Security Authentication'
     */
    const VALUE_SECURITY_AUTHENTICATION = 'Security Authentication';
    /**
     * Constant for value 'Security Encryption'
     * @return string 'Security Encryption'
     */
    const VALUE_SECURITY_ENCRYPTION = 'Security Encryption';
    /**
     * Constant for value 'Online User Guide (HTML or PDF)'
     * @return string 'Online User Guide (HTML or PDF)'
     */
    const VALUE_ONLINE_USER_GUIDE_HTML_OR_PDF = 'Online User Guide (HTML or PDF)';
    /**
     * Constant for value 'Gateway supports summit MTP'
     * @return string 'Gateway supports summit MTP'
     */
    const VALUE_GATEWAY_SUPPORTS_SUMMIT_MTP = 'Gateway supports summit MTP';
    /**
     * Constant for value 'Expansion Module'
     * @return string 'Expansion Module'
     */
    const VALUE_EXPANSION_MODULE = 'Expansion Module';
    /**
     * Constant for value 'Privacy'
     * @return string 'Privacy'
     */
    const VALUE_PRIVACY = 'Privacy';
    /**
     * Constant for value 'IPMA'
     * @return string 'IPMA'
     */
    const VALUE_IPMA = 'IPMA';
    /**
     * Constant for value 'V150 Modem Relay Capable'
     * @return string 'V150 Modem Relay Capable'
     */
    const VALUE_V_150_MODEM_RELAY_CAPABLE = 'V150 Modem Relay Capable';
    /**
     * Constant for value 'Hospitality'
     * @return string 'Hospitality'
     */
    const VALUE_HOSPITALITY = 'Hospitality';
    /**
     * Constant for value 'Max Call Limit'
     * @return string 'Max Call Limit'
     */
    const VALUE_MAX_CALL_LIMIT = 'Max Call Limit';
    /**
     * Constant for value 'Manufacture Installed Certificate(MIC)'
     * @return string 'Manufacture Installed Certificate(MIC)'
     */
    const VALUE_MANUFACTURE_INSTALLED_CERTIFICATE_MIC = 'Manufacture Installed Certificate(MIC)';
    /**
     * Constant for value 'Perfer alternate script'
     * @return string 'Perfer alternate script'
     */
    const VALUE_PERFER_ALTERNATE_SCRIPT = 'Perfer alternate script';
    /**
     * Constant for value 'Key Authority'
     * @return string 'Key Authority'
     */
    const VALUE_KEY_AUTHORITY = 'Key Authority';
    /**
     * Constant for value 'File encrypt'
     * @return string 'File encrypt'
     */
    const VALUE_FILE_ENCRYPT = 'File encrypt';
    /**
     * Constant for value 'Secure RTP'
     * @return string 'Secure RTP'
     */
    const VALUE_SECURE_RTP = 'Secure RTP';
    /**
     * Constant for value 'BLF Speed dial'
     * @return string 'BLF Speed dial'
     */
    const VALUE_BLF_SPEED_DIAL = 'BLF Speed dial';
    /**
     * Constant for value 'URI Dialing'
     * @return string 'URI Dialing'
     */
    const VALUE_URI_DIALING = 'URI Dialing';
    /**
     * Constant for value 'Digest authentication support'
     * @return string 'Digest authentication support'
     */
    const VALUE_DIGEST_AUTHENTICATION_SUPPORT = 'Digest authentication support';
    /**
     * Constant for value 'Support for server-side auth TLS (basic)'
     * @return string 'Support for server-side auth TLS (basic)'
     */
    const VALUE_SUPPORT_FOR_SERVER_SIDE_AUTH_TLS_BASIC = 'Support for server-side auth TLS (basic)';
    /**
     * Constant for value 'Support for Mutual-auth TLS'
     * @return string 'Support for Mutual-auth TLS'
     */
    const VALUE_SUPPORT_FOR_MUTUAL_AUTH_TLS = 'Support for Mutual-auth TLS';
    /**
     * Constant for value 'Support CAPF'
     * @return string 'Support CAPF'
     */
    const VALUE_SUPPORT_CAPF = 'Support CAPF';
    /**
     * Constant for value 'Require DTMF Reception'
     * @return string 'Require DTMF Reception'
     */
    const VALUE_REQUIRE_DTMF_RECEPTION = 'Require DTMF Reception';
    /**
     * Constant for value 'RFC 2833 Disabled'
     * @return string 'RFC 2833 Disabled'
     */
    const VALUE_RFC_2833_DISABLED = 'RFC 2833 Disabled';
    /**
     * Constant for value 'BLF Speed Dial with URI'
     * @return string 'BLF Speed Dial with URI'
     */
    const VALUE_BLF_SPEED_DIAL_WITH_URI = 'BLF Speed Dial with URI';
    /**
     * Constant for value 'Secure Shell Support'
     * @return string 'Secure Shell Support'
     */
    const VALUE_SECURE_SHELL_SUPPORT = 'Secure Shell Support';
    /**
     * Constant for value 'SIP Dial-Plan'
     * @return string 'SIP Dial-Plan'
     */
    const VALUE_SIP_DIAL_PLAN = 'SIP Dial-Plan';
    /**
     * Constant for value 'Specify Types of TFTP Config Files'
     * @return string 'Specify Types of TFTP Config Files'
     */
    const VALUE_SPECIFY_TYPES_OF_TFTP_CONFIG_FILES = 'Specify Types of TFTP Config Files';
    /**
     * Constant for value 'Presence Subscription'
     * @return string 'Presence Subscription'
     */
    const VALUE_PRESENCE_SUBSCRIPTION = 'Presence Subscription';
    /**
     * Constant for value 'SIP TCP Support'
     * @return string 'SIP TCP Support'
     */
    const VALUE_SIP_TCP_SUPPORT = 'SIP TCP Support';
    /**
     * Constant for value 'Feature Safe on Phone Template'
     * @return string 'Feature Safe on Phone Template'
     */
    const VALUE_FEATURE_SAFE_ON_PHONE_TEMPLATE = 'Feature Safe on Phone Template';
    /**
     * Constant for value 'Size Safe on Phone Template'
     * @return string 'Size Safe on Phone Template'
     */
    const VALUE_SIZE_SAFE_ON_PHONE_TEMPLATE = 'Size Safe on Phone Template';
    /**
     * Constant for value 'Hold Reversion'
     * @return string 'Hold Reversion'
     */
    const VALUE_HOLD_REVERSION = 'Hold Reversion';
    /**
     * Constant for value 'Intercom'
     * @return string 'Intercom'
     */
    const VALUE_INTERCOM = 'Intercom';
    /**
     * Constant for value 'Do Not Disturb'
     * @return string 'Do Not Disturb'
     */
    const VALUE_DO_NOT_DISTURB = 'Do Not Disturb';
    /**
     * Constant for value 'Audible Message Waiting Indicator'
     * @return string 'Audible Message Waiting Indicator'
     */
    const VALUE_AUDIBLE_MESSAGE_WAITING_INDICATOR = 'Audible Message Waiting Indicator';
    /**
     * Constant for value 'Digest Password Caching'
     * @return string 'Digest Password Caching'
     */
    const VALUE_DIGEST_PASSWORD_CACHING = 'Digest Password Caching';
    /**
     * Constant for value 'Mobility'
     * @return string 'Mobility'
     */
    const VALUE_MOBILITY = 'Mobility';
    /**
     * Constant for value 'Dual-Mode'
     * @return string 'Dual-Mode'
     */
    const VALUE_DUAL_MODE = 'Dual-Mode';
    /**
     * Constant for value 'Automatic Outbound Call Rollover'
     * @return string 'Automatic Outbound Call Rollover'
     */
    const VALUE_AUTOMATIC_OUTBOUND_CALL_ROLLOVER = 'Automatic Outbound Call Rollover';
    /**
     * Constant for value 'Join Across Lines'
     * @return string 'Join Across Lines'
     */
    const VALUE_JOIN_ACROSS_LINES = 'Join Across Lines';
    /**
     * Constant for value 'Single Button Barge'
     * @return string 'Single Button Barge'
     */
    const VALUE_SINGLE_BUTTON_BARGE = 'Single Button Barge';
    /**
     * Constant for value 'Phone Personalization'
     * @return string 'Phone Personalization'
     */
    const VALUE_PHONE_PERSONALIZATION = 'Phone Personalization';
    /**
     * Constant for value 'Secure Tone'
     * @return string 'Secure Tone'
     */
    const VALUE_SECURE_TONE = 'Secure Tone';
    /**
     * Constant for value '7915 12-Button Line Expansion Module'
     * @return string '7915 12-Button Line Expansion Module'
     */
    const VALUE_7915_12_BUTTON_LINE_EXPANSION_MODULE = '7915 12-Button Line Expansion Module';
    /**
     * Constant for value '7915 24-Button Line Expansion Module'
     * @return string '7915 24-Button Line Expansion Module'
     */
    const VALUE_7915_24_BUTTON_LINE_EXPANSION_MODULE = '7915 24-Button Line Expansion Module';
    /**
     * Constant for value '7916 12-Button Line Expansion Module'
     * @return string '7916 12-Button Line Expansion Module'
     */
    const VALUE_7916_12_BUTTON_LINE_EXPANSION_MODULE = '7916 12-Button Line Expansion Module';
    /**
     * Constant for value '7916 24-Button Line Expansion Module'
     * @return string '7916 24-Button Line Expansion Module'
     */
    const VALUE_7916_24_BUTTON_LINE_EXPANSION_MODULE = '7916 24-Button Line Expansion Module';
    /**
     * Constant for value 'Expansion Module Supports Matrix'
     * @return string 'Expansion Module Supports Matrix'
     */
    const VALUE_EXPANSION_MODULE_SUPPORTS_MATRIX = 'Expansion Module Supports Matrix';
    /**
     * Constant for value 'Enhanced Message Waiting Indicator'
     * @return string 'Enhanced Message Waiting Indicator'
     */
    const VALUE_ENHANCED_MESSAGE_WAITING_INDICATOR = 'Enhanced Message Waiting Indicator';
    /**
     * Constant for value 'Extension Mobility Cross Cluster'
     * @return string 'Extension Mobility Cross Cluster'
     */
    const VALUE_EXTENSION_MOBILITY_CROSS_CLUSTER = 'Extension Mobility Cross Cluster';
    /**
     * Constant for value 'Apply Configuration'
     * @return string 'Apply Configuration'
     */
    const VALUE_APPLY_CONFIGURATION = 'Apply Configuration';
    /**
     * Constant for value 'Assisted Directed Call Park'
     * @return string 'Assisted Directed Call Park'
     */
    const VALUE_ASSISTED_DIRECTED_CALL_PARK = 'Assisted Directed Call Park';
    /**
     * Constant for value 'Multiple Level Vendor Config'
     * @return string 'Multiple Level Vendor Config'
     */
    const VALUE_MULTIPLE_LEVEL_VENDOR_CONFIG = 'Multiple Level Vendor Config';
    /**
     * Constant for value 'Log Missed Calls Option'
     * @return string 'Log Missed Calls Option'
     */
    const VALUE_LOG_MISSED_CALLS_OPTION = 'Log Missed Calls Option';
    /**
     * Constant for value 'Hotline'
     * @return string 'Hotline'
     */
    const VALUE_HOTLINE = 'Hotline';
    /**
     * Constant for value 'Route Class Signaling'
     * @return string 'Route Class Signaling'
     */
    const VALUE_ROUTE_CLASS_SIGNALING = 'Route Class Signaling';
    /**
     * Constant for value 'CKEM 36-Button Line Expansion Module'
     * @return string 'CKEM 36-Button Line Expansion Module'
     */
    const VALUE_CKEM_36_BUTTON_LINE_EXPANSION_MODULE = 'CKEM 36-Button Line Expansion Module';
    /**
     * Constant for value 'Connected Transfer and Conference'
     * @return string 'Connected Transfer and Conference'
     */
    const VALUE_CONNECTED_TRANSFER_AND_CONFERENCE = 'Connected Transfer and Conference';
    /**
     * Constant for value 'Inbound Caller ID on FXO Port'
     * @return string 'Inbound Caller ID on FXO Port'
     */
    const VALUE_INBOUND_CALLER_ID_ON_FXO_PORT = 'Inbound Caller ID on FXO Port';
    /**
     * Constant for value 'Security By Default'
     * @return string 'Security By Default'
     */
    const VALUE_SECURITY_BY_DEFAULT = 'Security By Default';
    /**
     * Constant for value 'Restrict Maximum Call and Busy Trigger'
     * @return string 'Restrict Maximum Call and Busy Trigger'
     */
    const VALUE_RESTRICT_MAXIMUM_CALL_AND_BUSY_TRIGGER = 'Restrict Maximum Call and Busy Trigger';
    /**
     * Constant for value 'Daylight Savings Time Format'
     * @return string 'Daylight Savings Time Format'
     */
    const VALUE_DAYLIGHT_SAVINGS_TIME_FORMAT = 'Daylight Savings Time Format';
    /**
     * Constant for value 'Virtual Private Network Client'
     * @return string 'Virtual Private Network Client'
     */
    const VALUE_VIRTUAL_PRIVATE_NETWORK_CLIENT = 'Virtual Private Network Client';
    /**
     * Constant for value 'G.Clear'
     * @return string 'G.Clear'
     */
    const VALUE_G_CLEAR = 'G.Clear';
    /**
     * Constant for value 'Feature Control Policy'
     * @return string 'Feature Control Policy'
     */
    const VALUE_FEATURE_CONTROL_POLICY = 'Feature Control Policy';
    /**
     * Constant for value 'Trusted Device'
     * @return string 'Trusted Device'
     */
    const VALUE_TRUSTED_DEVICE = 'Trusted Device';
    /**
     * Constant for value 'Dual Banked Firmware'
     * @return string 'Dual Banked Firmware'
     */
    const VALUE_DUAL_BANKED_FIRMWARE = 'Dual Banked Firmware';
    /**
     * Constant for value 'Mandatory Join Across Lines (No Configuration)'
     * @return string 'Mandatory Join Across Lines (No Configuration)'
     */
    const VALUE_MANDATORY_JOIN_ACROSS_LINES_NO_CONFIGURATION = 'Mandatory Join Across Lines (No Configuration)';
    /**
     * Constant for value 'Maximum AuthName Length'
     * @return string 'Maximum AuthName Length'
     */
    const VALUE_MAXIMUM_AUTH_NAME_LENGTH = 'Maximum AuthName Length';
    /**
     * Constant for value 'Send Call to Mobile Support'
     * @return string 'Send Call to Mobile Support'
     */
    const VALUE_SEND_CALL_TO_MOBILE_SUPPORT = 'Send Call to Mobile Support';
    /**
     * Constant for value 'VKEM 36-Button Line Expansion Module'
     * @return string 'VKEM 36-Button Line Expansion Module'
     */
    const VALUE_VKEM_36_BUTTON_LINE_EXPANSION_MODULE = 'VKEM 36-Button Line Expansion Module';
    /**
     * Constant for value 'IMS-integrated Mobile Device'
     * @return string 'IMS-integrated Mobile Device'
     */
    const VALUE_IMS_INTEGRATED_MOBILE_DEVICE = 'IMS-integrated Mobile Device';
    /**
     * Constant for value 'Seamless TCP Reconnect After Connections Drop or Roaming'
     * @return string 'Seamless TCP Reconnect After Connections Drop or Roaming'
     */
    const VALUE_SEAMLESS_TCP_RECONNECT_AFTER_CONNECTIONS_DROP_OR_ROAMING = 'Seamless TCP Reconnect After Connections Drop or Roaming';
    /**
     * Constant for value 'BFCP Support'
     * @return string 'BFCP Support'
     */
    const VALUE_BFCP_SUPPORT = 'BFCP Support';
    /**
     * Constant for value 'SIP Identity Blend'
     * @return string 'SIP Identity Blend'
     */
    const VALUE_SIP_IDENTITY_BLEND = 'SIP Identity Blend';
    /**
     * Constant for value 'Require Off Premise Location'
     * @return string 'Require Off Premise Location'
     */
    const VALUE_REQUIRE_OFF_PREMISE_LOCATION = 'Require Off Premise Location';
    /**
     * Constant for value 'iX Channel Support'
     * @return string 'iX Channel Support'
     */
    const VALUE_I_X_CHANNEL_SUPPORT = 'iX Channel Support';
    /**
     * Constant for value 'Immersive Video Support for TelePresence Devices'
     * @return string 'Immersive Video Support for TelePresence Devices'
     */
    const VALUE_IMMERSIVE_VIDEO_SUPPORT_FOR_TELE_PRESENCE_DEVICES = 'Immersive Video Support for TelePresence Devices';
    /**
     * Constant for value 'Crypto Session Param'
     * @return string 'Crypto Session Param'
     */
    const VALUE_CRYPTO_SESSION_PARAM = 'Crypto Session Param';
    /**
     * Constant for value 'Early Offer Support'
     * @return string 'Early Offer Support'
     */
    const VALUE_EARLY_OFFER_SUPPORT = 'Early Offer Support';
    /**
     * Constant for value 'UC Service Profile Support'
     * @return string 'UC Service Profile Support'
     */
    const VALUE_UC_SERVICE_PROFILE_SUPPORT = 'UC Service Profile Support';
    /**
     * Constant for value 'Call Bubble Collapsing'
     * @return string 'Call Bubble Collapsing'
     */
    const VALUE_CALL_BUBBLE_COLLAPSING = 'Call Bubble Collapsing';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_IP_PHONE_SERVICES
     * @uses self::VALUE_IS_LEGACY_DEVICE
     * @uses self::VALUE_HTTP_SERVER_ENABLED
     * @uses self::VALUE_MUSIC_ON_HOLD
     * @uses self::VALUE_RING_SETTING_ON_THIS_LINE
     * @uses self::VALUE_CALL_WAITING
     * @uses self::VALUE_AUTO_ANSWER
     * @uses self::VALUE_SHARED_LINE_APPEARANCE
     * @uses self::VALUE_EXTENSION_MOBILITY
     * @uses self::VALUE_SHOW_SPEEDDIAL_LABELS
     * @uses self::VALUE_SHOW_FORWARD_ON_FAILURE
     * @uses self::VALUE_HAS_FIRMWARE_LOAD
     * @uses self::VALUE_HAS_PHONE_TEMPLATES
     * @uses self::VALUE_MEDIA_RESOURCE_MANAGED
     * @uses self::VALUE_CTI_CONTROLLED
     * @uses self::VALUE_PHONE_TEMPLATE_IS_USER_MODIFIABLE
     * @uses self::VALUE_LOCALIZATION
     * @uses self::VALUE_HAS_SOFTKEY_TEMPLATE
     * @uses self::VALUE_SUPPORTS_DIFFERENT_PORT_TYPES_FOR_FXO_MODULE
     * @uses self::VALUE_PHONE_ATTACHED_TO_A_GATEWAY_LIKE_CHALICE
     * @uses self::VALUE_AUTOMATED_ALTERNATE_ROUTING_AAR
     * @uses self::VALUE_NETWORK_HOLD
     * @uses self::VALUE_USER_HOLD
     * @uses self::VALUE_MONITOR
     * @uses self::VALUE_RECORD
     * @uses self::VALUE_AUTO_REGISTRATION
     * @uses self::VALUE_USE_GENERIC_ICON
     * @uses self::VALUE_MWL_POLICY
     * @uses self::VALUE_LINE_TEXT_LABEL
     * @uses self::VALUE_MULTIPLE_CALL_DISPLAY
     * @uses self::VALUE_ABBREVIATED_DIAL
     * @uses self::VALUE_BUILT_IN_BRIDGE
     * @uses self::VALUE_MALICIOUS_CALL_IDENTIFICATION
     * @uses self::VALUE_CALL_PRECEDENCE_FOR_MLPP
     * @uses self::VALUE_CALL_PRE_EMPTION_FOR_MLPP
     * @uses self::VALUE_STATUS_REPORT_BUSY_DEVICE_INDICATOR
     * @uses self::VALUE_VIDEO
     * @uses self::VALUE_SECURITY_AUTHENTICATION
     * @uses self::VALUE_SECURITY_ENCRYPTION
     * @uses self::VALUE_ONLINE_USER_GUIDE_HTML_OR_PDF
     * @uses self::VALUE_GATEWAY_SUPPORTS_SUMMIT_MTP
     * @uses self::VALUE_EXPANSION_MODULE
     * @uses self::VALUE_PRIVACY
     * @uses self::VALUE_IPMA
     * @uses self::VALUE_V_150_MODEM_RELAY_CAPABLE
     * @uses self::VALUE_HOSPITALITY
     * @uses self::VALUE_MAX_CALL_LIMIT
     * @uses self::VALUE_MANUFACTURE_INSTALLED_CERTIFICATE_MIC
     * @uses self::VALUE_PERFER_ALTERNATE_SCRIPT
     * @uses self::VALUE_KEY_AUTHORITY
     * @uses self::VALUE_FILE_ENCRYPT
     * @uses self::VALUE_SECURE_RTP
     * @uses self::VALUE_BLF_SPEED_DIAL
     * @uses self::VALUE_URI_DIALING
     * @uses self::VALUE_DIGEST_AUTHENTICATION_SUPPORT
     * @uses self::VALUE_SUPPORT_FOR_SERVER_SIDE_AUTH_TLS_BASIC
     * @uses self::VALUE_SUPPORT_FOR_MUTUAL_AUTH_TLS
     * @uses self::VALUE_SUPPORT_CAPF
     * @uses self::VALUE_REQUIRE_DTMF_RECEPTION
     * @uses self::VALUE_RFC_2833_DISABLED
     * @uses self::VALUE_BLF_SPEED_DIAL_WITH_URI
     * @uses self::VALUE_SECURE_SHELL_SUPPORT
     * @uses self::VALUE_SIP_DIAL_PLAN
     * @uses self::VALUE_SPECIFY_TYPES_OF_TFTP_CONFIG_FILES
     * @uses self::VALUE_PRESENCE_SUBSCRIPTION
     * @uses self::VALUE_SIP_TCP_SUPPORT
     * @uses self::VALUE_FEATURE_SAFE_ON_PHONE_TEMPLATE
     * @uses self::VALUE_SIZE_SAFE_ON_PHONE_TEMPLATE
     * @uses self::VALUE_HOLD_REVERSION
     * @uses self::VALUE_INTERCOM
     * @uses self::VALUE_DO_NOT_DISTURB
     * @uses self::VALUE_AUDIBLE_MESSAGE_WAITING_INDICATOR
     * @uses self::VALUE_DIGEST_PASSWORD_CACHING
     * @uses self::VALUE_MOBILITY
     * @uses self::VALUE_DUAL_MODE
     * @uses self::VALUE_AUTOMATIC_OUTBOUND_CALL_ROLLOVER
     * @uses self::VALUE_JOIN_ACROSS_LINES
     * @uses self::VALUE_SINGLE_BUTTON_BARGE
     * @uses self::VALUE_PHONE_PERSONALIZATION
     * @uses self::VALUE_SECURE_TONE
     * @uses self::VALUE_7915_12_BUTTON_LINE_EXPANSION_MODULE
     * @uses self::VALUE_7915_24_BUTTON_LINE_EXPANSION_MODULE
     * @uses self::VALUE_7916_12_BUTTON_LINE_EXPANSION_MODULE
     * @uses self::VALUE_7916_24_BUTTON_LINE_EXPANSION_MODULE
     * @uses self::VALUE_EXPANSION_MODULE_SUPPORTS_MATRIX
     * @uses self::VALUE_ENHANCED_MESSAGE_WAITING_INDICATOR
     * @uses self::VALUE_EXTENSION_MOBILITY_CROSS_CLUSTER
     * @uses self::VALUE_APPLY_CONFIGURATION
     * @uses self::VALUE_ASSISTED_DIRECTED_CALL_PARK
     * @uses self::VALUE_MULTIPLE_LEVEL_VENDOR_CONFIG
     * @uses self::VALUE_LOG_MISSED_CALLS_OPTION
     * @uses self::VALUE_HOTLINE
     * @uses self::VALUE_ROUTE_CLASS_SIGNALING
     * @uses self::VALUE_CKEM_36_BUTTON_LINE_EXPANSION_MODULE
     * @uses self::VALUE_CONNECTED_TRANSFER_AND_CONFERENCE
     * @uses self::VALUE_INBOUND_CALLER_ID_ON_FXO_PORT
     * @uses self::VALUE_SECURITY_BY_DEFAULT
     * @uses self::VALUE_RESTRICT_MAXIMUM_CALL_AND_BUSY_TRIGGER
     * @uses self::VALUE_DAYLIGHT_SAVINGS_TIME_FORMAT
     * @uses self::VALUE_VIRTUAL_PRIVATE_NETWORK_CLIENT
     * @uses self::VALUE_G_CLEAR
     * @uses self::VALUE_FEATURE_CONTROL_POLICY
     * @uses self::VALUE_TRUSTED_DEVICE
     * @uses self::VALUE_DUAL_BANKED_FIRMWARE
     * @uses self::VALUE_MANDATORY_JOIN_ACROSS_LINES_NO_CONFIGURATION
     * @uses self::VALUE_MAXIMUM_AUTH_NAME_LENGTH
     * @uses self::VALUE_SEND_CALL_TO_MOBILE_SUPPORT
     * @uses self::VALUE_VKEM_36_BUTTON_LINE_EXPANSION_MODULE
     * @uses self::VALUE_IMS_INTEGRATED_MOBILE_DEVICE
     * @uses self::VALUE_SEAMLESS_TCP_RECONNECT_AFTER_CONNECTIONS_DROP_OR_ROAMING
     * @uses self::VALUE_BFCP_SUPPORT
     * @uses self::VALUE_SIP_IDENTITY_BLEND
     * @uses self::VALUE_REQUIRE_OFF_PREMISE_LOCATION
     * @uses self::VALUE_I_X_CHANNEL_SUPPORT
     * @uses self::VALUE_IMMERSIVE_VIDEO_SUPPORT_FOR_TELE_PRESENCE_DEVICES
     * @uses self::VALUE_CRYPTO_SESSION_PARAM
     * @uses self::VALUE_EARLY_OFFER_SUPPORT
     * @uses self::VALUE_UC_SERVICE_PROFILE_SUPPORT
     * @uses self::VALUE_CALL_BUBBLE_COLLAPSING
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_IP_PHONE_SERVICES,
            self::VALUE_IS_LEGACY_DEVICE,
            self::VALUE_HTTP_SERVER_ENABLED,
            self::VALUE_MUSIC_ON_HOLD,
            self::VALUE_RING_SETTING_ON_THIS_LINE,
            self::VALUE_CALL_WAITING,
            self::VALUE_AUTO_ANSWER,
            self::VALUE_SHARED_LINE_APPEARANCE,
            self::VALUE_EXTENSION_MOBILITY,
            self::VALUE_SHOW_SPEEDDIAL_LABELS,
            self::VALUE_SHOW_FORWARD_ON_FAILURE,
            self::VALUE_HAS_FIRMWARE_LOAD,
            self::VALUE_HAS_PHONE_TEMPLATES,
            self::VALUE_MEDIA_RESOURCE_MANAGED,
            self::VALUE_CTI_CONTROLLED,
            self::VALUE_PHONE_TEMPLATE_IS_USER_MODIFIABLE,
            self::VALUE_LOCALIZATION,
            self::VALUE_HAS_SOFTKEY_TEMPLATE,
            self::VALUE_SUPPORTS_DIFFERENT_PORT_TYPES_FOR_FXO_MODULE,
            self::VALUE_PHONE_ATTACHED_TO_A_GATEWAY_LIKE_CHALICE,
            self::VALUE_AUTOMATED_ALTERNATE_ROUTING_AAR,
            self::VALUE_NETWORK_HOLD,
            self::VALUE_USER_HOLD,
            self::VALUE_MONITOR,
            self::VALUE_RECORD,
            self::VALUE_AUTO_REGISTRATION,
            self::VALUE_USE_GENERIC_ICON,
            self::VALUE_MWL_POLICY,
            self::VALUE_LINE_TEXT_LABEL,
            self::VALUE_MULTIPLE_CALL_DISPLAY,
            self::VALUE_ABBREVIATED_DIAL,
            self::VALUE_BUILT_IN_BRIDGE,
            self::VALUE_MALICIOUS_CALL_IDENTIFICATION,
            self::VALUE_CALL_PRECEDENCE_FOR_MLPP,
            self::VALUE_CALL_PRE_EMPTION_FOR_MLPP,
            self::VALUE_STATUS_REPORT_BUSY_DEVICE_INDICATOR,
            self::VALUE_VIDEO,
            self::VALUE_SECURITY_AUTHENTICATION,
            self::VALUE_SECURITY_ENCRYPTION,
            self::VALUE_ONLINE_USER_GUIDE_HTML_OR_PDF,
            self::VALUE_GATEWAY_SUPPORTS_SUMMIT_MTP,
            self::VALUE_EXPANSION_MODULE,
            self::VALUE_PRIVACY,
            self::VALUE_IPMA,
            self::VALUE_V_150_MODEM_RELAY_CAPABLE,
            self::VALUE_HOSPITALITY,
            self::VALUE_MAX_CALL_LIMIT,
            self::VALUE_MANUFACTURE_INSTALLED_CERTIFICATE_MIC,
            self::VALUE_PERFER_ALTERNATE_SCRIPT,
            self::VALUE_KEY_AUTHORITY,
            self::VALUE_FILE_ENCRYPT,
            self::VALUE_SECURE_RTP,
            self::VALUE_BLF_SPEED_DIAL,
            self::VALUE_URI_DIALING,
            self::VALUE_DIGEST_AUTHENTICATION_SUPPORT,
            self::VALUE_SUPPORT_FOR_SERVER_SIDE_AUTH_TLS_BASIC,
            self::VALUE_SUPPORT_FOR_MUTUAL_AUTH_TLS,
            self::VALUE_SUPPORT_CAPF,
            self::VALUE_REQUIRE_DTMF_RECEPTION,
            self::VALUE_RFC_2833_DISABLED,
            self::VALUE_BLF_SPEED_DIAL_WITH_URI,
            self::VALUE_SECURE_SHELL_SUPPORT,
            self::VALUE_SIP_DIAL_PLAN,
            self::VALUE_SPECIFY_TYPES_OF_TFTP_CONFIG_FILES,
            self::VALUE_PRESENCE_SUBSCRIPTION,
            self::VALUE_SIP_TCP_SUPPORT,
            self::VALUE_FEATURE_SAFE_ON_PHONE_TEMPLATE,
            self::VALUE_SIZE_SAFE_ON_PHONE_TEMPLATE,
            self::VALUE_HOLD_REVERSION,
            self::VALUE_INTERCOM,
            self::VALUE_DO_NOT_DISTURB,
            self::VALUE_AUDIBLE_MESSAGE_WAITING_INDICATOR,
            self::VALUE_DIGEST_PASSWORD_CACHING,
            self::VALUE_MOBILITY,
            self::VALUE_DUAL_MODE,
            self::VALUE_AUTOMATIC_OUTBOUND_CALL_ROLLOVER,
            self::VALUE_JOIN_ACROSS_LINES,
            self::VALUE_SINGLE_BUTTON_BARGE,
            self::VALUE_PHONE_PERSONALIZATION,
            self::VALUE_SECURE_TONE,
            self::VALUE_7915_12_BUTTON_LINE_EXPANSION_MODULE,
            self::VALUE_7915_24_BUTTON_LINE_EXPANSION_MODULE,
            self::VALUE_7916_12_BUTTON_LINE_EXPANSION_MODULE,
            self::VALUE_7916_24_BUTTON_LINE_EXPANSION_MODULE,
            self::VALUE_EXPANSION_MODULE_SUPPORTS_MATRIX,
            self::VALUE_ENHANCED_MESSAGE_WAITING_INDICATOR,
            self::VALUE_EXTENSION_MOBILITY_CROSS_CLUSTER,
            self::VALUE_APPLY_CONFIGURATION,
            self::VALUE_ASSISTED_DIRECTED_CALL_PARK,
            self::VALUE_MULTIPLE_LEVEL_VENDOR_CONFIG,
            self::VALUE_LOG_MISSED_CALLS_OPTION,
            self::VALUE_HOTLINE,
            self::VALUE_ROUTE_CLASS_SIGNALING,
            self::VALUE_CKEM_36_BUTTON_LINE_EXPANSION_MODULE,
            self::VALUE_CONNECTED_TRANSFER_AND_CONFERENCE,
            self::VALUE_INBOUND_CALLER_ID_ON_FXO_PORT,
            self::VALUE_SECURITY_BY_DEFAULT,
            self::VALUE_RESTRICT_MAXIMUM_CALL_AND_BUSY_TRIGGER,
            self::VALUE_DAYLIGHT_SAVINGS_TIME_FORMAT,
            self::VALUE_VIRTUAL_PRIVATE_NETWORK_CLIENT,
            self::VALUE_G_CLEAR,
            self::VALUE_FEATURE_CONTROL_POLICY,
            self::VALUE_TRUSTED_DEVICE,
            self::VALUE_DUAL_BANKED_FIRMWARE,
            self::VALUE_MANDATORY_JOIN_ACROSS_LINES_NO_CONFIGURATION,
            self::VALUE_MAXIMUM_AUTH_NAME_LENGTH,
            self::VALUE_SEND_CALL_TO_MOBILE_SUPPORT,
            self::VALUE_VKEM_36_BUTTON_LINE_EXPANSION_MODULE,
            self::VALUE_IMS_INTEGRATED_MOBILE_DEVICE,
            self::VALUE_SEAMLESS_TCP_RECONNECT_AFTER_CONNECTIONS_DROP_OR_ROAMING,
            self::VALUE_BFCP_SUPPORT,
            self::VALUE_SIP_IDENTITY_BLEND,
            self::VALUE_REQUIRE_OFF_PREMISE_LOCATION,
            self::VALUE_I_X_CHANNEL_SUPPORT,
            self::VALUE_IMMERSIVE_VIDEO_SUPPORT_FOR_TELE_PRESENCE_DEVICES,
            self::VALUE_CRYPTO_SESSION_PARAM,
            self::VALUE_EARLY_OFFER_SUPPORT,
            self::VALUE_UC_SERVICE_PROFILE_SUPPORT,
            self::VALUE_CALL_BUBBLE_COLLAPSING,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
