<?php
/**
 * This class stands for XSubPatternUsage EnumType
 * @subpackage Enumerations
 */
class XSubPatternUsage
{
    /**
     * Constant for value 'None'
     * @return string 'None'
     */
    const VALUE_NONE = 'None';
    /**
     * Constant for value 'System Block'
     * @return string 'System Block'
     */
    const VALUE_SYSTEM_BLOCK = 'System Block';
    /**
     * Constant for value 'System Abbreviate'
     * @return string 'System Abbreviate'
     */
    const VALUE_SYSTEM_ABBREVIATE = 'System Abbreviate';
    /**
     * Constant for value 'Country Dial Plan'
     * @return string 'Country Dial Plan'
     */
    const VALUE_COUNTRY_DIAL_PLAN = 'Country Dial Plan';
    /**
     * Constant for value 'Emergency'
     * @return string 'Emergency'
     */
    const VALUE_EMERGENCY = 'Emergency';
    /**
     * Constant for value 'User Translation'
     * @return string 'User Translation'
     */
    const VALUE_USER_TRANSLATION = 'User Translation';
    /**
     * Constant for value 'Feature Block'
     * @return string 'Feature Block'
     */
    const VALUE_FEATURE_BLOCK = 'Feature Block';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NONE
     * @uses self::VALUE_SYSTEM_BLOCK
     * @uses self::VALUE_SYSTEM_ABBREVIATE
     * @uses self::VALUE_COUNTRY_DIAL_PLAN
     * @uses self::VALUE_EMERGENCY
     * @uses self::VALUE_USER_TRANSLATION
     * @uses self::VALUE_FEATURE_BLOCK
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NONE,
            self::VALUE_SYSTEM_BLOCK,
            self::VALUE_SYSTEM_ABBREVIATE,
            self::VALUE_COUNTRY_DIAL_PLAN,
            self::VALUE_EMERGENCY,
            self::VALUE_USER_TRANSLATION,
            self::VALUE_FEATURE_BLOCK,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
