<?php
/**
 * This class stands for XSIPCodec EnumType
 * @subpackage Enumerations
 */
class XSIPCodec
{
    /**
     * Constant for value '711ulaw'
     * @return string '711ulaw'
     */
    const VALUE_711_ULAW = '711ulaw';
    /**
     * Constant for value '711alaw'
     * @return string '711alaw'
     */
    const VALUE_711_ALAW = '711alaw';
    /**
     * Constant for value 'G729/G729a'
     * @return string 'G729/G729a'
     */
    const VALUE_G_729_G_729_A = 'G729/G729a';
    /**
     * Constant for value 'G729b/G729ab'
     * @return string 'G729b/G729ab'
     */
    const VALUE_G_729_B_G_729_AB = 'G729b/G729ab';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_711_ULAW
     * @uses self::VALUE_711_ALAW
     * @uses self::VALUE_G_729_G_729_A
     * @uses self::VALUE_G_729_B_G_729_AB
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_711_ULAW,
            self::VALUE_711_ALAW,
            self::VALUE_G_729_G_729_A,
            self::VALUE_G_729_B_G_729_AB,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
