<?php
/**
 * This class stands for XSCHCiscoTACDestination EnumType
 * @subpackage Enumerations
 */
class XSCHCiscoTACDestination
{
    /**
     * Constant for value 'Secure Web (HTTPS)'
     * @return string 'Secure Web (HTTPS)'
     */
    const VALUE_SECURE_WEB_HTTPS = 'Secure Web (HTTPS)';
    /**
     * Constant for value 'Email'
     * @return string 'Email'
     */
    const VALUE_EMAIL = 'Email';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_SECURE_WEB_HTTPS
     * @uses self::VALUE_EMAIL
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_SECURE_WEB_HTTPS,
            self::VALUE_EMAIL,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
