<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XRoutePattern StructType
 * @subpackage Structs
 */
class XRoutePattern extends AbstractStructBase
{
    /**
     * The pattern
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $pattern;
    /**
     * The routePartitionName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var XFkType
     */
    public $routePartitionName;
    /**
     * The blockEnable
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $blockEnable;
    /**
     * The useCallingPartyPhoneMask
     * Meta informations extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $useCallingPartyPhoneMask;
    /**
     * The dialPlanName
     * Meta informations extracted from the WSDL
     * - documentation: dialPlan is mandatory for patterns with @ in it.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var XFkType
     */
    public $dialPlanName;
    /**
     * The digitDiscardInstructionName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var XFkType
     */
    public $digitDiscardInstructionName;
    /**
     * The networkLocation
     * Meta informations extracted from the WSDL
     * - default: OnNet
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $networkLocation;
    /**
     * The prefixDigitsOut
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $prefixDigitsOut;
    /**
     * The routeFilterName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var XFkType
     */
    public $routeFilterName;
    /**
     * The destination
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var Destination
     */
    public $destination;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The calledPartyTransformationMask
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $calledPartyTransformationMask;
    /**
     * The callingPartyTransformationMask
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $callingPartyTransformationMask;
    /**
     * The callingPartyPrefixDigits
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 50
     * @var string
     */
    public $callingPartyPrefixDigits;
    /**
     * The patternUrgency
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $patternUrgency;
    /**
     * The callingLinePresentationBit
     * Meta informations extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $callingLinePresentationBit;
    /**
     * The callingNamePresentationBit
     * Meta informations extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $callingNamePresentationBit;
    /**
     * The connectedLinePresentationBit
     * Meta informations extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $connectedLinePresentationBit;
    /**
     * The connectedNamePresentationBit
     * Meta informations extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $connectedNamePresentationBit;
    /**
     * The supportOverlapSending
     * Meta informations extracted from the WSDL
     * - documentation: This tag is not valid for a translation pattern.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $supportOverlapSending;
    /**
     * The patternPrecedence
     * Meta informations extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $patternPrecedence;
    /**
     * The releaseClause
     * Meta informations extracted from the WSDL
     * - default: No Error
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $releaseClause;
    /**
     * The allowDeviceOverride
     * Meta informations extracted from the WSDL
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $allowDeviceOverride;
    /**
     * The provideOutsideDialtone
     * Meta informations extracted from the WSDL
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $provideOutsideDialtone;
    /**
     * The callingPartyNumberingPlan
     * Meta informations extracted from the WSDL
     * - default: Cisco CallManager
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $callingPartyNumberingPlan;
    /**
     * The callingPartyNumberType
     * Meta informations extracted from the WSDL
     * - default: Cisco CallManager
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $callingPartyNumberType;
    /**
     * The calledPartyNumberingPlan
     * Meta informations extracted from the WSDL
     * - default: Cisco CallManager
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $calledPartyNumberingPlan;
    /**
     * The calledPartyNumberType
     * Meta informations extracted from the WSDL
     * - default: Cisco CallManager
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $calledPartyNumberType;
    /**
     * The authorizationCodeRequired
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $authorizationCodeRequired;
    /**
     * The authorizationLevelRequired
     * Meta informations extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $authorizationLevelRequired;
    /**
     * The clientCodeRequired
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $clientCodeRequired;
    /**
     * The isdnNsfInfoElement
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var IsdnNsfInfoElement
     */
    public $isdnNsfInfoElement;
    /**
     * The resourcePriorityNamespaceName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $resourcePriorityNamespaceName;
    /**
     * The routeClass
     * Meta informations extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $routeClass;
    /**
     * The enableDccEnforcement
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enableDccEnforcement;
    /**
     * The blockedCallPercentage
     * Meta informations extracted from the WSDL
     * - documentation: This tag is only valid when value of enabledccenforcement is true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $blockedCallPercentage;
    /**
     * Constructor method for XRoutePattern
     * @uses XRoutePattern::setPattern()
     * @uses XRoutePattern::setRoutePartitionName()
     * @uses XRoutePattern::setBlockEnable()
     * @uses XRoutePattern::setUseCallingPartyPhoneMask()
     * @uses XRoutePattern::setDialPlanName()
     * @uses XRoutePattern::setDigitDiscardInstructionName()
     * @uses XRoutePattern::setNetworkLocation()
     * @uses XRoutePattern::setPrefixDigitsOut()
     * @uses XRoutePattern::setRouteFilterName()
     * @uses XRoutePattern::setDestination()
     * @uses XRoutePattern::setDescription()
     * @uses XRoutePattern::setCalledPartyTransformationMask()
     * @uses XRoutePattern::setCallingPartyTransformationMask()
     * @uses XRoutePattern::setCallingPartyPrefixDigits()
     * @uses XRoutePattern::setPatternUrgency()
     * @uses XRoutePattern::setCallingLinePresentationBit()
     * @uses XRoutePattern::setCallingNamePresentationBit()
     * @uses XRoutePattern::setConnectedLinePresentationBit()
     * @uses XRoutePattern::setConnectedNamePresentationBit()
     * @uses XRoutePattern::setSupportOverlapSending()
     * @uses XRoutePattern::setPatternPrecedence()
     * @uses XRoutePattern::setReleaseClause()
     * @uses XRoutePattern::setAllowDeviceOverride()
     * @uses XRoutePattern::setProvideOutsideDialtone()
     * @uses XRoutePattern::setCallingPartyNumberingPlan()
     * @uses XRoutePattern::setCallingPartyNumberType()
     * @uses XRoutePattern::setCalledPartyNumberingPlan()
     * @uses XRoutePattern::setCalledPartyNumberType()
     * @uses XRoutePattern::setAuthorizationCodeRequired()
     * @uses XRoutePattern::setAuthorizationLevelRequired()
     * @uses XRoutePattern::setClientCodeRequired()
     * @uses XRoutePattern::setIsdnNsfInfoElement()
     * @uses XRoutePattern::setResourcePriorityNamespaceName()
     * @uses XRoutePattern::setRouteClass()
     * @uses XRoutePattern::setEnableDccEnforcement()
     * @uses XRoutePattern::setBlockedCallPercentage()
     * @param string $pattern
     * @param XFkType $routePartitionName
     * @param string $blockEnable
     * @param string $useCallingPartyPhoneMask
     * @param XFkType $dialPlanName
     * @param XFkType $digitDiscardInstructionName
     * @param string $networkLocation
     * @param string $prefixDigitsOut
     * @param XFkType $routeFilterName
     * @param Destination $destination
     * @param string $description
     * @param string $calledPartyTransformationMask
     * @param string $callingPartyTransformationMask
     * @param string $callingPartyPrefixDigits
     * @param string $patternUrgency
     * @param string $callingLinePresentationBit
     * @param string $callingNamePresentationBit
     * @param string $connectedLinePresentationBit
     * @param string $connectedNamePresentationBit
     * @param string $supportOverlapSending
     * @param string $patternPrecedence
     * @param string $releaseClause
     * @param string $allowDeviceOverride
     * @param string $provideOutsideDialtone
     * @param string $callingPartyNumberingPlan
     * @param string $callingPartyNumberType
     * @param string $calledPartyNumberingPlan
     * @param string $calledPartyNumberType
     * @param string $authorizationCodeRequired
     * @param string $authorizationLevelRequired
     * @param string $clientCodeRequired
     * @param IsdnNsfInfoElement $isdnNsfInfoElement
     * @param XFkType $resourcePriorityNamespaceName
     * @param string $routeClass
     * @param string $enableDccEnforcement
     * @param string $blockedCallPercentage
     */
    public function __construct($pattern = null, XFkType $routePartitionName = null, $blockEnable = null, $useCallingPartyPhoneMask = 'Default', XFkType $dialPlanName = null, XFkType $digitDiscardInstructionName = null, $networkLocation = 'OnNet', $prefixDigitsOut = null, XFkType $routeFilterName = null, Destination $destination = null, $description = null, $calledPartyTransformationMask = null, $callingPartyTransformationMask = null, $callingPartyPrefixDigits = null, $patternUrgency = null, $callingLinePresentationBit = 'Default', $callingNamePresentationBit = 'Default', $connectedLinePresentationBit = 'Default', $connectedNamePresentationBit = 'Default', $supportOverlapSending = null, $patternPrecedence = 'Default', $releaseClause = 'No Error', $allowDeviceOverride = true, $provideOutsideDialtone = true, $callingPartyNumberingPlan = 'Cisco CallManager', $callingPartyNumberType = 'Cisco CallManager', $calledPartyNumberingPlan = 'Cisco CallManager', $calledPartyNumberType = 'Cisco CallManager', $authorizationCodeRequired = null, $authorizationLevelRequired = '0', $clientCodeRequired = null, IsdnNsfInfoElement $isdnNsfInfoElement = null, XFkType $resourcePriorityNamespaceName = null, $routeClass = 'Default', $enableDccEnforcement = null, $blockedCallPercentage = null)
    {
        $this
            ->setPattern($pattern)
            ->setRoutePartitionName($routePartitionName)
            ->setBlockEnable($blockEnable)
            ->setUseCallingPartyPhoneMask($useCallingPartyPhoneMask)
            ->setDialPlanName($dialPlanName)
            ->setDigitDiscardInstructionName($digitDiscardInstructionName)
            ->setNetworkLocation($networkLocation)
            ->setPrefixDigitsOut($prefixDigitsOut)
            ->setRouteFilterName($routeFilterName)
            ->setDestination($destination)
            ->setDescription($description)
            ->setCalledPartyTransformationMask($calledPartyTransformationMask)
            ->setCallingPartyTransformationMask($callingPartyTransformationMask)
            ->setCallingPartyPrefixDigits($callingPartyPrefixDigits)
            ->setPatternUrgency($patternUrgency)
            ->setCallingLinePresentationBit($callingLinePresentationBit)
            ->setCallingNamePresentationBit($callingNamePresentationBit)
            ->setConnectedLinePresentationBit($connectedLinePresentationBit)
            ->setConnectedNamePresentationBit($connectedNamePresentationBit)
            ->setSupportOverlapSending($supportOverlapSending)
            ->setPatternPrecedence($patternPrecedence)
            ->setReleaseClause($releaseClause)
            ->setAllowDeviceOverride($allowDeviceOverride)
            ->setProvideOutsideDialtone($provideOutsideDialtone)
            ->setCallingPartyNumberingPlan($callingPartyNumberingPlan)
            ->setCallingPartyNumberType($callingPartyNumberType)
            ->setCalledPartyNumberingPlan($calledPartyNumberingPlan)
            ->setCalledPartyNumberType($calledPartyNumberType)
            ->setAuthorizationCodeRequired($authorizationCodeRequired)
            ->setAuthorizationLevelRequired($authorizationLevelRequired)
            ->setClientCodeRequired($clientCodeRequired)
            ->setIsdnNsfInfoElement($isdnNsfInfoElement)
            ->setResourcePriorityNamespaceName($resourcePriorityNamespaceName)
            ->setRouteClass($routeClass)
            ->setEnableDccEnforcement($enableDccEnforcement)
            ->setBlockedCallPercentage($blockedCallPercentage);
    }
    /**
     * Get pattern value
     * @return string
     */
    public function getPattern()
    {
        return $this->pattern;
    }
    /**
     * Set pattern value
     * @param string $pattern
     * @return XRoutePattern
     */
    public function setPattern($pattern = null)
    {
        // validation for constraint: string
        if (!is_null($pattern) && !is_string($pattern)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pattern)), __LINE__);
        }
        $this->pattern = $pattern;
        return $this;
    }
    /**
     * Get routePartitionName value
     * @return XFkType
     */
    public function getRoutePartitionName()
    {
        return $this->routePartitionName;
    }
    /**
     * Set routePartitionName value
     * @param XFkType $routePartitionName
     * @return XRoutePattern
     */
    public function setRoutePartitionName(XFkType $routePartitionName = null)
    {
        $this->routePartitionName = $routePartitionName;
        return $this;
    }
    /**
     * Get blockEnable value
     * @return string
     */
    public function getBlockEnable()
    {
        return $this->blockEnable;
    }
    /**
     * Set blockEnable value
     * @param string $blockEnable
     * @return XRoutePattern
     */
    public function setBlockEnable($blockEnable = null)
    {
        // validation for constraint: pattern
        if (is_scalar($blockEnable) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $blockEnable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($blockEnable, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($blockEnable) && !is_string($blockEnable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($blockEnable)), __LINE__);
        }
        $this->blockEnable = $blockEnable;
        return $this;
    }
    /**
     * Get useCallingPartyPhoneMask value
     * @return string
     */
    public function getUseCallingPartyPhoneMask()
    {
        return $this->useCallingPartyPhoneMask;
    }
    /**
     * Set useCallingPartyPhoneMask value
     * @uses XStatus::valueIsValid()
     * @uses XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $useCallingPartyPhoneMask
     * @return XRoutePattern
     */
    public function setUseCallingPartyPhoneMask($useCallingPartyPhoneMask = 'Default')
    {
        // validation for constraint: enumeration
        if (!XStatus::valueIsValid($useCallingPartyPhoneMask)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $useCallingPartyPhoneMask, implode(', ', XStatus::getValidValues())), __LINE__);
        }
        $this->useCallingPartyPhoneMask = $useCallingPartyPhoneMask;
        return $this;
    }
    /**
     * Get dialPlanName value
     * @return XFkType
     */
    public function getDialPlanName()
    {
        return $this->dialPlanName;
    }
    /**
     * Set dialPlanName value
     * @param XFkType $dialPlanName
     * @return XRoutePattern
     */
    public function setDialPlanName(XFkType $dialPlanName = null)
    {
        $this->dialPlanName = $dialPlanName;
        return $this;
    }
    /**
     * Get digitDiscardInstructionName value
     * @return XFkType
     */
    public function getDigitDiscardInstructionName()
    {
        return $this->digitDiscardInstructionName;
    }
    /**
     * Set digitDiscardInstructionName value
     * @param XFkType $digitDiscardInstructionName
     * @return XRoutePattern
     */
    public function setDigitDiscardInstructionName(XFkType $digitDiscardInstructionName = null)
    {
        $this->digitDiscardInstructionName = $digitDiscardInstructionName;
        return $this;
    }
    /**
     * Get networkLocation value
     * @return string
     */
    public function getNetworkLocation()
    {
        return $this->networkLocation;
    }
    /**
     * Set networkLocation value
     * @uses XNetworkLocation::valueIsValid()
     * @uses XNetworkLocation::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $networkLocation
     * @return XRoutePattern
     */
    public function setNetworkLocation($networkLocation = 'OnNet')
    {
        // validation for constraint: enumeration
        if (!XNetworkLocation::valueIsValid($networkLocation)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $networkLocation, implode(', ', XNetworkLocation::getValidValues())), __LINE__);
        }
        $this->networkLocation = $networkLocation;
        return $this;
    }
    /**
     * Get prefixDigitsOut value
     * @return string
     */
    public function getPrefixDigitsOut()
    {
        return $this->prefixDigitsOut;
    }
    /**
     * Set prefixDigitsOut value
     * @param string $prefixDigitsOut
     * @return XRoutePattern
     */
    public function setPrefixDigitsOut($prefixDigitsOut = null)
    {
        // validation for constraint: string
        if (!is_null($prefixDigitsOut) && !is_string($prefixDigitsOut)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($prefixDigitsOut)), __LINE__);
        }
        $this->prefixDigitsOut = $prefixDigitsOut;
        return $this;
    }
    /**
     * Get routeFilterName value
     * @return XFkType
     */
    public function getRouteFilterName()
    {
        return $this->routeFilterName;
    }
    /**
     * Set routeFilterName value
     * @param XFkType $routeFilterName
     * @return XRoutePattern
     */
    public function setRouteFilterName(XFkType $routeFilterName = null)
    {
        $this->routeFilterName = $routeFilterName;
        return $this;
    }
    /**
     * Get destination value
     * @return Destination
     */
    public function getDestination()
    {
        return $this->destination;
    }
    /**
     * Set destination value
     * @param Destination $destination
     * @return XRoutePattern
     */
    public function setDestination(Destination $destination = null)
    {
        $this->destination = $destination;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return XRoutePattern
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get calledPartyTransformationMask value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCalledPartyTransformationMask()
    {
        return isset($this->calledPartyTransformationMask) ? $this->calledPartyTransformationMask : null;
    }
    /**
     * Set calledPartyTransformationMask value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $calledPartyTransformationMask
     * @return XRoutePattern
     */
    public function setCalledPartyTransformationMask($calledPartyTransformationMask = null)
    {
        // validation for constraint: string
        if (!is_null($calledPartyTransformationMask) && !is_string($calledPartyTransformationMask)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($calledPartyTransformationMask)), __LINE__);
        }
        if (is_null($calledPartyTransformationMask) || (is_array($calledPartyTransformationMask) && empty($calledPartyTransformationMask))) {
            unset($this->calledPartyTransformationMask);
        } else {
            $this->calledPartyTransformationMask = $calledPartyTransformationMask;
        }
        return $this;
    }
    /**
     * Get callingPartyTransformationMask value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCallingPartyTransformationMask()
    {
        return isset($this->callingPartyTransformationMask) ? $this->callingPartyTransformationMask : null;
    }
    /**
     * Set callingPartyTransformationMask value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $callingPartyTransformationMask
     * @return XRoutePattern
     */
    public function setCallingPartyTransformationMask($callingPartyTransformationMask = null)
    {
        // validation for constraint: string
        if (!is_null($callingPartyTransformationMask) && !is_string($callingPartyTransformationMask)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($callingPartyTransformationMask)), __LINE__);
        }
        if (is_null($callingPartyTransformationMask) || (is_array($callingPartyTransformationMask) && empty($callingPartyTransformationMask))) {
            unset($this->callingPartyTransformationMask);
        } else {
            $this->callingPartyTransformationMask = $callingPartyTransformationMask;
        }
        return $this;
    }
    /**
     * Get callingPartyPrefixDigits value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCallingPartyPrefixDigits()
    {
        return isset($this->callingPartyPrefixDigits) ? $this->callingPartyPrefixDigits : null;
    }
    /**
     * Set callingPartyPrefixDigits value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $callingPartyPrefixDigits
     * @return XRoutePattern
     */
    public function setCallingPartyPrefixDigits($callingPartyPrefixDigits = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($callingPartyPrefixDigits) && strlen($callingPartyPrefixDigits) > 50) || (is_array($callingPartyPrefixDigits) && count($callingPartyPrefixDigits) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($callingPartyPrefixDigits) ? strlen($callingPartyPrefixDigits) : count($callingPartyPrefixDigits)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($callingPartyPrefixDigits) && !is_string($callingPartyPrefixDigits)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($callingPartyPrefixDigits)), __LINE__);
        }
        if (is_null($callingPartyPrefixDigits) || (is_array($callingPartyPrefixDigits) && empty($callingPartyPrefixDigits))) {
            unset($this->callingPartyPrefixDigits);
        } else {
            $this->callingPartyPrefixDigits = $callingPartyPrefixDigits;
        }
        return $this;
    }
    /**
     * Get patternUrgency value
     * @return string|null
     */
    public function getPatternUrgency()
    {
        return $this->patternUrgency;
    }
    /**
     * Set patternUrgency value
     * @param string $patternUrgency
     * @return XRoutePattern
     */
    public function setPatternUrgency($patternUrgency = null)
    {
        // validation for constraint: pattern
        if (is_scalar($patternUrgency) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $patternUrgency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($patternUrgency, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($patternUrgency) && !is_string($patternUrgency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($patternUrgency)), __LINE__);
        }
        $this->patternUrgency = $patternUrgency;
        return $this;
    }
    /**
     * Get callingLinePresentationBit value
     * @return string|null
     */
    public function getCallingLinePresentationBit()
    {
        return $this->callingLinePresentationBit;
    }
    /**
     * Set callingLinePresentationBit value
     * @uses XPresentationBit::valueIsValid()
     * @uses XPresentationBit::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callingLinePresentationBit
     * @return XRoutePattern
     */
    public function setCallingLinePresentationBit($callingLinePresentationBit = 'Default')
    {
        // validation for constraint: enumeration
        if (!XPresentationBit::valueIsValid($callingLinePresentationBit)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $callingLinePresentationBit, implode(', ', XPresentationBit::getValidValues())), __LINE__);
        }
        $this->callingLinePresentationBit = $callingLinePresentationBit;
        return $this;
    }
    /**
     * Get callingNamePresentationBit value
     * @return string|null
     */
    public function getCallingNamePresentationBit()
    {
        return $this->callingNamePresentationBit;
    }
    /**
     * Set callingNamePresentationBit value
     * @uses XPresentationBit::valueIsValid()
     * @uses XPresentationBit::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callingNamePresentationBit
     * @return XRoutePattern
     */
    public function setCallingNamePresentationBit($callingNamePresentationBit = 'Default')
    {
        // validation for constraint: enumeration
        if (!XPresentationBit::valueIsValid($callingNamePresentationBit)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $callingNamePresentationBit, implode(', ', XPresentationBit::getValidValues())), __LINE__);
        }
        $this->callingNamePresentationBit = $callingNamePresentationBit;
        return $this;
    }
    /**
     * Get connectedLinePresentationBit value
     * @return string|null
     */
    public function getConnectedLinePresentationBit()
    {
        return $this->connectedLinePresentationBit;
    }
    /**
     * Set connectedLinePresentationBit value
     * @uses XPresentationBit::valueIsValid()
     * @uses XPresentationBit::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $connectedLinePresentationBit
     * @return XRoutePattern
     */
    public function setConnectedLinePresentationBit($connectedLinePresentationBit = 'Default')
    {
        // validation for constraint: enumeration
        if (!XPresentationBit::valueIsValid($connectedLinePresentationBit)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $connectedLinePresentationBit, implode(', ', XPresentationBit::getValidValues())), __LINE__);
        }
        $this->connectedLinePresentationBit = $connectedLinePresentationBit;
        return $this;
    }
    /**
     * Get connectedNamePresentationBit value
     * @return string|null
     */
    public function getConnectedNamePresentationBit()
    {
        return $this->connectedNamePresentationBit;
    }
    /**
     * Set connectedNamePresentationBit value
     * @uses XPresentationBit::valueIsValid()
     * @uses XPresentationBit::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $connectedNamePresentationBit
     * @return XRoutePattern
     */
    public function setConnectedNamePresentationBit($connectedNamePresentationBit = 'Default')
    {
        // validation for constraint: enumeration
        if (!XPresentationBit::valueIsValid($connectedNamePresentationBit)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $connectedNamePresentationBit, implode(', ', XPresentationBit::getValidValues())), __LINE__);
        }
        $this->connectedNamePresentationBit = $connectedNamePresentationBit;
        return $this;
    }
    /**
     * Get supportOverlapSending value
     * @return string|null
     */
    public function getSupportOverlapSending()
    {
        return $this->supportOverlapSending;
    }
    /**
     * Set supportOverlapSending value
     * @param string $supportOverlapSending
     * @return XRoutePattern
     */
    public function setSupportOverlapSending($supportOverlapSending = null)
    {
        // validation for constraint: pattern
        if (is_scalar($supportOverlapSending) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $supportOverlapSending)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($supportOverlapSending, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($supportOverlapSending) && !is_string($supportOverlapSending)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($supportOverlapSending)), __LINE__);
        }
        $this->supportOverlapSending = $supportOverlapSending;
        return $this;
    }
    /**
     * Get patternPrecedence value
     * @return string|null
     */
    public function getPatternPrecedence()
    {
        return $this->patternPrecedence;
    }
    /**
     * Set patternPrecedence value
     * @uses XPatternPrecedence::valueIsValid()
     * @uses XPatternPrecedence::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $patternPrecedence
     * @return XRoutePattern
     */
    public function setPatternPrecedence($patternPrecedence = 'Default')
    {
        // validation for constraint: enumeration
        if (!XPatternPrecedence::valueIsValid($patternPrecedence)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $patternPrecedence, implode(', ', XPatternPrecedence::getValidValues())), __LINE__);
        }
        $this->patternPrecedence = $patternPrecedence;
        return $this;
    }
    /**
     * Get releaseClause value
     * @return string|null
     */
    public function getReleaseClause()
    {
        return $this->releaseClause;
    }
    /**
     * Set releaseClause value
     * @uses XReleaseCauseValue::valueIsValid()
     * @uses XReleaseCauseValue::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $releaseClause
     * @return XRoutePattern
     */
    public function setReleaseClause($releaseClause = 'No Error')
    {
        // validation for constraint: enumeration
        if (!XReleaseCauseValue::valueIsValid($releaseClause)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $releaseClause, implode(', ', XReleaseCauseValue::getValidValues())), __LINE__);
        }
        $this->releaseClause = $releaseClause;
        return $this;
    }
    /**
     * Get allowDeviceOverride value
     * @return string|null
     */
    public function getAllowDeviceOverride()
    {
        return $this->allowDeviceOverride;
    }
    /**
     * Set allowDeviceOverride value
     * @param string $allowDeviceOverride
     * @return XRoutePattern
     */
    public function setAllowDeviceOverride($allowDeviceOverride = true)
    {
        // validation for constraint: pattern
        if (is_scalar($allowDeviceOverride) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $allowDeviceOverride)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($allowDeviceOverride, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($allowDeviceOverride) && !is_string($allowDeviceOverride)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($allowDeviceOverride)), __LINE__);
        }
        $this->allowDeviceOverride = $allowDeviceOverride;
        return $this;
    }
    /**
     * Get provideOutsideDialtone value
     * @return string|null
     */
    public function getProvideOutsideDialtone()
    {
        return $this->provideOutsideDialtone;
    }
    /**
     * Set provideOutsideDialtone value
     * @param string $provideOutsideDialtone
     * @return XRoutePattern
     */
    public function setProvideOutsideDialtone($provideOutsideDialtone = true)
    {
        // validation for constraint: pattern
        if (is_scalar($provideOutsideDialtone) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $provideOutsideDialtone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($provideOutsideDialtone, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($provideOutsideDialtone) && !is_string($provideOutsideDialtone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($provideOutsideDialtone)), __LINE__);
        }
        $this->provideOutsideDialtone = $provideOutsideDialtone;
        return $this;
    }
    /**
     * Get callingPartyNumberingPlan value
     * @return string|null
     */
    public function getCallingPartyNumberingPlan()
    {
        return $this->callingPartyNumberingPlan;
    }
    /**
     * Set callingPartyNumberingPlan value
     * @uses XNumberingPlan::valueIsValid()
     * @uses XNumberingPlan::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callingPartyNumberingPlan
     * @return XRoutePattern
     */
    public function setCallingPartyNumberingPlan($callingPartyNumberingPlan = 'Cisco CallManager')
    {
        // validation for constraint: enumeration
        if (!XNumberingPlan::valueIsValid($callingPartyNumberingPlan)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $callingPartyNumberingPlan, implode(', ', XNumberingPlan::getValidValues())), __LINE__);
        }
        $this->callingPartyNumberingPlan = $callingPartyNumberingPlan;
        return $this;
    }
    /**
     * Get callingPartyNumberType value
     * @return string|null
     */
    public function getCallingPartyNumberType()
    {
        return $this->callingPartyNumberType;
    }
    /**
     * Set callingPartyNumberType value
     * @uses XPriOfNumber::valueIsValid()
     * @uses XPriOfNumber::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callingPartyNumberType
     * @return XRoutePattern
     */
    public function setCallingPartyNumberType($callingPartyNumberType = 'Cisco CallManager')
    {
        // validation for constraint: enumeration
        if (!XPriOfNumber::valueIsValid($callingPartyNumberType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $callingPartyNumberType, implode(', ', XPriOfNumber::getValidValues())), __LINE__);
        }
        $this->callingPartyNumberType = $callingPartyNumberType;
        return $this;
    }
    /**
     * Get calledPartyNumberingPlan value
     * @return string|null
     */
    public function getCalledPartyNumberingPlan()
    {
        return $this->calledPartyNumberingPlan;
    }
    /**
     * Set calledPartyNumberingPlan value
     * @uses XNumberingPlan::valueIsValid()
     * @uses XNumberingPlan::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $calledPartyNumberingPlan
     * @return XRoutePattern
     */
    public function setCalledPartyNumberingPlan($calledPartyNumberingPlan = 'Cisco CallManager')
    {
        // validation for constraint: enumeration
        if (!XNumberingPlan::valueIsValid($calledPartyNumberingPlan)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $calledPartyNumberingPlan, implode(', ', XNumberingPlan::getValidValues())), __LINE__);
        }
        $this->calledPartyNumberingPlan = $calledPartyNumberingPlan;
        return $this;
    }
    /**
     * Get calledPartyNumberType value
     * @return string|null
     */
    public function getCalledPartyNumberType()
    {
        return $this->calledPartyNumberType;
    }
    /**
     * Set calledPartyNumberType value
     * @uses XPriOfNumber::valueIsValid()
     * @uses XPriOfNumber::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $calledPartyNumberType
     * @return XRoutePattern
     */
    public function setCalledPartyNumberType($calledPartyNumberType = 'Cisco CallManager')
    {
        // validation for constraint: enumeration
        if (!XPriOfNumber::valueIsValid($calledPartyNumberType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $calledPartyNumberType, implode(', ', XPriOfNumber::getValidValues())), __LINE__);
        }
        $this->calledPartyNumberType = $calledPartyNumberType;
        return $this;
    }
    /**
     * Get authorizationCodeRequired value
     * @return string|null
     */
    public function getAuthorizationCodeRequired()
    {
        return $this->authorizationCodeRequired;
    }
    /**
     * Set authorizationCodeRequired value
     * @param string $authorizationCodeRequired
     * @return XRoutePattern
     */
    public function setAuthorizationCodeRequired($authorizationCodeRequired = null)
    {
        // validation for constraint: pattern
        if (is_scalar($authorizationCodeRequired) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $authorizationCodeRequired)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($authorizationCodeRequired, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($authorizationCodeRequired) && !is_string($authorizationCodeRequired)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($authorizationCodeRequired)), __LINE__);
        }
        $this->authorizationCodeRequired = $authorizationCodeRequired;
        return $this;
    }
    /**
     * Get authorizationLevelRequired value
     * @return string|null
     */
    public function getAuthorizationLevelRequired()
    {
        return $this->authorizationLevelRequired;
    }
    /**
     * Set authorizationLevelRequired value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $authorizationLevelRequired
     * @return XRoutePattern
     */
    public function setAuthorizationLevelRequired($authorizationLevelRequired = '0')
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($authorizationLevelRequired)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $authorizationLevelRequired, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->authorizationLevelRequired = $authorizationLevelRequired;
        return $this;
    }
    /**
     * Get clientCodeRequired value
     * @return string|null
     */
    public function getClientCodeRequired()
    {
        return $this->clientCodeRequired;
    }
    /**
     * Set clientCodeRequired value
     * @param string $clientCodeRequired
     * @return XRoutePattern
     */
    public function setClientCodeRequired($clientCodeRequired = null)
    {
        // validation for constraint: pattern
        if (is_scalar($clientCodeRequired) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $clientCodeRequired)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($clientCodeRequired, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($clientCodeRequired) && !is_string($clientCodeRequired)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($clientCodeRequired)), __LINE__);
        }
        $this->clientCodeRequired = $clientCodeRequired;
        return $this;
    }
    /**
     * Get isdnNsfInfoElement value
     * @return IsdnNsfInfoElement|null
     */
    public function getIsdnNsfInfoElement()
    {
        return $this->isdnNsfInfoElement;
    }
    /**
     * Set isdnNsfInfoElement value
     * @param IsdnNsfInfoElement $isdnNsfInfoElement
     * @return XRoutePattern
     */
    public function setIsdnNsfInfoElement(IsdnNsfInfoElement $isdnNsfInfoElement = null)
    {
        $this->isdnNsfInfoElement = $isdnNsfInfoElement;
        return $this;
    }
    /**
     * Get resourcePriorityNamespaceName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getResourcePriorityNamespaceName()
    {
        return isset($this->resourcePriorityNamespaceName) ? $this->resourcePriorityNamespaceName : null;
    }
    /**
     * Set resourcePriorityNamespaceName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $resourcePriorityNamespaceName
     * @return XRoutePattern
     */
    public function setResourcePriorityNamespaceName(XFkType $resourcePriorityNamespaceName = null)
    {
        if (is_null($resourcePriorityNamespaceName) || (is_array($resourcePriorityNamespaceName) && empty($resourcePriorityNamespaceName))) {
            unset($this->resourcePriorityNamespaceName);
        } else {
            $this->resourcePriorityNamespaceName = $resourcePriorityNamespaceName;
        }
        return $this;
    }
    /**
     * Get routeClass value
     * @return string|null
     */
    public function getRouteClass()
    {
        return $this->routeClass;
    }
    /**
     * Set routeClass value
     * @uses XPatternRouteClass::valueIsValid()
     * @uses XPatternRouteClass::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $routeClass
     * @return XRoutePattern
     */
    public function setRouteClass($routeClass = 'Default')
    {
        // validation for constraint: enumeration
        if (!XPatternRouteClass::valueIsValid($routeClass)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $routeClass, implode(', ', XPatternRouteClass::getValidValues())), __LINE__);
        }
        $this->routeClass = $routeClass;
        return $this;
    }
    /**
     * Get enableDccEnforcement value
     * @return string|null
     */
    public function getEnableDccEnforcement()
    {
        return $this->enableDccEnforcement;
    }
    /**
     * Set enableDccEnforcement value
     * @param string $enableDccEnforcement
     * @return XRoutePattern
     */
    public function setEnableDccEnforcement($enableDccEnforcement = null)
    {
        // validation for constraint: pattern
        if (is_scalar($enableDccEnforcement) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $enableDccEnforcement)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($enableDccEnforcement, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($enableDccEnforcement) && !is_string($enableDccEnforcement)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($enableDccEnforcement)), __LINE__);
        }
        $this->enableDccEnforcement = $enableDccEnforcement;
        return $this;
    }
    /**
     * Get blockedCallPercentage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBlockedCallPercentage()
    {
        return isset($this->blockedCallPercentage) ? $this->blockedCallPercentage : null;
    }
    /**
     * Set blockedCallPercentage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $blockedCallPercentage
     * @return XRoutePattern
     */
    public function setBlockedCallPercentage($blockedCallPercentage = null)
    {
        // validation for constraint: string
        if (!is_null($blockedCallPercentage) && !is_string($blockedCallPercentage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($blockedCallPercentage)), __LINE__);
        }
        if (is_null($blockedCallPercentage) || (is_array($blockedCallPercentage) && empty($blockedCallPercentage))) {
            unset($this->blockedCallPercentage);
        } else {
            $this->blockedCallPercentage = $blockedCallPercentage;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return XRoutePattern
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
