<?php
/**
 * This class stands for XRisStatus EnumType
 * @subpackage Enumerations
 */
class XRisStatus
{
    /**
     * Constant for value 'Unknown'
     * @return string 'Unknown'
     */
    const VALUE_UNKNOWN = 'Unknown';
    /**
     * Constant for value 'Registered'
     * @return string 'Registered'
     */
    const VALUE_REGISTERED = 'Registered';
    /**
     * Constant for value 'Unregistered'
     * @return string 'Unregistered'
     */
    const VALUE_UNREGISTERED = 'Unregistered';
    /**
     * Constant for value 'Rejected'
     * @return string 'Rejected'
     */
    const VALUE_REJECTED = 'Rejected';
    /**
     * Constant for value 'Partial Registered'
     * @return string 'Partial Registered'
     */
    const VALUE_PARTIAL_REGISTERED = 'Partial Registered';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_UNKNOWN
     * @uses self::VALUE_REGISTERED
     * @uses self::VALUE_UNREGISTERED
     * @uses self::VALUE_REJECTED
     * @uses self::VALUE_PARTIAL_REGISTERED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_UNKNOWN,
            self::VALUE_REGISTERED,
            self::VALUE_UNREGISTERED,
            self::VALUE_REJECTED,
            self::VALUE_PARTIAL_REGISTERED,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
