<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XRegion StructType
 * @subpackage Structs
 */
class XRegion extends AbstractStructBase
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - maxLength: 50
     * @var string
     */
    public $name;
    /**
     * The relatedRegions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var RelatedRegions
     */
    public $relatedRegions;
    /**
     * The defaultCodec
     * Meta informations extracted from the WSDL
     * - documentation: Not valid for get and list
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $defaultCodec;
    /**
     * Constructor method for XRegion
     * @uses XRegion::setName()
     * @uses XRegion::setRelatedRegions()
     * @uses XRegion::setDefaultCodec()
     * @param string $name
     * @param RelatedRegions $relatedRegions
     * @param string $defaultCodec
     */
    public function __construct($name = null, RelatedRegions $relatedRegions = null, $defaultCodec = null)
    {
        $this
            ->setName($name)
            ->setRelatedRegions($relatedRegions)
            ->setDefaultCodec($defaultCodec);
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return XRegion
     */
    public function setName($name = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($name) && strlen($name) > 50) || (is_array($name) && count($name) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($name) ? strlen($name) : count($name)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get relatedRegions value
     * @return RelatedRegions|null
     */
    public function getRelatedRegions()
    {
        return $this->relatedRegions;
    }
    /**
     * Set relatedRegions value
     * @param RelatedRegions $relatedRegions
     * @return XRegion
     */
    public function setRelatedRegions(RelatedRegions $relatedRegions = null)
    {
        $this->relatedRegions = $relatedRegions;
        return $this;
    }
    /**
     * Get defaultCodec value
     * @return string|null
     */
    public function getDefaultCodec()
    {
        return $this->defaultCodec;
    }
    /**
     * Set defaultCodec value
     * @uses XBandwidth::valueIsValid()
     * @uses XBandwidth::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $defaultCodec
     * @return XRegion
     */
    public function setDefaultCodec($defaultCodec = null)
    {
        // validation for constraint: enumeration
        if (!XBandwidth::valueIsValid($defaultCodec)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $defaultCodec, implode(', ', XBandwidth::getValidValues())), __LINE__);
        }
        $this->defaultCodec = $defaultCodec;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return XRegion
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
