<?php
/**
 * This class stands for XRangeSet EnumType
 * @subpackage Enumerations
 */
class XRangeSet
{
    /**
     * Constant for value 'Active Range'
     * @return string 'Active Range'
     */
    const VALUE_ACTIVE_RANGE = 'Active Range';
    /**
     * Constant for value 'Next Range'
     * @return string 'Next Range'
     */
    const VALUE_NEXT_RANGE = 'Next Range';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ACTIVE_RANGE
     * @uses self::VALUE_NEXT_RANGE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ACTIVE_RANGE,
            self::VALUE_NEXT_RANGE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
