<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XProcessNodeService StructType
 * @subpackage Structs
 */
class XProcessNodeService extends AbstractStructBase
{
    /**
     * The processNodeName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var XFkType
     */
    public $processNodeName;
    /**
     * The service
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $service;
    /**
     * The traceLevel
     * Meta informations extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $traceLevel;
    /**
     * The userCategories
     * Meta informations extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $userCategories;
    /**
     * The enable
     * Meta informations extracted from the WSDL
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enable;
    /**
     * The numFiles
     * Meta informations extracted from the WSDL
     * - default: 250
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $numFiles;
    /**
     * The maxFileSize
     * Meta informations extracted from the WSDL
     * - default: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $maxFileSize;
    /**
     * Constructor method for XProcessNodeService
     * @uses XProcessNodeService::setProcessNodeName()
     * @uses XProcessNodeService::setService()
     * @uses XProcessNodeService::setTraceLevel()
     * @uses XProcessNodeService::setUserCategories()
     * @uses XProcessNodeService::setEnable()
     * @uses XProcessNodeService::setNumFiles()
     * @uses XProcessNodeService::setMaxFileSize()
     * @param XFkType $processNodeName
     * @param string $service
     * @param string $traceLevel
     * @param string $userCategories
     * @param string $enable
     * @param string $numFiles
     * @param string $maxFileSize
     */
    public function __construct(XFkType $processNodeName = null, $service = null, $traceLevel = '0', $userCategories = '0', $enable = false, $numFiles = '250', $maxFileSize = '1')
    {
        $this
            ->setProcessNodeName($processNodeName)
            ->setService($service)
            ->setTraceLevel($traceLevel)
            ->setUserCategories($userCategories)
            ->setEnable($enable)
            ->setNumFiles($numFiles)
            ->setMaxFileSize($maxFileSize);
    }
    /**
     * Get processNodeName value
     * @return XFkType
     */
    public function getProcessNodeName()
    {
        return $this->processNodeName;
    }
    /**
     * Set processNodeName value
     * @param XFkType $processNodeName
     * @return XProcessNodeService
     */
    public function setProcessNodeName(XFkType $processNodeName = null)
    {
        $this->processNodeName = $processNodeName;
        return $this;
    }
    /**
     * Get service value
     * @return string
     */
    public function getService()
    {
        return $this->service;
    }
    /**
     * Set service value
     * @uses XService::valueIsValid()
     * @uses XService::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $service
     * @return XProcessNodeService
     */
    public function setService($service = null)
    {
        // validation for constraint: enumeration
        if (!XService::valueIsValid($service)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $service, implode(', ', XService::getValidValues())), __LINE__);
        }
        $this->service = $service;
        return $this;
    }
    /**
     * Get traceLevel value
     * @return string|null
     */
    public function getTraceLevel()
    {
        return $this->traceLevel;
    }
    /**
     * Set traceLevel value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $traceLevel
     * @return XProcessNodeService
     */
    public function setTraceLevel($traceLevel = '0')
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($traceLevel)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $traceLevel, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->traceLevel = $traceLevel;
        return $this;
    }
    /**
     * Get userCategories value
     * @return string|null
     */
    public function getUserCategories()
    {
        return $this->userCategories;
    }
    /**
     * Set userCategories value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $userCategories
     * @return XProcessNodeService
     */
    public function setUserCategories($userCategories = '0')
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($userCategories)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $userCategories, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->userCategories = $userCategories;
        return $this;
    }
    /**
     * Get enable value
     * @return string|null
     */
    public function getEnable()
    {
        return $this->enable;
    }
    /**
     * Set enable value
     * @param string $enable
     * @return XProcessNodeService
     */
    public function setEnable($enable = false)
    {
        // validation for constraint: pattern
        if (is_scalar($enable) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $enable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($enable, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($enable) && !is_string($enable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($enable)), __LINE__);
        }
        $this->enable = $enable;
        return $this;
    }
    /**
     * Get numFiles value
     * @return string|null
     */
    public function getNumFiles()
    {
        return $this->numFiles;
    }
    /**
     * Set numFiles value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $numFiles
     * @return XProcessNodeService
     */
    public function setNumFiles($numFiles = '250')
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($numFiles)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $numFiles, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->numFiles = $numFiles;
        return $this;
    }
    /**
     * Get maxFileSize value
     * @return string|null
     */
    public function getMaxFileSize()
    {
        return $this->maxFileSize;
    }
    /**
     * Set maxFileSize value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $maxFileSize
     * @return XProcessNodeService
     */
    public function setMaxFileSize($maxFileSize = '1')
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($maxFileSize)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $maxFileSize, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->maxFileSize = $maxFileSize;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return XProcessNodeService
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
