<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XPolicyRelationship StructType
 * @subpackage Structs
 */
class XPolicyRelationship extends AbstractStructBase
{
    /**
     * The geoLocationPolicyAName
     * Meta informations extracted from the WSDL
     * - documentation: This is a read only tag. The value will be the currently added GeoLocationPolicy pkid.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var XFkType
     */
    public $geoLocationPolicyAName;
    /**
     * The geoLocationDeviceA
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $geoLocationDeviceA;
    /**
     * The geoLocationPolicyBName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var XFkType
     */
    public $geoLocationPolicyBName;
    /**
     * The geoLocationDeviceB
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $geoLocationDeviceB;
    /**
     * The logicalPartitionPolicy
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $logicalPartitionPolicy;
    /**
     * Constructor method for XPolicyRelationship
     * @uses XPolicyRelationship::setGeoLocationPolicyAName()
     * @uses XPolicyRelationship::setGeoLocationDeviceA()
     * @uses XPolicyRelationship::setGeoLocationPolicyBName()
     * @uses XPolicyRelationship::setGeoLocationDeviceB()
     * @uses XPolicyRelationship::setLogicalPartitionPolicy()
     * @param XFkType $geoLocationPolicyAName
     * @param string $geoLocationDeviceA
     * @param XFkType $geoLocationPolicyBName
     * @param string $geoLocationDeviceB
     * @param string $logicalPartitionPolicy
     */
    public function __construct(XFkType $geoLocationPolicyAName = null, $geoLocationDeviceA = null, XFkType $geoLocationPolicyBName = null, $geoLocationDeviceB = null, $logicalPartitionPolicy = null)
    {
        $this
            ->setGeoLocationPolicyAName($geoLocationPolicyAName)
            ->setGeoLocationDeviceA($geoLocationDeviceA)
            ->setGeoLocationPolicyBName($geoLocationPolicyBName)
            ->setGeoLocationDeviceB($geoLocationDeviceB)
            ->setLogicalPartitionPolicy($logicalPartitionPolicy);
    }
    /**
     * Get geoLocationPolicyAName value
     * @return XFkType
     */
    public function getGeoLocationPolicyAName()
    {
        return $this->geoLocationPolicyAName;
    }
    /**
     * Set geoLocationPolicyAName value
     * @param XFkType $geoLocationPolicyAName
     * @return XPolicyRelationship
     */
    public function setGeoLocationPolicyAName(XFkType $geoLocationPolicyAName = null)
    {
        $this->geoLocationPolicyAName = $geoLocationPolicyAName;
        return $this;
    }
    /**
     * Get geoLocationDeviceA value
     * @return string
     */
    public function getGeoLocationDeviceA()
    {
        return $this->geoLocationDeviceA;
    }
    /**
     * Set geoLocationDeviceA value
     * @uses XGeoLocationDevice::valueIsValid()
     * @uses XGeoLocationDevice::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $geoLocationDeviceA
     * @return XPolicyRelationship
     */
    public function setGeoLocationDeviceA($geoLocationDeviceA = null)
    {
        // validation for constraint: enumeration
        if (!XGeoLocationDevice::valueIsValid($geoLocationDeviceA)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $geoLocationDeviceA, implode(', ', XGeoLocationDevice::getValidValues())), __LINE__);
        }
        $this->geoLocationDeviceA = $geoLocationDeviceA;
        return $this;
    }
    /**
     * Get geoLocationPolicyBName value
     * @return XFkType
     */
    public function getGeoLocationPolicyBName()
    {
        return $this->geoLocationPolicyBName;
    }
    /**
     * Set geoLocationPolicyBName value
     * @param XFkType $geoLocationPolicyBName
     * @return XPolicyRelationship
     */
    public function setGeoLocationPolicyBName(XFkType $geoLocationPolicyBName = null)
    {
        $this->geoLocationPolicyBName = $geoLocationPolicyBName;
        return $this;
    }
    /**
     * Get geoLocationDeviceB value
     * @return string
     */
    public function getGeoLocationDeviceB()
    {
        return $this->geoLocationDeviceB;
    }
    /**
     * Set geoLocationDeviceB value
     * @uses XGeoLocationDevice::valueIsValid()
     * @uses XGeoLocationDevice::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $geoLocationDeviceB
     * @return XPolicyRelationship
     */
    public function setGeoLocationDeviceB($geoLocationDeviceB = null)
    {
        // validation for constraint: enumeration
        if (!XGeoLocationDevice::valueIsValid($geoLocationDeviceB)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $geoLocationDeviceB, implode(', ', XGeoLocationDevice::getValidValues())), __LINE__);
        }
        $this->geoLocationDeviceB = $geoLocationDeviceB;
        return $this;
    }
    /**
     * Get logicalPartitionPolicy value
     * @return string
     */
    public function getLogicalPartitionPolicy()
    {
        return $this->logicalPartitionPolicy;
    }
    /**
     * Set logicalPartitionPolicy value
     * @uses XLogicalPartitionPolicy::valueIsValid()
     * @uses XLogicalPartitionPolicy::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $logicalPartitionPolicy
     * @return XPolicyRelationship
     */
    public function setLogicalPartitionPolicy($logicalPartitionPolicy = null)
    {
        // validation for constraint: enumeration
        if (!XLogicalPartitionPolicy::valueIsValid($logicalPartitionPolicy)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $logicalPartitionPolicy, implode(', ', XLogicalPartitionPolicy::getValidValues())), __LINE__);
        }
        $this->logicalPartitionPolicy = $logicalPartitionPolicy;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return XPolicyRelationship
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
