<?php
/**
 * This class stands for XPlaceHolderTag EnumType
 * @subpackage Enumerations
 */
class XPlaceHolderTag
{
    /**
     * Constant for value 'Last Name'
     * @return string 'Last Name'
     */
    const VALUE_LAST_NAME = 'Last Name';
    /**
     * Constant for value 'First Name'
     * @return string 'First Name'
     */
    const VALUE_FIRST_NAME = 'First Name';
    /**
     * Constant for value 'User ID'
     * @return string 'User ID'
     */
    const VALUE_USER_ID = 'User ID';
    /**
     * Constant for value 'Primary Extension'
     * @return string 'Primary Extension'
     */
    const VALUE_PRIMARY_EXTENSION = 'Primary Extension';
    /**
     * Constant for value 'Extension'
     * @return string 'Extension'
     */
    const VALUE_EXTENSION = 'Extension';
    /**
     * Constant for value 'Line Index'
     * @return string 'Line Index'
     */
    const VALUE_LINE_INDEX = 'Line Index';
    /**
     * Constant for value 'Email'
     * @return string 'Email'
     */
    const VALUE_EMAIL = 'Email';
    /**
     * Constant for value 'Department'
     * @return string 'Department'
     */
    const VALUE_DEPARTMENT = 'Department';
    /**
     * Constant for value 'Manager'
     * @return string 'Manager'
     */
    const VALUE_MANAGER = 'Manager';
    /**
     * Constant for value 'Device Name'
     * @return string 'Device Name'
     */
    const VALUE_DEVICE_NAME = 'Device Name';
    /**
     * Constant for value 'Product Type'
     * @return string 'Product Type'
     */
    const VALUE_PRODUCT_TYPE = 'Product Type';
    /**
     * Constant for value 'Protocol Type'
     * @return string 'Protocol Type'
     */
    const VALUE_PROTOCOL_TYPE = 'Protocol Type';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_LAST_NAME
     * @uses self::VALUE_FIRST_NAME
     * @uses self::VALUE_USER_ID
     * @uses self::VALUE_PRIMARY_EXTENSION
     * @uses self::VALUE_EXTENSION
     * @uses self::VALUE_LINE_INDEX
     * @uses self::VALUE_EMAIL
     * @uses self::VALUE_DEPARTMENT
     * @uses self::VALUE_MANAGER
     * @uses self::VALUE_DEVICE_NAME
     * @uses self::VALUE_PRODUCT_TYPE
     * @uses self::VALUE_PROTOCOL_TYPE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_LAST_NAME,
            self::VALUE_FIRST_NAME,
            self::VALUE_USER_ID,
            self::VALUE_PRIMARY_EXTENSION,
            self::VALUE_EXTENSION,
            self::VALUE_LINE_INDEX,
            self::VALUE_EMAIL,
            self::VALUE_DEPARTMENT,
            self::VALUE_MANAGER,
            self::VALUE_DEVICE_NAME,
            self::VALUE_PRODUCT_TYPE,
            self::VALUE_PROTOCOL_TYPE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
