<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XNotification StructType
 * @subpackage Structs
 */
class XNotification extends AbstractStructBase
{
    /**
     * The changedObject
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var string[]
     */
    public $changedObject;
    /**
     * The object
     * Meta informations extracted from the WSDL
     * - nillable: false
     * @var string
     */
    public $object;
    /**
     * The count
     * Meta informations extracted from the WSDL
     * - nillable: false
     * @var string
     */
    public $count;
    /**
     * Constructor method for XNotification
     * @uses XNotification::setChangedObject()
     * @uses XNotification::setObject()
     * @uses XNotification::setCount()
     * @param string[] $changedObject
     * @param string $object
     * @param string $count
     */
    public function __construct(array $changedObject = array(), $object = null, $count = null)
    {
        $this
            ->setChangedObject($changedObject)
            ->setObject($object)
            ->setCount($count);
    }
    /**
     * Get changedObject value
     * @return string[]
     */
    public function getChangedObject()
    {
        return $this->changedObject;
    }
    /**
     * Set changedObject value
     * @throws \InvalidArgumentException
     * @param string[] $changedObject
     * @return XNotification
     */
    public function setChangedObject(array $changedObject = array())
    {
        foreach ($changedObject as $xNotificationChangedObjectItem) {
            // validation for constraint: itemType
            if (!is_string($xNotificationChangedObjectItem)) {
                throw new \InvalidArgumentException(sprintf('The changedObject property can only contain items of string, "%s" given', is_object($xNotificationChangedObjectItem) ? get_class($xNotificationChangedObjectItem) : gettype($xNotificationChangedObjectItem)), __LINE__);
            }
        }
        $this->changedObject = $changedObject;
        return $this;
    }
    /**
     * Add item to changedObject value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return XNotification
     */
    public function addToChangedObject($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The changedObject property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->changedObject[] = $item;
        return $this;
    }
    /**
     * Get object value
     * @return string|null
     */
    public function getObject()
    {
        return $this->object;
    }
    /**
     * Set object value
     * @param string $object
     * @return XNotification
     */
    public function setObject($object = null)
    {
        // validation for constraint: string
        if (!is_null($object) && !is_string($object)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($object)), __LINE__);
        }
        $this->object = $object;
        return $this;
    }
    /**
     * Get count value
     * @return string|null
     */
    public function getCount()
    {
        return $this->count;
    }
    /**
     * Set count value
     * @param string $count
     * @return XNotification
     */
    public function setCount($count = null)
    {
        // validation for constraint: string
        if (!is_null($count) && !is_string($count)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($count)), __LINE__);
        }
        $this->count = $count;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return XNotification
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
