<?php
/**
 * This class stands for XNSFService EnumType
 * @subpackage Enumerations
 */
class XNSFService
{
    /**
     * Constant for value 'ACCUNET Switched Digital Service'
     * @return string 'ACCUNET Switched Digital Service'
     */
    const VALUE_ACCUNET_SWITCHED_DIGITAL_SERVICE = 'ACCUNET Switched Digital Service';
    /**
     * Constant for value 'Billing Number Only'
     * @return string 'Billing Number Only'
     */
    const VALUE_BILLING_NUMBER_ONLY = 'Billing Number Only';
    /**
     * Constant for value 'Billing Number Preferred'
     * @return string 'Billing Number Preferred'
     */
    const VALUE_BILLING_NUMBER_PREFERRED = 'Billing Number Preferred';
    /**
     * Constant for value 'Calling Party Number Only'
     * @return string 'Calling Party Number Only'
     */
    const VALUE_CALLING_PARTY_NUMBER_ONLY = 'Calling Party Number Only';
    /**
     * Constant for value 'Calling Party Number Preferred'
     * @return string 'Calling Party Number Preferred'
     */
    const VALUE_CALLING_PARTY_NUMBER_PREFERRED = 'Calling Party Number Preferred';
    /**
     * Constant for value 'Foreign Exchange'
     * @return string 'Foreign Exchange'
     */
    const VALUE_FOREIGN_EXCHANGE = 'Foreign Exchange';
    /**
     * Constant for value 'Foreign Exchange Selection'
     * @return string 'Foreign Exchange Selection'
     */
    const VALUE_FOREIGN_EXCHANGE_SELECTION = 'Foreign Exchange Selection';
    /**
     * Constant for value 'International Long Distance Service'
     * @return string 'International Long Distance Service'
     */
    const VALUE_INTERNATIONAL_LONG_DISTANCE_SERVICE = 'International Long Distance Service';
    /**
     * Constant for value 'InterLATAOUTWATS'
     * @return string 'InterLATAOUTWATS'
     */
    const VALUE_INTER_LATAOUTWATS = 'InterLATAOUTWATS';
    /**
     * Constant for value 'IntraLATAOUTWATS'
     * @return string 'IntraLATAOUTWATS'
     */
    const VALUE_INTRA_LATAOUTWATS = 'IntraLATAOUTWATS';
    /**
     * Constant for value 'Long Distance Service'
     * @return string 'Long Distance Service'
     */
    const VALUE_LONG_DISTANCE_SERVICE = 'Long Distance Service';
    /**
     * Constant for value 'MEGACOM Telecom Service'
     * @return string 'MEGACOM Telecom Service'
     */
    const VALUE_MEGACOM_TELECOM_SERVICE = 'MEGACOM Telecom Service';
    /**
     * Constant for value 'National ISDN Banded OUTWATS'
     * @return string 'National ISDN Banded OUTWATS'
     */
    const VALUE_NATIONAL_ISDN_BANDED_OUTWATS = 'National ISDN Banded OUTWATS';
    /**
     * Constant for value 'National ISDN Unbanded OUTWATS'
     * @return string 'National ISDN Unbanded OUTWATS'
     */
    const VALUE_NATIONAL_ISDN_UNBANDED_OUTWATS = 'National ISDN Unbanded OUTWATS';
    /**
     * Constant for value 'OUTWATS Selection'
     * @return string 'OUTWATS Selection'
     */
    const VALUE_OUTWATS_SELECTION = 'OUTWATS Selection';
    /**
     * Constant for value 'Private'
     * @return string 'Private'
     */
    const VALUE_PRIVATE = 'Private';
    /**
     * Constant for value 'Private Selection'
     * @return string 'Private Selection'
     */
    const VALUE_PRIVATE_SELECTION = 'Private Selection';
    /**
     * Constant for value 'Software Defined Network'
     * @return string 'Software Defined Network'
     */
    const VALUE_SOFTWARE_DEFINED_NETWORK = 'Software Defined Network';
    /**
     * Constant for value 'Tie Trunk (Cut-through)'
     * @return string 'Tie Trunk (Cut-through)'
     */
    const VALUE_TIE_TRUNK_CUT_THROUGH = 'Tie Trunk (Cut-through)';
    /**
     * Constant for value 'Tie Trunk (Senderized)'
     * @return string 'Tie Trunk (Senderized)'
     */
    const VALUE_TIE_TRUNK_SENDERIZED = 'Tie Trunk (Senderized)';
    /**
     * Constant for value 'Tie Trunk Selection (Cut-through)'
     * @return string 'Tie Trunk Selection (Cut-through)'
     */
    const VALUE_TIE_TRUNK_SELECTION_CUT_THROUGH = 'Tie Trunk Selection (Cut-through)';
    /**
     * Constant for value 'Tie Trunk Selection (Senderized)'
     * @return string 'Tie Trunk Selection (Senderized)'
     */
    const VALUE_TIE_TRUNK_SELECTION_SENDERIZED = 'Tie Trunk Selection (Senderized)';
    /**
     * Constant for value 'WATS Band Selection'
     * @return string 'WATS Band Selection'
     */
    const VALUE_WATS_BAND_SELECTION = 'WATS Band Selection';
    /**
     * Constant for value 'WATS Maximal Subscribed Band'
     * @return string 'WATS Maximal Subscribed Band'
     */
    const VALUE_WATS_MAXIMAL_SUBSCRIBED_BAND = 'WATS Maximal Subscribed Band';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ACCUNET_SWITCHED_DIGITAL_SERVICE
     * @uses self::VALUE_BILLING_NUMBER_ONLY
     * @uses self::VALUE_BILLING_NUMBER_PREFERRED
     * @uses self::VALUE_CALLING_PARTY_NUMBER_ONLY
     * @uses self::VALUE_CALLING_PARTY_NUMBER_PREFERRED
     * @uses self::VALUE_FOREIGN_EXCHANGE
     * @uses self::VALUE_FOREIGN_EXCHANGE_SELECTION
     * @uses self::VALUE_INTERNATIONAL_LONG_DISTANCE_SERVICE
     * @uses self::VALUE_INTER_LATAOUTWATS
     * @uses self::VALUE_INTRA_LATAOUTWATS
     * @uses self::VALUE_LONG_DISTANCE_SERVICE
     * @uses self::VALUE_MEGACOM_TELECOM_SERVICE
     * @uses self::VALUE_NATIONAL_ISDN_BANDED_OUTWATS
     * @uses self::VALUE_NATIONAL_ISDN_UNBANDED_OUTWATS
     * @uses self::VALUE_OUTWATS_SELECTION
     * @uses self::VALUE_PRIVATE
     * @uses self::VALUE_PRIVATE_SELECTION
     * @uses self::VALUE_SOFTWARE_DEFINED_NETWORK
     * @uses self::VALUE_TIE_TRUNK_CUT_THROUGH
     * @uses self::VALUE_TIE_TRUNK_SENDERIZED
     * @uses self::VALUE_TIE_TRUNK_SELECTION_CUT_THROUGH
     * @uses self::VALUE_TIE_TRUNK_SELECTION_SENDERIZED
     * @uses self::VALUE_WATS_BAND_SELECTION
     * @uses self::VALUE_WATS_MAXIMAL_SUBSCRIBED_BAND
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ACCUNET_SWITCHED_DIGITAL_SERVICE,
            self::VALUE_BILLING_NUMBER_ONLY,
            self::VALUE_BILLING_NUMBER_PREFERRED,
            self::VALUE_CALLING_PARTY_NUMBER_ONLY,
            self::VALUE_CALLING_PARTY_NUMBER_PREFERRED,
            self::VALUE_FOREIGN_EXCHANGE,
            self::VALUE_FOREIGN_EXCHANGE_SELECTION,
            self::VALUE_INTERNATIONAL_LONG_DISTANCE_SERVICE,
            self::VALUE_INTER_LATAOUTWATS,
            self::VALUE_INTRA_LATAOUTWATS,
            self::VALUE_LONG_DISTANCE_SERVICE,
            self::VALUE_MEGACOM_TELECOM_SERVICE,
            self::VALUE_NATIONAL_ISDN_BANDED_OUTWATS,
            self::VALUE_NATIONAL_ISDN_UNBANDED_OUTWATS,
            self::VALUE_OUTWATS_SELECTION,
            self::VALUE_PRIVATE,
            self::VALUE_PRIVATE_SELECTION,
            self::VALUE_SOFTWARE_DEFINED_NETWORK,
            self::VALUE_TIE_TRUNK_CUT_THROUGH,
            self::VALUE_TIE_TRUNK_SENDERIZED,
            self::VALUE_TIE_TRUNK_SELECTION_CUT_THROUGH,
            self::VALUE_TIE_TRUNK_SELECTION_SENDERIZED,
            self::VALUE_WATS_BAND_SELECTION,
            self::VALUE_WATS_MAXIMAL_SUBSCRIBED_BAND,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
