<?php
/**
 * This class stands for XLossyNetwork EnumType
 * @subpackage Enumerations
 */
class XLossyNetwork
{
    /**
     * Constant for value 'Keep Current Setting'
     * @return string 'Keep Current Setting'
     */
    const VALUE_KEEP_CURRENT_SETTING = 'Keep Current Setting';
    /**
     * Constant for value 'Use System Default'
     * @return string 'Use System Default'
     */
    const VALUE_USE_SYSTEM_DEFAULT = 'Use System Default';
    /**
     * Constant for value 'Low Loss'
     * @return string 'Low Loss'
     */
    const VALUE_LOW_LOSS = 'Low Loss';
    /**
     * Constant for value 'Lossy'
     * @return string 'Lossy'
     */
    const VALUE_LOSSY = 'Lossy';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_KEEP_CURRENT_SETTING
     * @uses self::VALUE_USE_SYSTEM_DEFAULT
     * @uses self::VALUE_LOW_LOSS
     * @uses self::VALUE_LOSSY
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_KEEP_CURRENT_SETTING,
            self::VALUE_USE_SYSTEM_DEFAULT,
            self::VALUE_LOW_LOSS,
            self::VALUE_LOSSY,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
